package com.chartbeat.androidsdk;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;

import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;

import org.json.JSONObject;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by joe on 1/9/19.
 */

public class AwsLogger {
    private String  DEFAULT_BUCKET = "chartbeat-sdk";
    private String IDENTITYPOOLID = "us-east-1:89109093-5e56-4960-928b-5edc0e63a985";
    private Regions S3__REGIONS = Regions.US_EAST_1;
    private Regions IDENTITY_POOL_REGIONS = Regions.US_EAST_1;
    private TransferUtility transferUtility;

    private String cacheDirectory = "";

    private static AwsLogger single_instance = null;
    private String accountId = "";
    private String domain = "";

    private String version_code = "";
    private String version_name = "";
    private String sdk_version_code = "";
    private String sdk_version_name = "";
    private String os_version = "";
    private String manufacturer = "";
    private String model = "";
    private String hardware = "";
    private String codename = "";
    private String sdk_int = "";
    private String incremental = "";
    private String release = "";
    private String security_patch = "";

    private AwsLogger(Context context, String accountId, String domain) {

        this.accountId = accountId;
        this.domain = domain;

        // Setup aws connection
        CognitoCachingCredentialsProvider credentialsProvider = new CognitoCachingCredentialsProvider(
                context,
                IDENTITYPOOLID, // Identity pool ID
                IDENTITY_POOL_REGIONS // Region
        );

        // Setup s3 connection
        AmazonS3Client s3 = new AmazonS3Client(credentialsProvider);
        s3.setRegion(Region.getRegion(S3__REGIONS));

        // Setup default bucket to write to
        transferUtility = TransferUtility.builder().context(context)
                .s3Client(s3).defaultBucket(DEFAULT_BUCKET).build();

        try {
            // Gather device, app and sdk info
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String versionName = pInfo.versionName;
            int versionCode = pInfo.versionCode;
            setVersion_code(versionCode + "");
            setVersion_name(versionName);
        } catch (Exception e) {
            // Commenting out this stack trace because it is not helpful but we wan't catch this error.
            // e.printStackTrace();
        }

        setSdk_Version_code(BuildConfig.VERSION_CODE +"");
        setSdk_Version_name(BuildConfig.VERSION_NAME);
        setOs_version(System.getProperty("os.version"));
        setManufacturer(Build.MANUFACTURER);
        setModel(Build.MODEL);
        setHardware(Build.HARDWARE);
        setSdk_int(Build.VERSION.SDK_INT +"");
        setCodename(Build.VERSION.CODENAME);
        setIncremental(Build.VERSION.INCREMENTAL);
        setRelease(Build.VERSION.RELEASE);

        if (Build.VERSION.SDK_INT > 22) {
            setSecurity_patch(Build.VERSION.SECURITY_PATCH);
        }

        setCacheDirectory(context.getCacheDir().getPath());

    }


    /**
     * This needs to be called to setup the aws logger instance.
     * @param context
     * @param accountId
     * @param domain
     * @return
     */
    public static AwsLogger initInstance(Context context, String accountId, String domain)
    {
        if (single_instance == null) {
            single_instance = new AwsLogger(context, accountId, domain);
        }

        return single_instance;
    }
    public static AwsLogger getInstance() {
        if (single_instance == null) {
            throw new NullPointerException("AwsLogger not initialized.  Call initInstance");
        }
        return single_instance;
    }


    /*
        Gets the filename and aws S3 path of the exception log entry
     */
    private String getFileName() {
        if (this.domain == "") {
            this.domain = "no_domain";
        }
        if (this.accountId == "") {
            this.accountId = "no_accountId";
        }

        String basePath = "andoroid_sdk/" + this.domain +"/" + this.accountId + "/exceptions/";

        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        int day = cal.get(Calendar.DAY_OF_MONTH);
        int hour = cal.get(Calendar.HOUR_OF_DAY);
        int min = cal.get(Calendar.MINUTE);
        String minstr = "00";
        if (min >= 30) {
            minstr = "30";
        }

        basePath = basePath + year + "/" + month + "/" + day + "/" + hour + "/" + minstr +  "/" +System.currentTimeMillis() + "_" + accountId +".json";
        return basePath;
    }


    /**
       Creates the json file from the exception and creates a temp file in the cache directory
     */
    private File getLogFile(Exception e) {

        // convert stacktrace to string
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();

        // Device date of the exception
        Date date = new Date();

        Map map = new HashMap<String, String>();
        map.put("APP_VERSION_CODE",version_code);
        map.put("APP_VERSION_NAME",version_name);
        map.put("SDK_VERSION_CODE",sdk_version_code);
        map.put("SDK_VERSION_NAME",sdk_version_name);
        map.put("os.version",os_version);
        map.put("MANUFACTURER",manufacturer);
        map.put("MODEL",model);
        map.put("HARDWARE",hardware);
        map.put("SDK_INT",sdk_int);
        map.put("CODENAME",codename);
        map.put("INCREMENTAL",incremental);
        map.put("RELEASE",release);
        map.put("SECURITY_PATCH",security_patch);
        map.put("EXCEPTION DATE",date);
        map.put("EXCEPTION",exceptionAsString);

        JSONObject json = new JSONObject(map);

        String text = json.toString();

        // Write tmp file to cache directory before uploading to aws
        File tempFile = new File(cacheDirectory + System.currentTimeMillis() + "_tmp.json") ;
        try {
            FileWriter writer=null;
            writer = new FileWriter(tempFile);
            writer.write(text);
            writer.close();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return tempFile;
    }

    /**
     * Main interface to log an exceptioin to S3
     * @param e Exception to log
     */
    public void logError(Exception e) {

        try {
            final File errorLog = getLogFile(e);
            TransferObserver uploadObserver = transferUtility.upload(
                    DEFAULT_BUCKET, /* The bucket to upload to */
                    getFileName(),  /* The key for the uploaded object */
                    errorLog);

            uploadObserver.setTransferListener(new TransferListener() {

                @Override
                public void onStateChanged(int id, TransferState state) {
                    if (TransferState.COMPLETED == state) {
                        Logger.d("AWS Logger","Upload to S3 completed");

                        // Delete file after upload
                        errorLog.delete();
                    }
                }

                @Override
                public void onProgressChanged(int id, long bytesCurrent, long bytesTotal) {
                }

                @Override
                public void onError(int id, Exception ex) {
                    ex.printStackTrace();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }

    }
    public String getCacheDirectory() {
        return cacheDirectory;
    }

    public void setCacheDirectory(String cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }


    public void setVersion_code(String version_code) {
        this.version_code = version_code;
    }

    public void setVersion_name(String version_name) {
        this.version_name = version_name;
    }
    public void setSdk_Version_code(String version_code) {
        this.sdk_version_code = version_code;
    }

    public void setSdk_Version_name(String version_name) {
        this.sdk_version_name = version_name;
    }

    public void setOs_version(String os_version) {
        this.os_version = os_version;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public void setCodename(String codename) {
        this.codename = codename;
    }

    public void setSdk_int(String sdk_int) {
        this.sdk_int = sdk_int;
    }

    public void setIncremental(String incremental) {
        this.incremental = incremental;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setSecurity_patch(String security_patch) {
        this.security_patch = security_patch;
    }


}
