/*
 * Decompiled with CFR 0.152.
 */
package treetool;

import cfml.parsing.cfml.antlr.XMLLexer;
import cfml.parsing.cfml.antlr.XMLParser;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import treetool.TextRange;
import treetool.TreeNode;

public class TreeBuilder
extends JPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private JPopupMenu popup;
    private JTextPane editor;
    private JMenuBar menuBar;
    private JFileChooser fileChooser;
    Stack<TreeNode> stacks = new Stack();
    String sourceFile;
    String fileCotent;
    TreeNode currentParent;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Source File Tree Viewer");
        frame.setDefaultCloseOperation(3);
        TreeBuilder treeBuilder = new TreeBuilder();
        frame.add(treeBuilder);
        frame.setJMenuBar(treeBuilder.menuBar);
        if (args.length != 0) {
            treeBuilder.showFile(args[0]);
        } else {
            File bar = new File("./src/cfml/parsing/cfml/antlr/input3");
            String path = bar.getAbsolutePath();
            treeBuilder.showFile(path);
        }
        frame.pack();
        frame.setSize(800, 500);
        frame.setVisible(true);
    }

    public TreeBuilder() {
        super(new GridLayout(1, 0));
        this.createTree();
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setMinimumSize(new Dimension(400, 200));
        this.editor = new JTextPane();
        this.editor.setEditable(false);
        JScrollPane editorView = new JScrollPane(this.editor);
        editorView.setMinimumSize(new Dimension(350, 200));
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(treeView);
        splitPane.setRightComponent(editorView);
        this.add(splitPane);
        this.createMenu();
        this.fileChooser = new JFileChooser();
    }

    private void createTree() {
        this.tree = new JTree(new DefaultMutableTreeNode("Choose a java source file."));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Expand all children");
        mi.addActionListener(this);
        mi.setActionCommand("expand");
        this.popup.add(mi);
        mi = new JMenuItem("Collapse all children");
        mi.addActionListener(this);
        mi.setActionCommand("collapse");
        this.popup.add(mi);
        this.popup.setOpaque(true);
        this.popup.setLightWeightPopupEnabled(true);
        this.tree.addMouseListener(this);
    }

    private void createMenu() {
        this.menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        this.menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Open File", 79);
        menuItem.setActionCommand("openfile");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuItem.addActionListener(this);
        menu.add(menuItem);
    }

    public TreeNode setCurrentParent(TreeNode newParent) {
        TreeNode oldParent = this.currentParent;
        this.currentParent = newParent;
        return oldParent;
    }

    public TreeNode getCurrentParent() {
        return this.currentParent;
    }

    public TreeNode addNode(String name, Token start, Token stop) {
        int startIndex = -1;
        int stopIndex = -1;
        if (start != null) {
            startIndex = ((CommonToken)start).getStartIndex();
        }
        if (stop != null) {
            stopIndex = ((CommonToken)stop).getStopIndex();
        }
        TreeNode node = new TreeNode((Object)name, new TextRange(startIndex, stopIndex));
        if (this.currentParent != null) {
            this.currentParent.add(node);
        }
        node.setLeaf(false);
        return node;
    }

    public TreeNode addNode(String name) {
        TreeNode node = new TreeNode(name);
        node.setLeaf(false);
        if (this.currentParent != null) {
            this.currentParent.add(node);
        }
        return node;
    }

    public TreeNode addLeaf(String name, Token token) {
        TreeNode node = new TreeNode((Object)name, new TextRange(((CommonToken)token).getStartIndex(), ((CommonToken)token).getStopIndex()));
        node.setLeaf(true);
        if (this.currentParent != null) {
            this.currentParent.add(node);
        }
        return node;
    }

    public void pushTop() {
        this.stacks.push(this.currentParent);
    }

    public TreeNode popTop() {
        TreeNode ret = this.currentParent;
        this.currentParent = this.stacks.pop();
        return ret;
    }

    public void showFile(String file) {
        this.loadFile(file);
        this.editor.setText(this.fileCotent);
        this.buildTree();
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(String file) {
        FileInputStream in = null;
        this.sourceFile = file;
        this.fileCotent = null;
        try {
            in = new FileInputStream(file);
            byte[] buf = new byte[10240];
            StringBuffer sbuf = new StringBuffer(buf.length);
            int len = in.read(buf);
            while (len > 0) {
                sbuf.append(new String(buf, 0, len));
                len = in.read(buf);
            }
            this.fileCotent = sbuf.toString();
        }
        catch (Exception e) {
            this.fileCotent = null;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void buildTree() {
        TreeNode root = new TreeNode((Object)("compilationUnit [" + this.sourceFile + "]"), new TextRange(0, this.fileCotent.length() - 1));
        try {
            XMLLexer lex = new XMLLexer((CharStream)new ANTLRStringStream(this.fileCotent));
            TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lex);
            XMLParser g = new XMLParser((TokenStream)tokens);
            this.setCurrentParent(root);
            g.compilationUnit();
        }
        catch (Exception e) {
            e.printStackTrace();
            root = new TreeNode((Object)("There are syntax error in input file. [source:" + this.sourceFile + "]"), new TextRange(-1, -1));
        }
        ((DefaultTreeModel)this.tree.getModel()).setRoot(root);
        this.tree.expandRow(0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.tree.getLastSelectedPathComponent() instanceof TreeNode) {
            TreeNode node = (TreeNode)this.tree.getLastSelectedPathComponent();
            if (node.getTextRange().start != -1 && node.getTextRange().end != -1) {
                this.editor.select(node.getTextRange().start, node.getTextRange().end + 1);
                this.editor.grabFocus();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.tree.getLastSelectedPathComponent() != null) {
            this.popup.show((JComponent)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.tree.getLastSelectedPathComponent() != null) {
            this.popup.show((JComponent)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        String cmd = e.getActionCommand();
        if ("expand".equals(cmd) || "collapse".equals(cmd)) {
            TreeNode node = (TreeNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            int row = -1;
            if (this.tree.getSelectionRows() != null) {
                row = this.tree.getSelectionRows()[0];
            }
            if (row == -1) {
                return;
            }
            if ("expand".equals(cmd)) {
                for (int i = row; i < this.tree.getRowCount(); ++i) {
                    this.tree.expandRow(i);
                }
            } else if ("collapse".equals(cmd)) {
                for (int i = this.tree.getRowCount() - 1; i >= row; --i) {
                    this.tree.collapseRow(i);
                }
            }
        } else if ("openfile".equals(cmd) && (returnVal = this.fileChooser.showOpenDialog(this)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.showFile(file.getAbsolutePath());
        }
    }
}

