/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SourceReader {
    private List<String> lineBuffer = new ArrayList<String>();
    private int lineStart;
    private int lineCount;

    public SourceReader(BufferedReader in) throws IOException {
        this(in, 0, Integer.MAX_VALUE);
    }

    public SourceReader(BufferedReader in, int _lineStart, int _lineCount) throws IOException {
        String line;
        int currentLine;
        this.lineStart = _lineStart;
        this.lineCount = _lineCount;
        if (this.lineStart < 0) {
            this.lineStart = 0;
        }
        for (currentLine = 0; currentLine < this.lineStart && in.readLine() != null; ++currentLine) {
        }
        if (currentLine != this.lineStart) {
            throw new IOException("sourceReader: not enough lines in the file");
        }
        for (int i = 0; i < this.lineCount && (line = in.readLine()) != null; ++i) {
            this.lineBuffer.add(line);
        }
    }

    public String[] getLines() {
        return this.lineBuffer.toArray(new String[this.lineBuffer.size()]);
    }

    public int getLineStart() {
        return this.lineStart;
    }
}

