/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.walker;

import cfml.CFSCRIPTParser;
import cfml.CFSCRIPTParserBaseVisitor;
import cfml.parsing.cfscript.ArgumentsVector;
import cfml.parsing.cfscript.CFAnonymousFunctionExpression;
import cfml.parsing.cfscript.CFArrayExpression;
import cfml.parsing.cfscript.CFAssignmentExpression;
import cfml.parsing.cfscript.CFBinaryExpression;
import cfml.parsing.cfscript.CFElvisExpression;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFFullVarExpression;
import cfml.parsing.cfscript.CFFunctionExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.CFLiteral;
import cfml.parsing.cfscript.CFMember;
import cfml.parsing.cfscript.CFNestedExpression;
import cfml.parsing.cfscript.CFNewExpression;
import cfml.parsing.cfscript.CFStringExpression;
import cfml.parsing.cfscript.CFStructElementExpression;
import cfml.parsing.cfscript.CFStructExpression;
import cfml.parsing.cfscript.CFTernaryExpression;
import cfml.parsing.cfscript.CFUnaryExpression;
import cfml.parsing.cfscript.CFVarDeclExpression;
import cfml.parsing.cfscript.script.CFFuncDeclStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.cfscript.walker.CFScriptStatementVisitor;
import java.util.Stack;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class CFExpressionVisitor
extends CFSCRIPTParserBaseVisitor<CFExpression> {
    private Stack<CFExpression> aggregator = new Stack();
    private CFScriptStatementVisitor scriptStatementVisitor = null;

    @Override
    public CFExpression visitCompareExpression(CFSCRIPTParser.CompareExpressionContext ctx) {
        if (ctx.getChildCount() == 0) {
            return null;
        }
        CFExpression compareExpression = null;
        compareExpression = ctx.right != null ? new CFBinaryExpression(this.getTerminalToken((ParseTree)ctx.operator), (CFExpression)this.visit((ParseTree)ctx.left), (CFExpression)this.visit((ParseTree)ctx.right)) : (CFExpression)this.visit((ParseTree)ctx.left);
        return compareExpression;
    }

    @Override
    public CFExpression visitParameterType(CFSCRIPTParser.ParameterTypeContext ctx) {
        return (CFExpression)super.visitParameterType(ctx);
    }

    @Override
    public CFExpression visitComponentAttribute(CFSCRIPTParser.ComponentAttributeContext ctx) {
        return (CFExpression)super.visitComponentAttribute(ctx);
    }

    @Override
    public CFExpression visitFunctionAttribute(CFSCRIPTParser.FunctionAttributeContext ctx) {
        return (CFExpression)super.visitFunctionAttribute(ctx);
    }

    @Override
    public CFExpression visitParameterAttribute(CFSCRIPTParser.ParameterAttributeContext ctx) {
        return (CFExpression)super.visitParameterAttribute(ctx);
    }

    @Override
    public CFExpression visitComponentGuts(CFSCRIPTParser.ComponentGutsContext ctx) {
        return (CFExpression)super.visitComponentGuts(ctx);
    }

    @Override
    public CFExpression visitCondition(CFSCRIPTParser.ConditionContext ctx) {
        return (CFExpression)super.visitCondition(ctx);
    }

    @Override
    public CFExpression visitForInKey(CFSCRIPTParser.ForInKeyContext ctx) {
        if (ctx.VAR() != null) {
            CFVarDeclExpression declExpression = new CFVarDeclExpression(ctx.VAR().getSymbol(), (CFIdentifier)this.visitChildren((RuleNode)ctx), null);
            return declExpression;
        }
        return (CFExpression)super.visitForInKey(ctx);
    }

    @Override
    public CFExpression visitConstantExpression(CFSCRIPTParser.ConstantExpressionContext ctx) {
        if (ctx.floatingPointExpression() != null) {
            return this.visitFloatingPointExpression(ctx.floatingPointExpression());
        }
        if (ctx.MINUS() != null) {
            return new CFUnaryExpression(ctx.MINUS().getSymbol(), this.visitConstantExpression(ctx.constantExpression()));
        }
        if (ctx.LEFTPAREN() != null) {
            return new CFUnaryExpression(ctx.LEFTPAREN().getSymbol(), this.visitConstantExpression(ctx.constantExpression()));
        }
        if (ctx.stringLiteral() != null) {
            return this.visitStringLiteral(ctx.stringLiteral());
        }
        return new CFLiteral(ctx.start);
    }

    @Override
    public CFExpression visitStringLiteral(CFSCRIPTParser.StringLiteralContext ctx) {
        CFStringExpression stringExpression = new CFStringExpression(ctx.getStart());
        for (ParseTree child : ctx.children) {
            CFExpression result = (CFExpression)super.visit(child);
            if (result == null) continue;
            stringExpression.getSubExpressions().add(result);
        }
        return stringExpression;
    }

    @Override
    public CFExpression visitStringLiteralPart(CFSCRIPTParser.StringLiteralPartContext ctx) {
        CFLiteral literal = new CFLiteral(ctx.start);
        return literal;
    }

    @Override
    public CFExpression visitLocalAssignmentExpression(CFSCRIPTParser.LocalAssignmentExpressionContext ctx) {
        CFIdentifier identifier = (CFIdentifier)this.visit((ParseTree)ctx.left);
        CFExpression initExpression = (CFExpression)this.visit((ParseTree)ctx.right);
        CFVarDeclExpression retval = new CFVarDeclExpression(ctx.start, identifier, initExpression);
        if (ctx.otherIdentifiers().size() > 0) {
            for (CFSCRIPTParser.OtherIdentifiersContext oi : ctx.otherIdentifiers()) {
                CFIdentifier otherid = (CFIdentifier)this.visit((ParseTree)oi.identifier());
                if (oi.VAR() != null) {
                    retval.getOtherVars().add(otherid);
                    continue;
                }
                retval.getOtherIds().add(otherid);
            }
        }
        return retval;
    }

    @Override
    public CFExpression visitAssignmentExpression(CFSCRIPTParser.AssignmentExpressionContext ctx) {
        if (ctx.right == null) {
            return (CFExpression)this.visitStartExpression(ctx.left);
        }
        CFAssignmentExpression assignmentExpression = new CFAssignmentExpression(this.getTerminalToken(ctx.getChild(1)), (CFExpression)this.visit((ParseTree)ctx.left), (CFExpression)this.visit((ParseTree)ctx.right));
        for (CFSCRIPTParser.IdentifierContext oi : ctx.identifier()) {
            CFIdentifier otherid = (CFIdentifier)this.visit((ParseTree)oi);
            assignmentExpression.getOtherIds().add(otherid);
        }
        return assignmentExpression;
    }

    @Override
    public CFExpression visitBaseExpression(CFSCRIPTParser.BaseExpressionContext ctx) {
        if (ctx.getChildCount() == 0) {
            return null;
        }
        if (ctx.unaryOperator != null) {
            return new CFUnaryExpression(ctx.unaryOperator, (CFExpression)this.visit((ParseTree)ctx.right));
        }
        if (ctx.elvisOperator() != null) {
            CFElvisExpression expr = new CFElvisExpression(ctx.getStart(), (CFExpression)this.visit((ParseTree)ctx.left), (CFExpression)this.visit((ParseTree)ctx.right));
            return expr;
        }
        if (ctx.compareExpressionOperator() != null) {
            return new CFBinaryExpression(this.getTerminalToken((ParseTree)ctx.operator), (CFExpression)this.visit((ParseTree)ctx.left), (CFExpression)this.visit((ParseTree)ctx.right));
        }
        if (ctx.notExpression() != null) {
            return new CFUnaryExpression(this.getTerminalToken(ctx.notExpression().getChild(0)), (CFExpression)this.visit((ParseTree)ctx.notExpression().baseExpression()));
        }
        if (ctx.notNotExpression() != null) {
            return new CFUnaryExpression(this.getTerminalToken(ctx.notNotExpression().getChild(0)), (CFExpression)this.visit((ParseTree)ctx.notNotExpression().unaryExpression()));
        }
        if (ctx.unaryExpression() != null) {
            return this.visitUnaryExpression(ctx.unaryExpression());
        }
        if (ctx.ternaryExpression() != null) {
            CFSCRIPTParser.TernaryExpressionContext tex = ctx.ternaryExpression();
            CFTernaryExpression ternaryExpression = new CFTernaryExpression(tex.getStart(), (CFExpression)this.visit((ParseTree)ctx.left), (CFExpression)this.visit((ParseTree)tex.ternaryExpression1), (CFExpression)this.visit((ParseTree)tex.ternaryExpression2));
            return ternaryExpression;
        }
        if (ctx.getChildCount() == 3) {
            return new CFBinaryExpression(this.getTerminalToken(ctx.getChild(1)), (CFExpression)this.visit((ParseTree)ctx.left), (CFExpression)this.visit((ParseTree)ctx.right));
        }
        return (CFExpression)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public CFExpression visitUnaryExpression(CFSCRIPTParser.UnaryExpressionContext ctx) {
        if (ctx.getChildCount() < 2) {
            return (CFExpression)super.visitChildren((RuleNode)ctx);
        }
        CFUnaryExpression unaryExpression = new CFUnaryExpression(ctx.start, (CFExpression)super.visitChildren((RuleNode)ctx));
        return unaryExpression;
    }

    @Override
    public CFExpression visitParentheticalExpression(CFSCRIPTParser.ParentheticalExpressionContext ctx) {
        if (ctx.getChildCount() == 3) {
            CFUnaryExpression unaryExpression = new CFUnaryExpression(this.getTerminalToken(ctx.getChild(0)), (CFExpression)this.visit(ctx.getChild(1)));
            return unaryExpression;
        }
        return (CFExpression)super.visitParentheticalExpression(ctx);
    }

    @Override
    public CFExpression visitParentheticalMemberExpression(CFSCRIPTParser.ParentheticalMemberExpressionContext ctx) {
        ArgumentsVector args = new ArgumentsVector();
        if (ctx.argumentList() != null) {
            for (CFSCRIPTParser.ArgumentContext argCtx : ctx.argumentList().argument()) {
                if (argCtx.name != null) {
                    args.addNamedArg((CFExpression)this.visit((ParseTree)argCtx.name), (CFExpression)this.visit((ParseTree)argCtx.startExpression()));
                    continue;
                }
                args.add(this.visit((ParseTree)argCtx));
            }
        }
        CFFunctionExpression cfFunctionExpression = new CFFunctionExpression(ctx.LEFTPAREN().getSymbol(), null, args);
        return cfFunctionExpression;
    }

    @Override
    public CFExpression visitMemberExpression(CFSCRIPTParser.MemberExpressionContext ctx) {
        CFFullVarExpression fullVarExpression = new CFFullVarExpression(ctx.start, null);
        this.aggregator.push(fullVarExpression);
        CFExpression retval = (CFExpression)this.visitChildren((RuleNode)ctx);
        this.aggregator.pop();
        return retval;
    }

    @Override
    public CFExpression visitInnerExpression(CFSCRIPTParser.InnerExpressionContext ctx) {
        return new CFNestedExpression(ctx.POUND_SIGN(0).getSymbol(), (CFExpression)this.visit((ParseTree)ctx.baseExpression()));
    }

    @Override
    public CFExpression visitArrayMemberExpression(CFSCRIPTParser.ArrayMemberExpressionContext ctx) {
        CFMember member = new CFMember(ctx.getStart(), (CFExpression)this.visit(ctx.getChild(1)));
        return member;
    }

    @Override
    public CFExpression visitPrimaryExpressionIRW(CFSCRIPTParser.PrimaryExpressionIRWContext ctx) {
        if (ctx.start.getType() == 8 || ctx.start.getType() == 169) {
            return new CFLiteral(ctx.start);
        }
        return (CFExpression)super.visitPrimaryExpressionIRW(ctx);
    }

    @Override
    public CFExpression visitArgument(CFSCRIPTParser.ArgumentContext ctx) {
        CFExpression retval = (CFExpression)super.visitArgument(ctx);
        return retval;
    }

    @Override
    public CFExpression visitIdentifier(CFSCRIPTParser.IdentifierContext ctx) {
        if (ctx.getChildCount() > 1) {
            return new CFIdentifier(ctx.start, ctx.getChild(0).getText(), ctx.getChild(1).getText());
        }
        return new CFIdentifier(ctx.start, ctx.getChild(0).getText());
    }

    @Override
    public CFExpression visitType(CFSCRIPTParser.TypeContext ctx) {
        return new CFIdentifier(ctx.start, ctx.getChild(0).getText());
    }

    @Override
    public CFExpression visitPrimaryExpression(CFSCRIPTParser.PrimaryExpressionContext ctx) {
        ParseTree child = ctx.getChild(0);
        if (child.getChildCount() == 0) {
            CFLiteral literal = new CFLiteral(((TerminalNode)child).getSymbol());
            return literal;
        }
        return (CFExpression)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public CFExpression visitImplicitArray(CFSCRIPTParser.ImplicitArrayContext ctx) {
        CFArrayExpression arrayExpression = new CFArrayExpression(ctx.getStart());
        this.aggregator.push(arrayExpression);
        CFExpression retval = (CFExpression)super.visitImplicitArray(ctx);
        this.aggregator.pop();
        if (retval != null && retval != arrayExpression) {
            arrayExpression.addElement(retval);
        }
        return arrayExpression;
    }

    @Override
    public CFExpression visitImplicitStruct(CFSCRIPTParser.ImplicitStructContext ctx) {
        CFStructExpression structExpression = new CFStructExpression(ctx.getStart());
        this.aggregator.push(structExpression);
        CFExpression retval = (CFExpression)super.visitImplicitStruct(ctx);
        this.aggregator.pop();
        if (retval instanceof CFStructElementExpression) {
            structExpression.addElement((CFStructElementExpression)retval);
        }
        return structExpression;
    }

    @Override
    public CFExpression visitImplicitStructExpression(CFSCRIPTParser.ImplicitStructExpressionContext ctx) {
        CFStructElementExpression elementExpression = new CFStructElementExpression(ctx.getStart(), this.makeIdentifier((CFExpression)this.visit(ctx.getChild(0))), (CFExpression)this.visit(ctx.getChild(2)));
        return elementExpression;
    }

    private CFIdentifier makeIdentifier(CFExpression visit) {
        if (visit instanceof CFIdentifier) {
            return (CFIdentifier)visit;
        }
        return new CFFullVarExpression(visit.getToken(), visit);
    }

    @Override
    public CFExpression visitNewComponentExpression(CFSCRIPTParser.NewComponentExpressionContext ctx) {
        ArgumentsVector args = new ArgumentsVector();
        if (ctx.getChildCount() > 4) {
            for (CFSCRIPTParser.ArgumentContext argCtx : ctx.argumentList().argument()) {
                args.add(this.visit((ParseTree)argCtx));
            }
        }
        CFNewExpression newExpression = new CFNewExpression(ctx.NEW().getSymbol(), (CFExpression)this.visit((ParseTree)ctx.componentPath()), args);
        return newExpression;
    }

    @Override
    public CFExpression visitComponentPath(CFSCRIPTParser.ComponentPathContext ctx) {
        return (CFExpression)super.visitChildren((RuleNode)ctx);
    }

    @Override
    public CFExpression visitLiteralExpression(CFSCRIPTParser.LiteralExpressionContext ctx) {
        if (ctx.floatingPointExpression() != null) {
            return this.visitFloatingPointExpression(ctx.floatingPointExpression());
        }
        if (ctx.stringLiteral() != null) {
            return this.visitStringLiteral(ctx.stringLiteral());
        }
        return new CFLiteral(ctx.start);
    }

    @Override
    public CFExpression visitFloatingPointExpression(CFSCRIPTParser.FloatingPointExpressionContext ctx) {
        if (ctx.right != null) {
            return new CFLiteral(ctx.start, (ctx.left != null ? ctx.left.getText() : "") + "." + ctx.right.getText());
        }
        if (ctx.leftonly != null) {
            return new CFLiteral(ctx.leftonly, ctx.leftonly.getText() + ".");
        }
        return new CFLiteral(ctx.start);
    }

    @Override
    public CFExpression visitFunctionCall(CFSCRIPTParser.FunctionCallContext ctx) {
        ArgumentsVector args = new ArgumentsVector();
        if (ctx.argumentList() != null) {
            for (CFSCRIPTParser.ArgumentContext argCtx : ctx.argumentList().argument()) {
                if (argCtx.name != null) {
                    args.addNamedArg((CFExpression)this.visit((ParseTree)argCtx.name), (CFExpression)this.visit((ParseTree)argCtx.startExpression()));
                    continue;
                }
                args.add(this.visit((ParseTree)argCtx));
            }
        }
        CFFunctionExpression cfFunctionExpression = new CFFunctionExpression((CFIdentifier)this.visit(ctx.getChild(0)), args);
        if (ctx.body != null) {
            cfFunctionExpression.setBody((CFScriptStatement)this.getCFScriptStatementVisitor().visit((ParseTree)ctx.body));
        }
        return cfFunctionExpression;
    }

    @Override
    public CFExpression visitQualifiedFunctionCall(CFSCRIPTParser.QualifiedFunctionCallContext ctx) {
        ArgumentsVector args = new ArgumentsVector();
        if (ctx.argumentList() != null) {
            for (CFSCRIPTParser.ArgumentContext argCtx : ctx.argumentList().argument()) {
                if (argCtx.name != null) {
                    args.addNamedArg((CFExpression)this.visit((ParseTree)argCtx.name), (CFExpression)this.visit((ParseTree)argCtx.startExpression()));
                    continue;
                }
                args.add(this.visit((ParseTree)argCtx));
            }
        }
        CFFunctionExpression cfFunctionExpression = new CFFunctionExpression((CFIdentifier)this.visit(ctx.getChild(0)), args);
        if (ctx.body != null) {
            cfFunctionExpression.setBody((CFScriptStatement)this.getCFScriptStatementVisitor().visit((ParseTree)ctx.body));
        }
        return cfFunctionExpression;
    }

    @Override
    public CFExpression visitCfmlFunction(CFSCRIPTParser.CfmlFunctionContext ctx) {
        return new CFIdentifier(ctx.start, ctx.getChild(0).getText());
    }

    @Override
    public CFExpression visitTagFunctionStatement(CFSCRIPTParser.TagFunctionStatementContext ctx) {
        ArgumentsVector args = new ArgumentsVector();
        if (ctx.parameterList() != null) {
            for (CFSCRIPTParser.ParameterContext argCtx : ctx.parameterList().parameter()) {
                if (argCtx.name != null) {
                    args.addNamedArg((CFExpression)this.visit((ParseTree)argCtx.name), (CFExpression)this.visit((ParseTree)argCtx.startExpression()));
                    continue;
                }
                args.add(this.visit((ParseTree)argCtx));
            }
        }
        CFFunctionExpression cfFunctionExpression = new CFFunctionExpression((CFIdentifier)this.visit(ctx.getChild(0)), args);
        return cfFunctionExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CFExpression visitMultipartIdentifier(CFSCRIPTParser.MultipartIdentifierContext ctx) {
        if (ctx.getChildCount() < 2) {
            return (CFExpression)super.visitMultipartIdentifier(ctx);
        }
        CFFullVarExpression fullVarExpression = new CFFullVarExpression(ctx.getStart(), null);
        this.aggregator.push(fullVarExpression);
        try {
            CFExpression cFExpression = (CFExpression)this.visitChildren((RuleNode)ctx);
            return cFExpression;
        }
        finally {
            this.aggregator.pop();
        }
    }

    @Override
    public CFExpression visitArray(CFSCRIPTParser.ArrayContext ctx) {
        return new CFIdentifier(ctx.start, ctx.start.getText() + ctx.stop.getText());
    }

    @Override
    public CFExpression visitAnonymousFunctionDeclaration(CFSCRIPTParser.AnonymousFunctionDeclarationContext ctx) {
        CFFuncDeclStatement funcDeclStatement = (CFFuncDeclStatement)this.getCFScriptStatementVisitor().visitAnonymousFunctionDeclaration(ctx);
        return new CFAnonymousFunctionExpression(ctx.FUNCTION().getSymbol(), funcDeclStatement);
    }

    public synchronized CFScriptStatementVisitor getCFScriptStatementVisitor() {
        if (this.scriptStatementVisitor == null) {
            this.scriptStatementVisitor = new CFScriptStatementVisitor();
        }
        return this.scriptStatementVisitor;
    }

    protected CFExpression aggregateResult(CFExpression aggregate, CFExpression nextResult) {
        if (nextResult == null) {
            return aggregate;
        }
        if (aggregate == null) {
            return nextResult;
        }
        if (aggregate instanceof CFNewExpression) {
            CFFullVarExpression fullVarExpression = new CFFullVarExpression(aggregate.getToken(), aggregate);
            fullVarExpression.addMember(nextResult);
            aggregate = fullVarExpression;
        } else if (aggregate instanceof CFFullVarExpression) {
            ((CFFullVarExpression)aggregate).addMember(nextResult);
        } else if (!this.aggregator.isEmpty() && this.aggregator.peek() instanceof CFFullVarExpression) {
            CFFullVarExpression fullVarExpression = (CFFullVarExpression)this.aggregator.peek();
            if (aggregate != fullVarExpression) {
                fullVarExpression.addMember(aggregate);
            }
            fullVarExpression.addMember(nextResult);
            aggregate = fullVarExpression;
        } else if (!this.aggregator.isEmpty() && this.aggregator.peek() instanceof CFArrayExpression) {
            CFArrayExpression arrayExpression = (CFArrayExpression)this.aggregator.peek();
            if (aggregate != arrayExpression) {
                arrayExpression.addElement(aggregate);
            }
            arrayExpression.addElement(nextResult);
            aggregate = arrayExpression;
        } else if (!this.aggregator.isEmpty() && this.aggregator.peek() instanceof CFStructExpression) {
            CFStructExpression structExpression = (CFStructExpression)this.aggregator.peek();
            if (aggregate != structExpression && aggregate instanceof CFStructElementExpression) {
                structExpression.addElement((CFStructElementExpression)aggregate);
            }
            if (nextResult instanceof CFStructElementExpression) {
                structExpression.addElement((CFStructElementExpression)nextResult);
            }
            aggregate = structExpression;
        } else if (nextResult instanceof CFIdentifier || nextResult instanceof CFMember) {
            CFFullVarExpression fullVar = new CFFullVarExpression(aggregate.getToken(), aggregate);
            fullVar.addMember(nextResult);
            aggregate = fullVar;
        } else if (nextResult instanceof CFStructElementExpression) {
            if (aggregate instanceof CFStructElementExpression) {
                CFStructExpression structExpression = new CFStructExpression(aggregate.getToken());
                structExpression.addElement((CFStructElementExpression)aggregate);
                structExpression.addElement((CFStructElementExpression)nextResult);
                aggregate = structExpression;
            } else if (aggregate instanceof CFStructExpression) {
                ((CFStructExpression)aggregate).addElement((CFStructElementExpression)nextResult);
            }
        }
        return aggregate;
    }

    private Token getTerminalToken(ParseTree child) {
        if (child instanceof TerminalNode) {
            return ((TerminalNode)child).getSymbol();
        }
        if (child.getChildCount() == 1) {
            return this.getTerminalToken(child.getChild(0));
        }
        return null;
    }

    public void clear() {
        this.aggregator.clear();
    }

    @Override
    public CFExpression visitSpecialWord(CFSCRIPTParser.SpecialWordContext ctx) {
        if (ctx.getChildCount() > 1) {
            return new CFIdentifier(ctx.start, ctx.getChild(0).getText(), ctx.getChild(1).getText());
        }
        return new CFIdentifier(ctx.start, ctx.getChild(0).getText());
    }

    @Override
    public CFExpression visitReservedWord(CFSCRIPTParser.ReservedWordContext ctx) {
        return new CFIdentifier(ctx.start, ctx.getChild(0).getText());
    }
}

