/*
 * Decompiled with CFR 0.152.
 */
package co.ceryle.radiorealbutton;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.view.View;
import co.ceryle.radiorealbutton.BackgroundHelper;

class RippleHelper {
    RippleHelper() {
    }

    static void setSelectableItemBackground(Context context, View view) {
        int[] attrs = new int[]{16843534};
        TypedArray ta = context.obtainStyledAttributes(attrs);
        Drawable drawableFromTheme = ta.getDrawable(0);
        ta.recycle();
        BackgroundHelper.setBackground(view, drawableFromTheme);
    }

    static void setRipple(View view, int pressedColor) {
        RippleHelper.setRipple(view, pressedColor, null);
    }

    static void setRipple(View view, int pressedColor, Integer normalColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            view.setBackground(RippleHelper.getRippleDrawable(pressedColor, normalColor));
        } else {
            view.setBackgroundDrawable((Drawable)RippleHelper.getStateListDrawable(pressedColor, normalColor));
        }
    }

    private static StateListDrawable getStateListDrawable(int pressedColor, Integer normalColor) {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16842908}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16843518}, (Drawable)new ColorDrawable(pressedColor));
        if (null != normalColor) {
            states.addState(new int[0], (Drawable)new ColorDrawable(normalColor.intValue()));
        }
        return states;
    }

    @TargetApi(value=21)
    private static Drawable getRippleDrawable(int pressedColor, Integer normalColor) {
        ShapeDrawable mask;
        ColorStateList colorStateList = RippleHelper.getPressedColorSelector(pressedColor);
        ColorDrawable content = null;
        if (null == normalColor) {
            mask = new ShapeDrawable();
        } else {
            content = new ColorDrawable(normalColor.intValue());
            mask = RippleHelper.getRippleMask(-1);
        }
        return new RippleDrawable(colorStateList, (Drawable)content, (Drawable)mask);
    }

    private static ColorStateList getPressedColorSelector(int pressedColor) {
        return new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{pressedColor});
    }

    private static Drawable getRippleMask(int color) {
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RectShape());
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }
}

