/*
 * Decompiled with CFR 0.152.
 */
package co.ceryle.fitgridview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.widget.GridView;
import android.widget.ListAdapter;
import co.ceryle.fitgridview.FitGridAdapter;
import co.ceryle.fitgridview.R;

public class FitGridView
extends GridView {
    private int column;
    private int row;
    private int itemWidth = 0;
    private int itemHeight = 0;
    private FitGridAdapter fitGridAdapter;

    public FitGridView(Context context) {
        super(context);
        this.init(null);
    }

    public FitGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public FitGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @RequiresApi(api=21)
    public FitGridView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.getAttributes(attrs);
        this.setStretchMode(2);
        this.setNumColumns(this.column);
    }

    private void getAttributes(AttributeSet attrs) {
        if (null == attrs) {
            return;
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.FitGridView);
        this.column = typedArray.getInt(R.styleable.FitGridView_column, 0);
        this.row = typedArray.getInt(R.styleable.FitGridView_row, 0);
        typedArray.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.update();
    }

    public void update() {
        if (null == this.fitGridAdapter) {
            return;
        }
        this.remeasure();
        this.fitGridAdapter.setRow(this.row);
        this.fitGridAdapter.setColumn(this.column);
        this.fitGridAdapter.setColumnHeight(this.itemHeight);
        this.fitGridAdapter.setColumnWidth(this.itemWidth);
        this.setAdapter((ListAdapter)this.fitGridAdapter);
    }

    public void setDimension(float displayWidth, float displayHeight) {
        this.itemWidth = (int)displayWidth / this.column;
        this.itemHeight = (int)displayHeight / this.row;
        this.update();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.remeasure();
    }

    private void remeasure() {
        this.itemWidth = this.getMeasuredWidth() / this.column;
        this.itemHeight = this.getMeasuredHeight() / this.row;
    }

    public void setColumn(int column) {
        this.column = column;
        this.setNumColumns(column);
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setFitGridAdapter(FitGridAdapter fitGridAdapter) {
        this.fitGridAdapter = fitGridAdapter;
        this.update();
    }
}

