/*
 * Decompiled with CFR 0.152.
 */
package scalacache.caffeine;

import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scalacache.Cache;
import scalacache.Entry;
import scalacache.LoggingSupport;
import scalacache.caffeine.CaffeineCache$;
import scalacache.serialization.Codec;
import scalacache.serialization.InMemoryRepr;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u0011QbQ1gM\u0016Lg.Z\"bG\",'BA\u0002\u0005\u0003!\u0019\u0017M\u001a4fS:,'\"A\u0003\u0002\u0015M\u001c\u0017\r\\1dC\u000eDWm\u0001\u0001\u0014\t\u0001Aa\u0002\u0007\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0007=\u0001\"#D\u0001\u0005\u0013\t\tBAA\u0003DC\u000eDW\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005i1/\u001a:jC2L'0\u0019;j_:L!a\u0006\u000b\u0003\u0019%sW*Z7pef\u0014V\r\u001d:\u0011\u0005=I\u0012B\u0001\u000e\u0005\u00059aunZ4j]\u001e\u001cV\u000f\u001d9peRD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u000bk:$WM\u001d7zS:<\u0007\u0003\u0002\u0010)SQj\u0011a\b\u0006\u0003A\u0005\nQaY1dQ\u0016T!a\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00032f]6\fg.Z:\u000b\u0005\u00152\u0013AB4ji\",(MC\u0001(\u0003\r\u0019w.\\\u0005\u0003#}\u0001\"AK\u0019\u000f\u0005-z\u0003C\u0001\u0017\u000b\u001b\u0005i#B\u0001\u0018\u0007\u0003\u0019a$o\\8u}%\u0011\u0001GC\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021\u0015A\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB(cU\u0016\u001cG\u000fC\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\u0003\u007f\u0005\u0003\"\u0001\u0011\u0001\u000e\u0003\tAQ\u0001\b\u001fA\u0002uAqa\u0011\u0001C\u0002\u0013UC)\u0001\u0004m_\u001e<WM]\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0006g24GG\u001b\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051;%A\u0002'pO\u001e,'\u000f\u0003\u0004O\u0001\u0001\u0006i!R\u0001\bY><w-\u001a:!\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0003\r9W\r^\u000b\u0003%~#\"aU7\u0015\u0005QC\u0007cA+Y56\taK\u0003\u0002X\u0015\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005e3&A\u0002$viV\u0014X\rE\u0002\n7vK!\u0001\u0018\u0006\u0003\r=\u0003H/[8o!\tqv\f\u0004\u0001\u0005\u000b\u0001|%\u0019A1\u0003\u0003Y\u000b\"AY3\u0011\u0005%\u0019\u0017B\u00013\u000b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u00034\n\u0005\u001dT!aA!os\")\u0011n\u0014a\u0002U\u0006)1m\u001c3fGB!1c[/\u0013\u0013\taGCA\u0003D_\u0012,7\rC\u0003o\u001f\u0002\u0007\u0011&A\u0002lKfDQ\u0001\u001d\u0001\u0005BE\f1\u0001];u+\t\u00118\u0010\u0006\u0003tyv|HC\u0001;y!\r)\u0006,\u001e\t\u0003\u0013YL!a\u001e\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006S>\u0004\u001d!\u001f\t\u0005'-T(\u0003\u0005\u0002_w\u0012)\u0001m\u001cb\u0001C\")an\u001ca\u0001S!)ap\u001ca\u0001u\u0006)a/\u00197vK\"I\u0011\u0011A8\u0011\u0002\u0003\u0007\u00111A\u0001\u0004iRd\u0007\u0003B\u0005\\\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\u0005=\u0011\u0011\u0002\u0002\t\tV\u0014\u0018\r^5p]\"9\u00111\u0003\u0001\u0005B\u0005U\u0011A\u0002:f[>4X\rF\u0002u\u0003/AaA\\A\t\u0001\u0004I\u0003bBA\u000e\u0001\u0011\u0005\u0013QD\u0001\ne\u0016lwN^3BY2$\u0012\u0001\u001e\u0005\b\u0003C\u0001A\u0011IA\u0012\u0003\u0015\u0019Gn\\:f)\u0005)\bbBA\u0014\u0001\u0011%\u0011\u0011F\u0001\ri>,\u0005\u0010]5ssRKW.\u001a\u000b\u0005\u0003W\tY\u0004\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\tQLW.\u001a\u0006\u0004\u0003kI\u0015\u0001\u00026pI\u0006LA!!\u000f\u00020\tAA)\u0019;f)&lW\r\u0003\u0005\u0002\u0002\u0005\u0015\u0002\u0019AA\u0003\u0011%\ty\u0004AI\u0001\n\u0003\t\t%A\u0007qkR$C-\u001a4bk2$HeM\u000b\u0005\u0003\u0007\nI&\u0006\u0002\u0002F)\"\u00111AA$W\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA*\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u00021\u0002>\t\u0007\u0011mB\u0004\u0002^\tA\t!a\u0018\u0002\u001b\r\u000bgMZ3j]\u0016\u001c\u0015m\u00195f!\r\u0001\u0015\u0011\r\u0004\u0007\u0003\tA\t!a\u0019\u0014\u0007\u0005\u0005\u0004\u0002C\u0004>\u0003C\"\t!a\u001a\u0015\u0005\u0005}\u0003\u0002CA6\u0003C\"\t!!\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0003}B\u0001\"a\u001b\u0002b\u0011\u0005\u0011\u0011\u000f\u000b\u0004\u007f\u0005M\u0004B\u0002\u000f\u0002p\u0001\u0007Q\u0004")
public class CaffeineCache
implements Cache<InMemoryRepr>,
LoggingSupport {
    private final com.github.benmanes.caffeine.cache.Cache<String, Object> underlying;
    private final Logger logger;

    public static CaffeineCache apply(com.github.benmanes.caffeine.cache.Cache<String, Object> cache) {
        return CaffeineCache$.MODULE$.apply(cache);
    }

    public static CaffeineCache apply() {
        return CaffeineCache$.MODULE$.apply();
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public final Logger logger() {
        return this.logger;
    }

    public <V> Future<Option<V>> get(String key, Codec<V, InMemoryRepr> codec) {
        Entry entry;
        Object baseValue = this.underlying.getIfPresent((Object)key);
        None$ result = baseValue != null ? ((entry = (Entry)baseValue).isExpired() ? None$.MODULE$ : new Some(entry.value())) : None$.MODULE$;
        this.logCacheHitOrMiss(key, (Option)result);
        return Future$.MODULE$.successful((Object)result);
    }

    public <V> Future<BoxedUnit> put(String key, V value, Option<Duration> ttl2, Codec<V, InMemoryRepr> codec) {
        Entry entry = new Entry(value, ttl2.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
        this.underlying.put((Object)key, (Object)entry);
        this.logCachePut(key, ttl2);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public <V> Option<Duration> put$default$3() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> remove(String key) {
        this.underlying.invalidate((Object)key);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public Future<BoxedUnit> removeAll() {
        this.underlying.invalidateAll();
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void close() {
    }

    private DateTime toExpiryTime(Duration ttl) {
        return DateTime.now().plus(ttl.toMillis());
    }

    public CaffeineCache(com.github.benmanes.caffeine.cache.Cache<String, Object> underlying) {
        this.underlying = underlying;
        LoggingSupport.$init$((LoggingSupport)this);
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

