/*
 * Decompiled with CFR 0.152.
 */
package scalacache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.AbstractCache;
import scalacache.CacheAlg;
import scalacache.CacheConfig;
import scalacache.Entry;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;
import scalacache.caffeine.CaffeineCache$;
import scalacache.logging.Logger;
import scalacache.logging.Logger$;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001\u001d\u0011QbQ1gM\u0016Lg.Z\"bG\",'BA\u0002\u0005\u0003!\u0019\u0017M\u001a4fS:,'\"A\u0003\u0002\u0015M\u001c\u0017\r\\1dC\u000eDWm\u0001\u0001\u0016\u0005!)2c\u0001\u0001\n\u001fA\u0011!\"D\u0007\u0002\u0017)\tA\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000f\u0017\t1\u0011I\\=SK\u001a\u00042\u0001E\t\u0014\u001b\u0005!\u0011B\u0001\n\u0005\u00055\t%m\u001d;sC\u000e$8)Y2iKB\u0011A#\u0006\u0007\u0001\t\u00151\u0002A1\u0001\u0018\u0005\u00051\u0016C\u0001\r\u001c!\tQ\u0011$\u0003\u0002\u001b\u0017\t9aj\u001c;iS:<\u0007C\u0001\u0006\u001d\u0013\ti2BA\u0002B]fD\u0001b\b\u0001\u0003\u0006\u0004%\t\u0001I\u0001\u000bk:$WM\u001d7zS:<W#A\u0011\u0011\t\tbc&O\u0007\u0002G)\u0011A%J\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003\u0007\u0019R!a\n\u0015\u0002\u0011\t,g.\\1oKNT!!\u000b\u0016\u0002\r\u001dLG\u000f[;c\u0015\u0005Y\u0013aA2p[&\u0011Qf\t\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003_Yr!\u0001\r\u001b\u0011\u0005EZQ\"\u0001\u001a\u000b\u0005M2\u0011A\u0002\u001fs_>$h(\u0003\u00026\u0017\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)4\u0002E\u0002\u0011uMI!a\u000f\u0003\u0003\u000b\u0015sGO]=\t\u0011u\u0002!\u0011!Q\u0001\n\u0005\n1\"\u001e8eKJd\u00170\u001b8hA!Aq\b\u0001BC\u0002\u0013\r\u0001)\u0001\u0004d_:4\u0017nZ\u000b\u0002\u0003B\u0011\u0001CQ\u0005\u0003\u0007\u0012\u00111bQ1dQ\u0016\u001cuN\u001c4jO\"AQ\t\u0001B\u0001B\u0003%\u0011)A\u0004d_:4\u0017n\u001a\u0011\t\u0011\u001d\u0003!\u0011!Q\u0001\f!\u000bQa\u00197pG.\u0004\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\tQLW.\u001a\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%JA\u0003DY>\u001c7\u000eC\u0003R\u0001\u0011\u0005!+\u0001\u0004=S:LGO\u0010\u000b\u0003'b#2\u0001\u0016,X!\r)\u0006aE\u0007\u0002\u0005!)q\b\u0015a\u0002\u0003\"9q\t\u0015I\u0001\u0002\bA\u0005\"B\u0010Q\u0001\u0004\t\u0003b\u0002.\u0001\u0005\u0004%)fW\u0001\u0007Y><w-\u001a:\u0016\u0003q\u0003\"!\u00181\u000e\u0003yS!a\u0018\u0003\u0002\u000f1|wmZ5oO&\u0011\u0011M\u0018\u0002\u0007\u0019><w-\u001a:\t\r\r\u0004\u0001\u0015!\u0004]\u0003\u001dawnZ4fe\u0002BQ!\u001a\u0001\u0005\u0002\u0019\fQ\u0001Z8HKR,\"a\u001a6\u0015\u0005!DHCA5s!\r!\"n\u001c\u0003\u0006W\u0012\u0014\r\u0001\u001c\u0002\u0002\rV\u0011q#\u001c\u0003\u0006]*\u0014\ra\u0006\u0002\u0002?B\u0019!\u0002]\n\n\u0005E\\!AB(qi&|g\u000eC\u0003tI\u0002\u000fA/\u0001\u0003n_\u0012,\u0007c\u0001\tvo&\u0011a\u000f\u0002\u0002\u0005\u001b>$W\r\u0005\u0002\u0015U\")\u0011\u0010\u001aa\u0001]\u0005\u00191.Z=\t\u000bm\u0004A\u0011\u0001?\u0002\u000b\u0011|\u0007+\u001e;\u0016\u0007u\f\t\u0001F\u0004\u007f\u0003\u001b\ty!a\u0005\u0015\u0007}\f9\u0001\u0005\u0003\u0015\u0003\u0003YBAB6{\u0005\u0004\t\u0019!F\u0002\u0018\u0003\u000b!aA\\A\u0001\u0005\u00049\u0002BB:{\u0001\b\tI\u0001\u0005\u0003\u0011k\u0006-\u0001c\u0001\u000b\u0002\u0002!)\u0011P\u001fa\u0001]!1\u0011\u0011\u0003>A\u0002M\tQA^1mk\u0016Dq!!\u0006{\u0001\u0004\t9\"A\u0002ui2\u0004BA\u00039\u0002\u001aA!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005\r2\"\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\n\u0002\u001e\tAA)\u001e:bi&|g\u000eC\u0004\u0002,\u0001!\t%!\f\u0002\u0011\u0011|'+Z7pm\u0016,B!a\f\u00026Q!\u0011\u0011GA!)\u0011\t\u0019$a\u000f\u0011\tQ\t)d\u0007\u0003\bW\u0006%\"\u0019AA\u001c+\r9\u0012\u0011\b\u0003\u0007]\u0006U\"\u0019A\f\t\u000fM\fI\u0003q\u0001\u0002>A!\u0001#^A !\r!\u0012Q\u0007\u0005\u0007s\u0006%\u0002\u0019\u0001\u0018\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005YAm\u001c*f[>4X-\u00117m+\u0011\tI%a\u0014\u0015\u0005\u0005-C\u0003BA'\u0003+\u0002B\u0001FA(7\u001191.a\u0011C\u0002\u0005EScA\f\u0002T\u00111a.a\u0014C\u0002]Aqa]A\"\u0001\b\t9\u0006\u0005\u0003\u0011k\u0006e\u0003c\u0001\u000b\u0002P!9\u0011Q\f\u0001\u0005B\u0005}\u0013!B2m_N,W\u0003BA1\u0003O\"\"!a\u0019\u0015\t\u0005\u0015\u0014Q\u000e\t\u0005)\u0005\u001d4\u0004B\u0004l\u00037\u0012\r!!\u001b\u0016\u0007]\tY\u0007\u0002\u0004o\u0003O\u0012\ra\u0006\u0005\bg\u0006m\u00039AA8!\u0011\u0001R/!\u001d\u0011\u0007Q\t9\u0007C\u0004\u0002v\u0001!I!a\u001e\u0002\u0019Q|W\t\u001f9jef$\u0016.\\3\u0015\t\u0005e\u0014q\u0010\t\u0004\u0013\u0006m\u0014bAA?\u0015\n9\u0011J\\:uC:$\b\u0002CA\u000b\u0003g\u0002\r!!\u0007\b\u000f\u0005\r%\u0001#\u0001\u0002\u0006\u0006i1)\u00194gK&tWmQ1dQ\u0016\u00042!VAD\r\u0019\t!\u0001#\u0001\u0002\nN\u0019\u0011qQ\u0005\t\u000fE\u000b9\t\"\u0001\u0002\u000eR\u0011\u0011Q\u0011\u0005\t\u0003#\u000b9\t\"\u0001\u0002\u0014\u0006)\u0011\r\u001d9msV!\u0011QSAN)\u0011\t9*!(\u0011\tU\u0003\u0011\u0011\u0014\t\u0004)\u0005mEA\u0002\f\u0002\u0010\n\u0007q\u0003\u0003\u0004@\u0003\u001f\u0003\u001d!\u0011\u0005\t\u0003#\u000b9\t\"\u0001\u0002\"V!\u00111UAV)\u0011\t)+a,\u0015\t\u0005\u001d\u0016Q\u0016\t\u0005+\u0002\tI\u000bE\u0002\u0015\u0003W#aAFAP\u0005\u00049\u0002BB \u0002 \u0002\u000f\u0011\tC\u0004 \u0003?\u0003\r!!-\u0011\u000b\tbc&a-\u0011\tAQ\u0014\u0011\u0016\u0005\u000b\u0003o\u000b9)%A\u0005\u0002\u0005e\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0003\u0002<\u0006eG\u0003BA_\u0003#T3\u0001SA`W\t\t\t\r\u0005\u0003\u0002D\u00065WBAAc\u0015\u0011\t9-!3\u0002\u0013Ut7\r[3dW\u0016$'bAAf\u0017\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0017Q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007bB\u0010\u00026\u0002\u0007\u00111\u001b\t\u0006E1r\u0013Q\u001b\t\u0005!i\n9\u000eE\u0002\u0015\u00033$aAFA[\u0005\u00049\u0002")
public class CaffeineCache<V>
implements AbstractCache<V> {
    private final Cache<String, Entry<V>> underlying;
    private final CacheConfig config;
    private final Clock clock;
    private final Logger logger;

    public static <V> Clock $lessinit$greater$default$3(Cache<String, Entry<V>> cache) {
        return CaffeineCache$.MODULE$.$lessinit$greater$default$3(cache);
    }

    public static <V> CaffeineCache<V> apply(Cache<String, Entry<V>> cache, CacheConfig cacheConfig) {
        return CaffeineCache$.MODULE$.apply(cache, cacheConfig);
    }

    public static <V> CaffeineCache<V> apply(CacheConfig cacheConfig) {
        return CaffeineCache$.MODULE$.apply(cacheConfig);
    }

    public final <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.get$((AbstractCache)this, keyParts, mode, (Flags)flags);
    }

    public final <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.put$((AbstractCache)this, keyParts, value, ttl, mode, (Flags)flags);
    }

    public final <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return (F)AbstractCache.remove$((AbstractCache)this, keyParts, mode);
    }

    public final <F> F removeAll(Mode<F> mode) {
        return (F)AbstractCache.removeAll$((AbstractCache)this, mode);
    }

    public final <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.caching$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingF$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoize$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoizeF$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public final <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return AbstractCache.caching$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return AbstractCache.cachingF$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return AbstractCache.cachingForMemoize$default$2$((AbstractCache)this, (String)baseKey);
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public <F> Option<Duration> put$default$3(Seq<Object> keyParts) {
        return CacheAlg.put$default$3$((CacheAlg)this, keyParts);
    }

    public Cache<String, Entry<V>> underlying() {
        return this.underlying;
    }

    public CacheConfig config() {
        return this.config;
    }

    public final Logger logger() {
        return this.logger;
    }

    public <F> F doGet(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0 & java.io.Serializable & Serializable)() -> {
            void var3_3;
            Entry entry = (Entry)this.underlying().getIfPresent((Object)key);
            None$ result = entry == null || entry.isExpired($this.clock) ? None$.MODULE$ : new Some(entry.value());
            this.logCacheHitOrMiss(key, (Option)result);
            return var3_3;
        });
    }

    public <F> F doPut(String key, V value, Option<Duration> ttl, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Entry entry = new Entry(value, ttl.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
            this.underlying().put((Object)key, (Object)entry);
            this.logCachePut(key, ttl);
        });
    }

    public <F> F doRemove(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.underlying().invalidate((Object)key));
    }

    public <F> F doRemoveAll(Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.underlying().invalidateAll());
    }

    public <F> F close(Mode<F> mode) {
        return (F)mode.M().pure((Object)BoxedUnit.UNIT);
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public CaffeineCache(Cache<String, Entry<V>> underlying, CacheConfig config, Clock clock) {
        this.underlying = underlying;
        this.config = config;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        AbstractCache.$init$((AbstractCache)this);
        this.logger = Logger$.MODULE$.getLogger(this.getClass().getName());
    }
}

