/*
 * Decompiled with CFR 0.152.
 */
package scalacache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.AbstractCache;
import scalacache.CacheAlg;
import scalacache.CacheConfig;
import scalacache.Entry;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;
import scalacache.caffeine.CaffeineCache$;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001\u001d\u0011QbQ1gM\u0016Lg.Z\"bG\",'BA\u0002\u0005\u0003!\u0019\u0017M\u001a4fS:,'\"A\u0003\u0002\u0015M\u001c\u0017\r\\1dC\u000eDWm\u0001\u0001\u0016\u0005!)2c\u0001\u0001\n\u001fA\u0011!\"D\u0007\u0002\u0017)\tA\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000f\u0017\t1\u0011I\\=SK\u001a\u00042\u0001E\t\u0014\u001b\u0005!\u0011B\u0001\n\u0005\u00055\t%m\u001d;sC\u000e$8)Y2iKB\u0011A#\u0006\u0007\u0001\t\u00151\u0002A1\u0001\u0018\u0005\u00051\u0016C\u0001\r\u001c!\tQ\u0011$\u0003\u0002\u001b\u0017\t9aj\u001c;iS:<\u0007C\u0001\u0006\u001d\u0013\ti2BA\u0002B]fD\u0001b\b\u0001\u0003\u0006\u0004%\t\u0001I\u0001\u000bk:$WM\u001d7zS:<W#A\u0011\u0011\t\tbc&O\u0007\u0002G)\u0011A%J\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003\u0007\u0019R!a\n\u0015\u0002\u0011\t,g.\\1oKNT!!\u000b\u0016\u0002\r\u001dLG\u000f[;c\u0015\u0005Y\u0013aA2p[&\u0011Qf\t\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003_Yr!\u0001\r\u001b\u0011\u0005EZQ\"\u0001\u001a\u000b\u0005M2\u0011A\u0002\u001fs_>$h(\u0003\u00026\u0017\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)4\u0002E\u0002\u0011uMI!a\u000f\u0003\u0003\u000b\u0015sGO]=\t\u0011u\u0002!\u0011!Q\u0001\n\u0005\n1\"\u001e8eKJd\u00170\u001b8hA!Aq\b\u0001BC\u0002\u0013\r\u0001)\u0001\u0004d_:4\u0017nZ\u000b\u0002\u0003B\u0011\u0001CQ\u0005\u0003\u0007\u0012\u00111bQ1dQ\u0016\u001cuN\u001c4jO\"AQ\t\u0001B\u0001B\u0003%\u0011)A\u0004d_:4\u0017n\u001a\u0011\t\u0011\u001d\u0003!\u0011!Q\u0001\f!\u000bQa\u00197pG.\u0004\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\tQLW.\u001a\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%JA\u0003DY>\u001c7\u000eC\u0003R\u0001\u0011\u0005!+\u0001\u0004=S:LGO\u0010\u000b\u0003'b#2\u0001\u0016,X!\r)\u0006aE\u0007\u0002\u0005!)q\b\u0015a\u0002\u0003\"9q\t\u0015I\u0001\u0002\bA\u0005\"B\u0010Q\u0001\u0004\t\u0003b\u0002.\u0001\u0005\u0004%)fW\u0001\u0007Y><w-\u001a:\u0016\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\u000bMdg\r\u000e6\u000b\u0003\u0005\f1a\u001c:h\u0013\t\u0019gL\u0001\u0004M_\u001e<WM\u001d\u0005\u0007K\u0002\u0001\u000bQ\u0002/\u0002\u000f1|wmZ3sA!)q\r\u0001C\u0001Q\u0006)Am\\$fiV\u0011\u0011\u000e\u001c\u000b\u0003Uj$\"a\u001b;\u0011\u0007Qa\u0017\u000fB\u0003nM\n\u0007aNA\u0001G+\t9r\u000eB\u0003qY\n\u0007qCA\u0001`!\rQ!oE\u0005\u0003g.\u0011aa\u00149uS>t\u0007\"B;g\u0001\b1\u0018\u0001B7pI\u0016\u00042\u0001E<z\u0013\tAHA\u0001\u0003N_\u0012,\u0007C\u0001\u000bm\u0011\u0015Yh\r1\u0001/\u0003\rYW-\u001f\u0005\u0006{\u0002!\tA`\u0001\u0006I>\u0004V\u000f^\u000b\u0004\u007f\u0006\u0015A\u0003CA\u0001\u0003#\t\u0019\"a\u0006\u0015\t\u0005\r\u00111\u0002\t\u0005)\u0005\u00151\u0004\u0002\u0004ny\n\u0007\u0011qA\u000b\u0004/\u0005%AA\u00029\u0002\u0006\t\u0007q\u0003\u0003\u0004vy\u0002\u000f\u0011Q\u0002\t\u0005!]\fy\u0001E\u0002\u0015\u0003\u000bAQa\u001f?A\u00029Ba!!\u0006}\u0001\u0004\u0019\u0012!\u0002<bYV,\u0007bBA\ry\u0002\u0007\u00111D\u0001\u0004iRd\u0007\u0003\u0002\u0006s\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0005ekJ\fG/[8o\u0015\r\t9cC\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u0016\u0003C\u0011\u0001\u0002R;sCRLwN\u001c\u0005\b\u0003_\u0001A\u0011IA\u0019\u0003!!wNU3n_Z,W\u0003BA\u001a\u0003s!B!!\u000e\u0002FQ!\u0011qGA !\u0011!\u0012\u0011H\u000e\u0005\u000f5\fiC1\u0001\u0002<U\u0019q#!\u0010\u0005\rA\fID1\u0001\u0018\u0011\u001d)\u0018Q\u0006a\u0002\u0003\u0003\u0002B\u0001E<\u0002DA\u0019A#!\u000f\t\rm\fi\u00031\u0001/\u0011\u001d\tI\u0005\u0001C!\u0003\u0017\n1\u0002Z8SK6|g/Z!mYV!\u0011QJA*)\t\ty\u0005\u0006\u0003\u0002R\u0005e\u0003\u0003\u0002\u000b\u0002Tm!q!\\A$\u0005\u0004\t)&F\u0002\u0018\u0003/\"a\u0001]A*\u0005\u00049\u0002bB;\u0002H\u0001\u000f\u00111\f\t\u0005!]\fi\u0006E\u0002\u0015\u0003'Bq!!\u0019\u0001\t\u0003\n\u0019'A\u0003dY>\u001cX-\u0006\u0003\u0002f\u0005-DCAA4)\u0011\tI'!\u001d\u0011\tQ\tYg\u0007\u0003\b[\u0006}#\u0019AA7+\r9\u0012q\u000e\u0003\u0007a\u0006-$\u0019A\f\t\u000fU\fy\u0006q\u0001\u0002tA!\u0001c^A;!\r!\u00121\u000e\u0005\b\u0003s\u0002A\u0011BA>\u00031!x.\u0012=qSJLH+[7f)\u0011\ti(a!\u0011\u0007%\u000by(C\u0002\u0002\u0002*\u0013q!\u00138ti\u0006tG\u000f\u0003\u0005\u0002\u001a\u0005]\u0004\u0019AA\u000f\u000f\u001d\t9I\u0001E\u0001\u0003\u0013\u000bQbQ1gM\u0016Lg.Z\"bG\",\u0007cA+\u0002\f\u001a1\u0011A\u0001E\u0001\u0003\u001b\u001b2!a#\n\u0011\u001d\t\u00161\u0012C\u0001\u0003##\"!!#\t\u0011\u0005U\u00151\u0012C\u0001\u0003/\u000bQ!\u00199qYf,B!!'\u0002 R!\u00111TAQ!\u0011)\u0006!!(\u0011\u0007Q\ty\n\u0002\u0004\u0017\u0003'\u0013\ra\u0006\u0005\u0007\u007f\u0005M\u00059A!\t\u0011\u0005U\u00151\u0012C\u0001\u0003K+B!a*\u00020R!\u0011\u0011VAZ)\u0011\tY+!-\u0011\tU\u0003\u0011Q\u0016\t\u0004)\u0005=FA\u0002\f\u0002$\n\u0007q\u0003\u0003\u0004@\u0003G\u0003\u001d!\u0011\u0005\b?\u0005\r\u0006\u0019AA[!\u0015\u0011CFLA\\!\u0011\u0001\"(!,\t\u0015\u0005m\u00161RI\u0001\n\u0003\ti,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0005\u0003\u007f\u000bi\u000e\u0006\u0003\u0002B\u0006U'f\u0001%\u0002D.\u0012\u0011Q\u0019\t\u0005\u0003\u000f\f\t.\u0004\u0002\u0002J*!\u00111ZAg\u0003%)hn\u00195fG.,GMC\u0002\u0002P.\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019.!3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004 \u0003s\u0003\r!a6\u0011\u000b\tbc&!7\u0011\tAQ\u00141\u001c\t\u0004)\u0005uGA\u0002\f\u0002:\n\u0007q\u0003")
public class CaffeineCache<V>
implements AbstractCache<V> {
    private final Cache<String, Entry<V>> underlying;
    private final CacheConfig config;
    private final Clock clock;
    private final Logger logger;

    public static <V> Clock $lessinit$greater$default$3(Cache<String, Entry<V>> cache) {
        return CaffeineCache$.MODULE$.$lessinit$greater$default$3(cache);
    }

    public static <V> CaffeineCache<V> apply(Cache<String, Entry<V>> cache, CacheConfig cacheConfig) {
        return CaffeineCache$.MODULE$.apply(cache, cacheConfig);
    }

    public static <V> CaffeineCache<V> apply(CacheConfig cacheConfig) {
        return CaffeineCache$.MODULE$.apply(cacheConfig);
    }

    public final <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.get$((AbstractCache)this, keyParts, mode, (Flags)flags);
    }

    public final <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.put$((AbstractCache)this, keyParts, value, ttl, mode, (Flags)flags);
    }

    public final <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return (F)AbstractCache.remove$((AbstractCache)this, keyParts, mode);
    }

    public final <F> F removeAll(Mode<F> mode) {
        return (F)AbstractCache.removeAll$((AbstractCache)this, mode);
    }

    public final <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.caching$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingF$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoize$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoizeF$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public final <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return AbstractCache.caching$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return AbstractCache.cachingF$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return AbstractCache.cachingForMemoize$default$2$((AbstractCache)this, (String)baseKey);
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public <F> Option<Duration> put$default$3(Seq<Object> keyParts) {
        return CacheAlg.put$default$3$((CacheAlg)this, keyParts);
    }

    public Cache<String, Entry<V>> underlying() {
        return this.underlying;
    }

    public CacheConfig config() {
        return this.config;
    }

    public final Logger logger() {
        return this.logger;
    }

    public <F> F doGet(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0 & java.io.Serializable & Serializable)() -> {
            void var3_3;
            Entry entry = (Entry)this.underlying().getIfPresent((Object)key);
            None$ result = entry == null || entry.isExpired($this.clock) ? None$.MODULE$ : new Some(entry.value());
            this.logCacheHitOrMiss(key, (Option)result);
            return var3_3;
        });
    }

    public <F> F doPut(String key, V value, Option<Duration> ttl, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Entry entry = new Entry(value, ttl.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
            this.underlying().put((Object)key, (Object)entry);
            this.logCachePut(key, ttl);
        });
    }

    public <F> F doRemove(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.underlying().invalidate((Object)key));
    }

    public <F> F doRemoveAll(Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.underlying().invalidateAll());
    }

    public <F> F close(Mode<F> mode) {
        return (F)mode.M().pure((Object)BoxedUnit.UNIT);
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public CaffeineCache(Cache<String, Entry<V>> underlying, CacheConfig config, Clock clock) {
        this.underlying = underlying;
        this.config = config;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        AbstractCache.$init$((AbstractCache)this);
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

