/*
 * Decompiled with CFR 0.152.
 */
package scalacache.caffeine;

import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scalacache.Cache;
import scalacache.Entry;
import scalacache.LoggingSupport;
import scalacache.caffeine.CaffeineCache$;
import scalacache.serialization.Codec;
import scalacache.serialization.InMemoryRepr;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001\u001d\u0011QbQ1gM\u0016Lg.Z\"bG\",'BA\u0002\u0005\u0003!\u0019\u0017M\u001a4fS:,'\"A\u0003\u0002\u0015M\u001c\u0017\r\\1dC\u000eDWm\u0001\u0001\u0014\t\u0001Aa\u0002\u0007\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0007=\u0001\"#D\u0001\u0005\u0013\t\tBAA\u0003DC\u000eDW\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005i1/\u001a:jC2L'0\u0019;j_:L!a\u0006\u000b\u0003\u0019%sW*Z7pef\u0014V\r\u001d:\u0011\u0005=I\u0012B\u0001\u000e\u0005\u00059aunZ4j]\u001e\u001cV\u000f\u001d9peRD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u000bk:$WM\u001d7zS:<\u0007\u0003\u0002\u0010)SQj\u0011a\b\u0006\u0003A\u0005\nQaY1dQ\u0016T!a\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00032f]6\fg.Z:\u000b\u0005\u00152\u0013AB4ji\",(MC\u0001(\u0003\r\u0019w.\\\u0005\u0003#}\u0001\"AK\u0019\u000f\u0005-z\u0003C\u0001\u0017\u000b\u001b\u0005i#B\u0001\u0018\u0007\u0003\u0019a$o\\8u}%\u0011\u0001GC\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021\u0015A\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0005Y\u0006twMC\u0001:\u0003\u0011Q\u0017M^1\n\u0005m2$AB(cU\u0016\u001cG\u000f\u0003\u0005>\u0001\t\u0005\t\u0015a\u0003?\u0003\u0015\u0019Gn\\2l!\ty$)D\u0001A\u0015\t\t\u0005(\u0001\u0003uS6,\u0017BA\"A\u0005\u0015\u0019En\\2l\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q\u0011qi\u0013\u000b\u0003\u0011*\u0003\"!\u0013\u0001\u000e\u0003\tAq!\u0010#\u0011\u0002\u0003\u000fa\bC\u0003\u001d\t\u0002\u0007Q\u0004C\u0004N\u0001\t\u0007IQ\u000b(\u0002\r1|wmZ3s+\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0016aA8sO&\u0011a+\u0015\u0002\u0007\u0019><w-\u001a:\t\ra\u0003\u0001\u0015!\u0004P\u0003\u001dawnZ4fe\u0002BQA\u0017\u0001\u0005Bm\u000b1aZ3u+\ta\u0016\u000e\u0006\u0002^oR\u0011aL\u001d\t\u0004?\n$W\"\u00011\u000b\u0005\u0005T\u0011AC2p]\u000e,(O]3oi&\u00111\r\u0019\u0002\u0007\rV$XO]3\u0011\u0007%)w-\u0003\u0002g\u0015\t1q\n\u001d;j_:\u0004\"\u0001[5\r\u0001\u0011)!.\u0017b\u0001W\n\ta+\u0005\u0002m_B\u0011\u0011\"\\\u0005\u0003]*\u0011qAT8uQ&tw\r\u0005\u0002\na&\u0011\u0011O\u0003\u0002\u0004\u0003:L\b\"B:Z\u0001\b!\u0018!B2pI\u0016\u001c\u0007\u0003B\nvOJI!A\u001e\u000b\u0003\u000b\r{G-Z2\t\u000baL\u0006\u0019A\u0015\u0002\u0007-,\u0017\u0010C\u0003{\u0001\u0011\u000530A\u0002qkR,2\u0001`A\u0006)\u001di\u0018QBA\b\u0003'!2A`A\u0003!\ry&m \t\u0004\u0013\u0005\u0005\u0011bAA\u0002\u0015\t!QK\\5u\u0011\u0019\u0019\u0018\u0010q\u0001\u0002\bA)1#^A\u0005%A\u0019\u0001.a\u0003\u0005\u000b)L(\u0019A6\t\u000baL\b\u0019A\u0015\t\u000f\u0005E\u0011\u00101\u0001\u0002\n\u0005)a/\u00197vK\"I\u0011QC=\u0011\u0002\u0003\u0007\u0011qC\u0001\u0004iRd\u0007\u0003B\u0005f\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?\u0001\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\u0005\r\u0012Q\u0004\u0002\t\tV\u0014\u0018\r^5p]\"9\u0011q\u0005\u0001\u0005B\u0005%\u0012A\u0002:f[>4X\rF\u0002\u007f\u0003WAa\u0001_A\u0013\u0001\u0004I\u0003bBA\u0018\u0001\u0011\u0005\u0013\u0011G\u0001\ne\u0016lwN^3BY2$\u0012A \u0005\b\u0003k\u0001A\u0011IA\u001c\u0003\u0015\u0019Gn\\:f)\u0005y\bbBA\u001e\u0001\u0011%\u0011QH\u0001\ri>,\u0005\u0010]5ssRKW.\u001a\u000b\u0005\u0003\u007f\t)\u0005E\u0002@\u0003\u0003J1!a\u0011A\u0005\u001dIen\u001d;b]RD\u0001\"!\u0006\u0002:\u0001\u0007\u0011\u0011\u0004\u0005\n\u0003\u0013\u0002\u0011\u0013!C\u0001\u0003\u0017\nQ\u0002];uI\u0011,g-Y;mi\u0012\u001aT\u0003BA'\u0003G*\"!a\u0014+\t\u0005]\u0011\u0011K\u0016\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\f\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0005]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121!.a\u0012C\u0002-<q!a\u001a\u0003\u0011\u0003\tI'A\u0007DC\u001a4W-\u001b8f\u0007\u0006\u001c\u0007.\u001a\t\u0004\u0013\u0006-dAB\u0001\u0003\u0011\u0003\tigE\u0002\u0002l!Aq!RA6\t\u0003\t\t\b\u0006\u0002\u0002j!A\u0011QOA6\t\u0003\t9(A\u0003baBd\u0017\u0010F\u0001I\u0011!\t)(a\u001b\u0005\u0002\u0005mDc\u0001%\u0002~!1A$!\u001fA\u0002uA!\"!!\u0002lE\u0005I\u0011AAB\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eQ!\u0011QQADU\rq\u0014\u0011\u000b\u0005\u00079\u0005}\u0004\u0019A\u000f")
public class CaffeineCache
implements Cache<InMemoryRepr>,
LoggingSupport {
    private final com.github.benmanes.caffeine.cache.Cache<String, Object> underlying;
    private final Clock clock;
    private final Logger logger;

    public static Clock $lessinit$greater$default$2(com.github.benmanes.caffeine.cache.Cache<String, Object> cache) {
        return CaffeineCache$.MODULE$.$lessinit$greater$default$2(cache);
    }

    public static CaffeineCache apply(com.github.benmanes.caffeine.cache.Cache<String, Object> cache) {
        return CaffeineCache$.MODULE$.apply(cache);
    }

    public static CaffeineCache apply() {
        return CaffeineCache$.MODULE$.apply();
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public final Logger logger() {
        return this.logger;
    }

    public <V> Future<Option<V>> get(String key, Codec<V, InMemoryRepr> codec) {
        Entry entry;
        Object baseValue = this.underlying.getIfPresent((Object)key);
        None$ result = baseValue != null ? ((entry = (Entry)baseValue).isExpired(this.clock) ? None$.MODULE$ : new Some(entry.value())) : None$.MODULE$;
        this.logCacheHitOrMiss(key, (Option)result);
        return Future$.MODULE$.successful((Object)result);
    }

    public <V> Future<BoxedUnit> put(String key, V value, Option<Duration> ttl2, Codec<V, InMemoryRepr> codec) {
        Entry entry = new Entry(value, ttl2.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
        this.underlying.put((Object)key, (Object)entry);
        this.logCachePut(key, ttl2);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public <V> Option<Duration> put$default$3() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> remove(String key) {
        this.underlying.invalidate((Object)key);
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public Future<BoxedUnit> removeAll() {
        this.underlying.invalidateAll();
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public void close() {
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public CaffeineCache(com.github.benmanes.caffeine.cache.Cache<String, Object> underlying, Clock clock) {
        this.underlying = underlying;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

