/*
 * Decompiled with CFR 0.152.
 */
package com.carlosmuvi.segmentedprogressbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.carlosmuvi.segmentedprogressbar.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\nH\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR\u001a\u0010\u0014\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000eR\u001a\u0010\u0017\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/carlosmuvi/segmentedprogressbar/PropertiesModel;", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "getAttrs", "()Landroid/util/AttributeSet;", "containerColor", "", "getContainerColor", "()I", "setContainerColor", "(I)V", "getContext", "()Landroid/content/Context;", "fillColor", "getFillColor", "setFillColor", "segmentCount", "getSegmentCount", "setSegmentCount", "segmentGapWidth", "getSegmentGapWidth", "setSegmentGapWidth", "component1", "component2", "copy", "dpToPx", "valueInDp", "equals", "", "other", "hashCode", "toString", "", "library_release"})
public final class PropertiesModel {
    private int segmentCount;
    private int containerColor;
    private int fillColor;
    private int segmentGapWidth;
    @NotNull
    private final Context context;
    @Nullable
    private final AttributeSet attrs;

    public final int getSegmentCount() {
        return this.segmentCount;
    }

    public final void setSegmentCount(int n) {
        this.segmentCount = n;
    }

    public final int getContainerColor() {
        return this.containerColor;
    }

    public final void setContainerColor(int n) {
        this.containerColor = n;
    }

    public final int getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(int n) {
        this.fillColor = n;
    }

    public final int getSegmentGapWidth() {
        return this.segmentGapWidth;
    }

    public final void setSegmentGapWidth(int n) {
        this.segmentGapWidth = n;
    }

    private final int dpToPx(int valueInDp) {
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return (int)((float)valueInDp * density);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final AttributeSet getAttrs() {
        return this.attrs;
    }

    public PropertiesModel(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.attrs = attrs;
        if (this.attrs != null) {
            TypedArray styledAttrs = this.context.getTheme().obtainStyledAttributes(this.attrs, R.styleable.SegmentedProgressBar, 0, 0);
            this.segmentCount = styledAttrs.getInt(R.styleable.SegmentedProgressBar_segment_count, 5);
            this.containerColor = styledAttrs.getColor(R.styleable.SegmentedProgressBar_container_color, -3355444);
            this.fillColor = styledAttrs.getColor(R.styleable.SegmentedProgressBar_fill_color, -16776961);
            this.segmentGapWidth = styledAttrs.getDimensionPixelSize(R.styleable.SegmentedProgressBar_gap_size, this.dpToPx(1));
        } else {
            this.segmentCount = 5;
            this.containerColor = -3355444;
            this.fillColor = -16776961;
            this.segmentGapWidth = this.dpToPx(1);
        }
    }

    @NotNull
    public final Context component1() {
        return this.context;
    }

    @Nullable
    public final AttributeSet component2() {
        return this.attrs;
    }

    @NotNull
    public final PropertiesModel copy(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new PropertiesModel(context, attrs);
    }

    @NotNull
    public static /* synthetic */ PropertiesModel copy$default(PropertiesModel propertiesModel, Context context, AttributeSet attributeSet, int n, Object object) {
        if ((n & 1) != 0) {
            context = propertiesModel.context;
        }
        if ((n & 2) != 0) {
            attributeSet = propertiesModel.attrs;
        }
        return propertiesModel.copy(context, attributeSet);
    }

    @NotNull
    public String toString() {
        return "PropertiesModel(context=" + this.context + ", attrs=" + this.attrs + ")";
    }

    public int hashCode() {
        Context context = this.context;
        AttributeSet attributeSet = this.attrs;
        return (context != null ? context.hashCode() : 0) * 31 + (attributeSet != null ? attributeSet.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PropertiesModel)) break block3;
                PropertiesModel propertiesModel = (PropertiesModel)object;
                if (!Intrinsics.areEqual((Object)this.context, (Object)propertiesModel.context) || !Intrinsics.areEqual((Object)this.attrs, (Object)propertiesModel.attrs)) break block3;
            }
            return true;
        }
        return false;
    }
}

