/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotSaveListener;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.NetworkUtils;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoPlayer;
import java.io.File;
import moe.codeest.enviews.ENDownloadView;
import moe.codeest.enviews.ENPlayView;

public class StandardGSYVideoPlayer
extends GSYVideoPlayer {
    protected Dialog mBrightnessDialog;
    protected Dialog mVolumeDialog;
    protected Dialog mProgressDialog;
    protected ProgressBar mDialogProgressBar;
    protected ProgressBar mDialogVolumeProgressBar;
    protected TextView mBrightnessDialogTv;
    protected TextView mDialogSeekTime;
    protected TextView mDialogTotalTime;
    protected ImageView mDialogIcon;
    protected Drawable mBottomProgressDrawable;
    protected Drawable mBottomShowProgressDrawable;
    protected Drawable mBottomShowProgressThumbDrawable;
    protected Drawable mVolumeProgressDrawable;
    protected Drawable mDialogProgressBarDrawable;
    protected int mDialogProgressHighLightColor = -11;
    protected int mDialogProgressNormalColor = -11;

    public StandardGSYVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    public StandardGSYVideoPlayer(Context context) {
        super(context);
    }

    public StandardGSYVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        if (this.mBottomProgressDrawable != null) {
            this.mBottomProgressBar.setProgressDrawable(this.mBottomProgressDrawable);
        }
        if (this.mBottomShowProgressDrawable != null) {
            this.mProgressBar.setProgressDrawable(this.mBottomProgressDrawable);
        }
        if (this.mBottomShowProgressThumbDrawable != null) {
            this.mProgressBar.setThumb(this.mBottomShowProgressThumbDrawable);
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.video_layout_standard;
    }

    @Override
    public void startPlayLogic() {
        if (this.mVideoAllCallBack != null) {
            Debuger.printfLog("onClickStartThumb");
            this.mVideoAllCallBack.onClickStartThumb(this.mOriginUrl, this.mTitle, this);
        }
        this.prepareVideo();
        this.startDismissControlViewTimer();
    }

    @Override
    protected void showWifiDialog() {
        if (!NetworkUtils.isAvailable(this.mContext)) {
            this.startPlayLogic();
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getActivityContext());
        builder.setMessage((CharSequence)this.getResources().getString(R.string.tips_not_wifi));
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_confirm), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                StandardGSYVideoPlayer.this.startPlayLogic();
            }
        });
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.tips_not_wifi_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    @Override
    protected void showProgressDialog(float deltaX, String seekTime, int seekTimePosition, String totalTime, int totalTimeDuration) {
        if (this.mProgressDialog == null) {
            View localView = LayoutInflater.from((Context)this.getActivityContext()).inflate(this.getProgressDialogLayoutId(), null);
            if (localView.findViewById(this.getProgressDialogProgressId()) instanceof ProgressBar) {
                this.mDialogProgressBar = (ProgressBar)localView.findViewById(this.getProgressDialogProgressId());
                if (this.mDialogProgressBarDrawable != null) {
                    this.mDialogProgressBar.setProgressDrawable(this.mDialogProgressBarDrawable);
                }
            }
            if (localView.findViewById(this.getProgressDialogCurrentDurationTextId()) instanceof TextView) {
                this.mDialogSeekTime = (TextView)localView.findViewById(this.getProgressDialogCurrentDurationTextId());
            }
            if (localView.findViewById(this.getProgressDialogAllDurationTextId()) instanceof TextView) {
                this.mDialogTotalTime = (TextView)localView.findViewById(this.getProgressDialogAllDurationTextId());
            }
            if (localView.findViewById(this.getProgressDialogImageId()) instanceof ImageView) {
                this.mDialogIcon = (ImageView)localView.findViewById(this.getProgressDialogImageId());
            }
            this.mProgressDialog = new Dialog(this.getActivityContext(), R.style.video_style_dialog_progress);
            this.mProgressDialog.setContentView(localView);
            this.mProgressDialog.getWindow().addFlags(8);
            this.mProgressDialog.getWindow().addFlags(32);
            this.mProgressDialog.getWindow().addFlags(16);
            this.mProgressDialog.getWindow().setLayout(this.getWidth(), this.getHeight());
            if (this.mDialogProgressNormalColor != -11 && this.mDialogTotalTime != null) {
                this.mDialogTotalTime.setTextColor(this.mDialogProgressNormalColor);
            }
            if (this.mDialogProgressHighLightColor != -11 && this.mDialogSeekTime != null) {
                this.mDialogSeekTime.setTextColor(this.mDialogProgressHighLightColor);
            }
            WindowManager.LayoutParams localLayoutParams = this.mProgressDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 48;
            localLayoutParams.width = this.getWidth();
            localLayoutParams.height = this.getHeight();
            int[] location = new int[2];
            this.getLocationOnScreen(location);
            localLayoutParams.x = location[0];
            localLayoutParams.y = location[1];
            this.mProgressDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mProgressDialog.isShowing()) {
            this.mProgressDialog.show();
        }
        if (this.mDialogSeekTime != null) {
            this.mDialogSeekTime.setText((CharSequence)seekTime);
        }
        if (this.mDialogTotalTime != null) {
            this.mDialogTotalTime.setText((CharSequence)(" / " + totalTime));
        }
        if (totalTimeDuration > 0 && this.mDialogProgressBar != null) {
            this.mDialogProgressBar.setProgress(seekTimePosition * 100 / totalTimeDuration);
        }
        if (deltaX > 0.0f) {
            if (this.mDialogIcon != null) {
                this.mDialogIcon.setBackgroundResource(R.drawable.video_forward_icon);
            }
        } else if (this.mDialogIcon != null) {
            this.mDialogIcon.setBackgroundResource(R.drawable.video_backward_icon);
        }
    }

    @Override
    protected void dismissProgressDialog() {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
            this.mProgressDialog = null;
        }
    }

    @Override
    protected void showVolumeDialog(float deltaY, int volumePercent) {
        if (this.mVolumeDialog == null) {
            View localView = LayoutInflater.from((Context)this.getActivityContext()).inflate(this.getVolumeLayoutId(), null);
            if (localView.findViewById(this.getVolumeProgressId()) instanceof ProgressBar) {
                this.mDialogVolumeProgressBar = (ProgressBar)localView.findViewById(this.getVolumeProgressId());
                if (this.mVolumeProgressDrawable != null && this.mDialogVolumeProgressBar != null) {
                    this.mDialogVolumeProgressBar.setProgressDrawable(this.mVolumeProgressDrawable);
                }
            }
            this.mVolumeDialog = new Dialog(this.getActivityContext(), R.style.video_style_dialog_progress);
            this.mVolumeDialog.setContentView(localView);
            this.mVolumeDialog.getWindow().addFlags(8);
            this.mVolumeDialog.getWindow().addFlags(32);
            this.mVolumeDialog.getWindow().addFlags(16);
            this.mVolumeDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mVolumeDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 51;
            localLayoutParams.width = this.getWidth();
            localLayoutParams.height = this.getHeight();
            int[] location = new int[2];
            this.getLocationOnScreen(location);
            localLayoutParams.x = location[0];
            localLayoutParams.y = location[1];
            this.mVolumeDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mVolumeDialog.isShowing()) {
            this.mVolumeDialog.show();
        }
        if (this.mDialogVolumeProgressBar != null) {
            this.mDialogVolumeProgressBar.setProgress(volumePercent);
        }
    }

    @Override
    protected void dismissVolumeDialog() {
        if (this.mVolumeDialog != null) {
            this.mVolumeDialog.dismiss();
            this.mVolumeDialog = null;
        }
    }

    @Override
    protected void showBrightnessDialog(float percent) {
        if (this.mBrightnessDialog == null) {
            View localView = LayoutInflater.from((Context)this.getActivityContext()).inflate(this.getBrightnessLayoutId(), null);
            if (localView.findViewById(this.getBrightnessTextId()) instanceof TextView) {
                this.mBrightnessDialogTv = (TextView)localView.findViewById(this.getBrightnessTextId());
            }
            this.mBrightnessDialog = new Dialog(this.getActivityContext(), R.style.video_style_dialog_progress);
            this.mBrightnessDialog.setContentView(localView);
            this.mBrightnessDialog.getWindow().addFlags(8);
            this.mBrightnessDialog.getWindow().addFlags(32);
            this.mBrightnessDialog.getWindow().addFlags(16);
            this.mBrightnessDialog.getWindow().setLayout(-2, -2);
            WindowManager.LayoutParams localLayoutParams = this.mBrightnessDialog.getWindow().getAttributes();
            localLayoutParams.gravity = 53;
            localLayoutParams.width = this.getWidth();
            localLayoutParams.height = this.getHeight();
            int[] location = new int[2];
            this.getLocationOnScreen(location);
            localLayoutParams.x = location[0];
            localLayoutParams.y = location[1];
            this.mBrightnessDialog.getWindow().setAttributes(localLayoutParams);
        }
        if (!this.mBrightnessDialog.isShowing()) {
            this.mBrightnessDialog.show();
        }
        if (this.mBrightnessDialogTv != null) {
            this.mBrightnessDialogTv.setText((CharSequence)((int)(percent * 100.0f) + "%"));
        }
    }

    @Override
    protected void dismissBrightnessDialog() {
        if (this.mBrightnessDialog != null) {
            this.mBrightnessDialog.dismiss();
            this.mBrightnessDialog = null;
        }
    }

    @Override
    protected void cloneParams(GSYBaseVideoPlayer from, GSYBaseVideoPlayer to) {
        super.cloneParams(from, to);
        StandardGSYVideoPlayer sf = (StandardGSYVideoPlayer)from;
        StandardGSYVideoPlayer st = (StandardGSYVideoPlayer)to;
        if (st.mProgressBar != null && sf.mProgressBar != null) {
            st.mProgressBar.setProgress(sf.mProgressBar.getProgress());
            st.mProgressBar.setSecondaryProgress(sf.mProgressBar.getSecondaryProgress());
        }
        if (st.mTotalTimeTextView != null && sf.mTotalTimeTextView != null) {
            st.mTotalTimeTextView.setText(sf.mTotalTimeTextView.getText());
        }
        if (st.mCurrentTimeTextView != null && sf.mCurrentTimeTextView != null) {
            st.mCurrentTimeTextView.setText(sf.mCurrentTimeTextView.getText());
        }
    }

    @Override
    public GSYBaseVideoPlayer startWindowFullscreen(Context context, boolean actionBar, boolean statusBar) {
        GSYBaseVideoPlayer gsyBaseVideoPlayer = super.startWindowFullscreen(context, actionBar, statusBar);
        if (gsyBaseVideoPlayer != null) {
            StandardGSYVideoPlayer gsyVideoPlayer = (StandardGSYVideoPlayer)gsyBaseVideoPlayer;
            gsyVideoPlayer.setLockClickListener(this.mLockClickListener);
            gsyVideoPlayer.setNeedLockFull(this.isNeedLockFull());
            this.initFullUI(gsyVideoPlayer);
        }
        return gsyBaseVideoPlayer;
    }

    @Override
    protected void onClickUiToggle() {
        if (this.mIfCurrentIsFullscreen && this.mLockCurScreen && this.mNeedLockFull) {
            this.setViewShowState((View)this.mLockScreen, 0);
            return;
        }
        if (this.mCurrentState == 1) {
            if (this.mBottomContainer != null) {
                if (this.mBottomContainer.getVisibility() == 0) {
                    this.changeUiToPrepareingClear();
                } else {
                    this.changeUiToPreparingShow();
                }
            }
        } else if (this.mCurrentState == 2) {
            if (this.mBottomContainer != null) {
                if (this.mBottomContainer.getVisibility() == 0) {
                    this.changeUiToPlayingClear();
                } else {
                    this.changeUiToPlayingShow();
                }
            }
        } else if (this.mCurrentState == 5) {
            if (this.mBottomContainer != null) {
                if (this.mBottomContainer.getVisibility() == 0) {
                    this.changeUiToPauseClear();
                } else {
                    this.changeUiToPauseShow();
                }
            }
        } else if (this.mCurrentState == 6) {
            if (this.mBottomContainer != null) {
                if (this.mBottomContainer.getVisibility() == 0) {
                    this.changeUiToCompleteClear();
                } else {
                    this.changeUiToCompleteShow();
                }
            }
        } else if (this.mCurrentState == 3 && this.mBottomContainer != null) {
            if (this.mBottomContainer.getVisibility() == 0) {
                this.changeUiToPlayingBufferingClear();
            } else {
                this.changeUiToPlayingBufferingShow();
            }
        }
    }

    @Override
    protected void hideAllWidget() {
        this.setViewShowState((View)this.mBottomContainer, 4);
        this.setViewShowState((View)this.mTopContainer, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 0);
        this.setViewShowState(this.mStartButton, 4);
    }

    @Override
    protected void changeUiToNormal() {
        Debuger.printfLog("changeUiToNormal");
        this.setViewShowState((View)this.mTopContainer, 0);
        this.setViewShowState((View)this.mBottomContainer, 4);
        this.setViewShowState(this.mStartButton, 0);
        this.setViewShowState(this.mLoadingProgressBar, 4);
        this.setViewShowState((View)this.mThumbImageViewLayout, 0);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, this.mIfCurrentIsFullscreen && this.mNeedLockFull ? 0 : 8);
        this.updateStartImage();
        if (this.mLoadingProgressBar instanceof ENDownloadView) {
            ((ENDownloadView)this.mLoadingProgressBar).reset();
        }
    }

    @Override
    protected void changeUiToPreparingShow() {
        ENDownloadView enDownloadView;
        Debuger.printfLog("changeUiToPreparingShow");
        this.setViewShowState((View)this.mTopContainer, 0);
        this.setViewShowState((View)this.mBottomContainer, 0);
        this.setViewShowState(this.mStartButton, 4);
        this.setViewShowState(this.mLoadingProgressBar, 0);
        this.setViewShowState((View)this.mThumbImageViewLayout, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView && (enDownloadView = (ENDownloadView)this.mLoadingProgressBar).getCurrentState() == 0) {
            ((ENDownloadView)this.mLoadingProgressBar).start();
        }
    }

    @Override
    protected void changeUiToPlayingShow() {
        Debuger.printfLog("changeUiToPlayingShow");
        this.setViewShowState((View)this.mTopContainer, 0);
        this.setViewShowState((View)this.mBottomContainer, 0);
        this.setViewShowState(this.mStartButton, 0);
        this.setViewShowState(this.mLoadingProgressBar, 4);
        this.setViewShowState((View)this.mThumbImageViewLayout, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, this.mIfCurrentIsFullscreen && this.mNeedLockFull ? 0 : 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView) {
            ((ENDownloadView)this.mLoadingProgressBar).reset();
        }
        this.updateStartImage();
    }

    @Override
    protected void changeUiToPauseShow() {
        Debuger.printfLog("changeUiToPauseShow");
        this.setViewShowState((View)this.mTopContainer, 0);
        this.setViewShowState((View)this.mBottomContainer, 0);
        this.setViewShowState(this.mStartButton, 0);
        this.setViewShowState(this.mLoadingProgressBar, 4);
        this.setViewShowState((View)this.mThumbImageViewLayout, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, this.mIfCurrentIsFullscreen && this.mNeedLockFull ? 0 : 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView) {
            ((ENDownloadView)this.mLoadingProgressBar).reset();
        }
        this.updateStartImage();
        this.updatePauseCover();
    }

    @Override
    protected void changeUiToPlayingBufferingShow() {
        ENDownloadView enDownloadView;
        Debuger.printfLog("changeUiToPlayingBufferingShow");
        this.setViewShowState((View)this.mTopContainer, 0);
        this.setViewShowState((View)this.mBottomContainer, 0);
        this.setViewShowState(this.mStartButton, 4);
        this.setViewShowState(this.mLoadingProgressBar, 0);
        this.setViewShowState((View)this.mThumbImageViewLayout, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView && (enDownloadView = (ENDownloadView)this.mLoadingProgressBar).getCurrentState() == 0) {
            ((ENDownloadView)this.mLoadingProgressBar).start();
        }
    }

    @Override
    protected void changeUiToCompleteShow() {
        Debuger.printfLog("changeUiToCompleteShow");
        this.setViewShowState((View)this.mTopContainer, 0);
        this.setViewShowState((View)this.mBottomContainer, 0);
        this.setViewShowState(this.mStartButton, 0);
        this.setViewShowState(this.mLoadingProgressBar, 4);
        this.setViewShowState((View)this.mThumbImageViewLayout, 0);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, this.mIfCurrentIsFullscreen && this.mNeedLockFull ? 0 : 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView) {
            ((ENDownloadView)this.mLoadingProgressBar).reset();
        }
        this.updateStartImage();
    }

    @Override
    protected void changeUiToError() {
        Debuger.printfLog("changeUiToError");
        this.setViewShowState((View)this.mTopContainer, 4);
        this.setViewShowState((View)this.mBottomContainer, 4);
        this.setViewShowState(this.mStartButton, 0);
        this.setViewShowState(this.mLoadingProgressBar, 4);
        this.setViewShowState((View)this.mThumbImageViewLayout, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, this.mIfCurrentIsFullscreen && this.mNeedLockFull ? 0 : 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView) {
            ((ENDownloadView)this.mLoadingProgressBar).reset();
        }
        this.updateStartImage();
    }

    protected int getProgressDialogLayoutId() {
        return R.layout.video_progress_dialog;
    }

    protected int getProgressDialogProgressId() {
        return R.id.duration_progressbar;
    }

    protected int getProgressDialogCurrentDurationTextId() {
        return R.id.tv_current;
    }

    protected int getProgressDialogAllDurationTextId() {
        return R.id.tv_duration;
    }

    protected int getProgressDialogImageId() {
        return R.id.duration_image_tip;
    }

    protected int getVolumeLayoutId() {
        return R.layout.video_volume_dialog;
    }

    protected int getVolumeProgressId() {
        return R.id.volume_progressbar;
    }

    protected int getBrightnessLayoutId() {
        return R.layout.video_brightness;
    }

    protected int getBrightnessTextId() {
        return R.id.app_video_brightness;
    }

    protected void changeUiToPrepareingClear() {
        Debuger.printfLog("changeUiToPrepareingClear");
        this.setViewShowState((View)this.mTopContainer, 4);
        this.setViewShowState((View)this.mBottomContainer, 4);
        this.setViewShowState(this.mStartButton, 4);
        this.setViewShowState(this.mLoadingProgressBar, 4);
        this.setViewShowState((View)this.mThumbImageViewLayout, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView) {
            ((ENDownloadView)this.mLoadingProgressBar).reset();
        }
    }

    protected void changeUiToPlayingClear() {
        Debuger.printfLog("changeUiToPlayingClear");
        this.changeUiToClear();
        this.setViewShowState((View)this.mBottomProgressBar, 0);
    }

    protected void changeUiToPauseClear() {
        Debuger.printfLog("changeUiToPauseClear");
        this.changeUiToClear();
        this.setViewShowState((View)this.mBottomProgressBar, 0);
        this.updatePauseCover();
    }

    protected void changeUiToPlayingBufferingClear() {
        ENDownloadView enDownloadView;
        Debuger.printfLog("changeUiToPlayingBufferingClear");
        this.setViewShowState((View)this.mTopContainer, 4);
        this.setViewShowState((View)this.mBottomContainer, 4);
        this.setViewShowState(this.mStartButton, 4);
        this.setViewShowState(this.mLoadingProgressBar, 0);
        this.setViewShowState((View)this.mThumbImageViewLayout, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 0);
        this.setViewShowState((View)this.mLockScreen, 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView && (enDownloadView = (ENDownloadView)this.mLoadingProgressBar).getCurrentState() == 0) {
            ((ENDownloadView)this.mLoadingProgressBar).start();
        }
        this.updateStartImage();
    }

    protected void changeUiToClear() {
        Debuger.printfLog("changeUiToClear");
        this.setViewShowState((View)this.mTopContainer, 4);
        this.setViewShowState((View)this.mBottomContainer, 4);
        this.setViewShowState(this.mStartButton, 4);
        this.setViewShowState(this.mLoadingProgressBar, 4);
        this.setViewShowState((View)this.mThumbImageViewLayout, 4);
        this.setViewShowState((View)this.mBottomProgressBar, 4);
        this.setViewShowState((View)this.mLockScreen, 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView) {
            ((ENDownloadView)this.mLoadingProgressBar).reset();
        }
    }

    protected void changeUiToCompleteClear() {
        Debuger.printfLog("changeUiToCompleteClear");
        this.setViewShowState((View)this.mTopContainer, 4);
        this.setViewShowState((View)this.mBottomContainer, 4);
        this.setViewShowState(this.mStartButton, 0);
        this.setViewShowState(this.mLoadingProgressBar, 4);
        this.setViewShowState((View)this.mThumbImageViewLayout, 0);
        this.setViewShowState((View)this.mBottomProgressBar, 0);
        this.setViewShowState((View)this.mLockScreen, this.mIfCurrentIsFullscreen && this.mNeedLockFull ? 0 : 8);
        if (this.mLoadingProgressBar instanceof ENDownloadView) {
            ((ENDownloadView)this.mLoadingProgressBar).reset();
        }
        this.updateStartImage();
    }

    protected void updateStartImage() {
        if (this.mStartButton instanceof ENPlayView) {
            ENPlayView enPlayView = (ENPlayView)this.mStartButton;
            enPlayView.setDuration(500);
            if (this.mCurrentState == 2) {
                enPlayView.play();
            } else if (this.mCurrentState == 7) {
                enPlayView.pause();
            } else {
                enPlayView.pause();
            }
        } else if (this.mStartButton instanceof ImageView) {
            ImageView imageView = (ImageView)this.mStartButton;
            if (this.mCurrentState == 2) {
                imageView.setImageResource(R.drawable.video_click_pause_selector);
            } else if (this.mCurrentState == 7) {
                imageView.setImageResource(R.drawable.video_click_error_selector);
            } else {
                imageView.setImageResource(R.drawable.video_click_play_selector);
            }
        }
    }

    private void initFullUI(StandardGSYVideoPlayer standardGSYVideoPlayer) {
        if (this.mBottomProgressDrawable != null) {
            standardGSYVideoPlayer.setBottomProgressBarDrawable(this.mBottomProgressDrawable);
        }
        if (this.mBottomShowProgressDrawable != null && this.mBottomShowProgressThumbDrawable != null) {
            standardGSYVideoPlayer.setBottomShowProgressBarDrawable(this.mBottomShowProgressDrawable, this.mBottomShowProgressThumbDrawable);
        }
        if (this.mVolumeProgressDrawable != null) {
            standardGSYVideoPlayer.setDialogVolumeProgressBar(this.mVolumeProgressDrawable);
        }
        if (this.mDialogProgressBarDrawable != null) {
            standardGSYVideoPlayer.setDialogProgressBar(this.mDialogProgressBarDrawable);
        }
        if (this.mDialogProgressHighLightColor >= 0 && this.mDialogProgressNormalColor >= 0) {
            standardGSYVideoPlayer.setDialogProgressColor(this.mDialogProgressHighLightColor, this.mDialogProgressNormalColor);
        }
    }

    public void setBottomShowProgressBarDrawable(Drawable drawable2, Drawable thumb) {
        this.mBottomShowProgressDrawable = drawable2;
        this.mBottomShowProgressThumbDrawable = thumb;
        if (this.mProgressBar != null) {
            this.mProgressBar.setProgressDrawable(drawable2);
            this.mProgressBar.setThumb(thumb);
        }
    }

    public void setBottomProgressBarDrawable(Drawable drawable2) {
        this.mBottomProgressDrawable = drawable2;
        if (this.mBottomProgressBar != null) {
            this.mBottomProgressBar.setProgressDrawable(drawable2);
        }
    }

    public void setDialogVolumeProgressBar(Drawable drawable2) {
        this.mVolumeProgressDrawable = drawable2;
    }

    public void setDialogProgressBar(Drawable drawable2) {
        this.mDialogProgressBarDrawable = drawable2;
    }

    public void setDialogProgressColor(int highLightColor, int normalColor) {
        this.mDialogProgressHighLightColor = highLightColor;
        this.mDialogProgressNormalColor = normalColor;
    }

    public void taskShotPic(GSYVideoShotListener gsyVideoShotListener) {
        this.taskShotPic(gsyVideoShotListener, false);
    }

    public void taskShotPic(GSYVideoShotListener gsyVideoShotListener, boolean high) {
        if (this.getCurrentPlayer().getRenderProxy() != null) {
            this.getCurrentPlayer().getRenderProxy().taskShotPic(gsyVideoShotListener, high);
        }
    }

    public void saveFrame(File file, GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        this.saveFrame(file, false, gsyVideoShotSaveListener);
    }

    public void saveFrame(File file, boolean high, GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        if (this.getCurrentPlayer().getRenderProxy() != null) {
            this.getCurrentPlayer().getRenderProxy().saveFrame(file, high, gsyVideoShotSaveListener);
        }
    }

    public void restartTimerTask() {
        this.startProgressTimer();
        this.startDismissControlViewTimer();
    }
}

