/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotSaveListener;
import com.shuyu.gsyvideoplayer.render.GSYRenderView;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;
import com.shuyu.gsyvideoplayer.render.view.IGSYRenderView;
import com.shuyu.gsyvideoplayer.render.view.listener.IGSYSurfaceListener;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.FileUtils;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;
import java.io.File;

public class GSYTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
IGSYRenderView,
MeasureHelper.MeasureFormVideoParamsListener {
    private IGSYSurfaceListener mIGSYSurfaceListener;
    private MeasureHelper.MeasureFormVideoParamsListener mVideoParamsListener;
    private MeasureHelper measureHelper;
    private SurfaceTexture mSaveTexture;
    private Surface mSurface;

    public GSYTextureView(Context context) {
        super(context);
        this.init();
    }

    public GSYTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.measureHelper = new MeasureHelper((View)this, this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureHelper.prepareMeasure(widthMeasureSpec, heightMeasureSpec, (int)this.getRotation());
        this.setMeasuredDimension(this.measureHelper.getMeasuredWidth(), this.measureHelper.getMeasuredHeight());
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (GSYVideoType.isMediaCodecTexture()) {
            if (this.mSaveTexture == null) {
                this.mSaveTexture = surface;
                this.mSurface = new Surface(surface);
            } else {
                this.setSurfaceTexture(this.mSaveTexture);
            }
            if (this.mIGSYSurfaceListener != null) {
                this.mIGSYSurfaceListener.onSurfaceAvailable(this.mSurface);
            }
        } else {
            this.mSurface = new Surface(surface);
            if (this.mIGSYSurfaceListener != null) {
                this.mIGSYSurfaceListener.onSurfaceAvailable(this.mSurface);
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        if (this.mIGSYSurfaceListener != null) {
            this.mIGSYSurfaceListener.onSurfaceSizeChanged(this.mSurface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (this.mIGSYSurfaceListener != null) {
            this.mIGSYSurfaceListener.onSurfaceDestroyed(this.mSurface);
        }
        if (GSYVideoType.isMediaCodecTexture()) {
            return this.mSaveTexture == null;
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.mIGSYSurfaceListener != null) {
            this.mIGSYSurfaceListener.onSurfaceUpdated(this.mSurface);
        }
    }

    @Override
    public IGSYSurfaceListener getIGSYSurfaceListener() {
        return this.mIGSYSurfaceListener;
    }

    @Override
    public void setIGSYSurfaceListener(IGSYSurfaceListener surfaceListener) {
        this.setSurfaceTextureListener(this);
        this.mIGSYSurfaceListener = surfaceListener;
    }

    @Override
    public int getSizeH() {
        return this.getHeight();
    }

    @Override
    public int getSizeW() {
        return this.getWidth();
    }

    @Override
    public Bitmap initCover() {
        if (this.getSizeW() <= 0 || this.getSizeH() <= 0) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.getSizeW(), (int)this.getSizeH(), (Bitmap.Config)Bitmap.Config.RGB_565);
        return this.getBitmap(bitmap);
    }

    @Override
    public Bitmap initCoverHigh() {
        if (this.getSizeW() <= 0 || this.getSizeH() <= 0) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.getSizeW(), (int)this.getSizeH(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return this.getBitmap(bitmap);
    }

    @Override
    public void taskShotPic(GSYVideoShotListener gsyVideoShotListener, boolean shotHigh) {
        if (shotHigh) {
            gsyVideoShotListener.getBitmap(this.initCoverHigh());
        } else {
            gsyVideoShotListener.getBitmap(this.initCover());
        }
    }

    @Override
    public void saveFrame(final File file, boolean high, final GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        GSYVideoShotListener gsyVideoShotListener = new GSYVideoShotListener(){

            @Override
            public void getBitmap(Bitmap bitmap) {
                if (bitmap == null) {
                    gsyVideoShotSaveListener.result(false, file);
                } else {
                    FileUtils.saveBitmap(bitmap, file);
                    gsyVideoShotSaveListener.result(true, file);
                }
            }
        };
        if (high) {
            gsyVideoShotListener.getBitmap(this.initCoverHigh());
        } else {
            gsyVideoShotListener.getBitmap(this.initCover());
        }
    }

    @Override
    public View getRenderView() {
        return this;
    }

    @Override
    public void onRenderResume() {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support onRenderResume now");
    }

    @Override
    public void onRenderPause() {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support onRenderPause now");
    }

    @Override
    public void releaseRenderAll() {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support releaseRenderAll now");
    }

    @Override
    public void setRenderMode(int mode) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setRenderMode now");
    }

    @Override
    public void setRenderTransform(Matrix transform) {
        this.setTransform(transform);
    }

    @Override
    public void setGLRenderer(GSYVideoGLViewBaseRender renderer) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setGLRenderer now");
    }

    @Override
    public void setGLMVPMatrix(float[] MVPMatrix) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setGLMVPMatrix now");
    }

    @Override
    public void setGLEffectFilter(GSYVideoGLView.ShaderInterface effectFilter) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setGLEffectFilter now");
    }

    @Override
    public void setVideoParamsListener(MeasureHelper.MeasureFormVideoParamsListener listener) {
        this.mVideoParamsListener = listener;
    }

    @Override
    public int getCurrentVideoWidth() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getCurrentVideoWidth();
        }
        return 0;
    }

    @Override
    public int getCurrentVideoHeight() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getCurrentVideoHeight();
        }
        return 0;
    }

    @Override
    public int getVideoSarNum() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getVideoSarNum();
        }
        return 0;
    }

    @Override
    public int getVideoSarDen() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getVideoSarDen();
        }
        return 0;
    }

    public static GSYTextureView addTextureView(Context context, ViewGroup textureViewContainer, int rotate, IGSYSurfaceListener gsySurfaceListener, MeasureHelper.MeasureFormVideoParamsListener videoParamsListener) {
        if (textureViewContainer.getChildCount() > 0) {
            textureViewContainer.removeAllViews();
        }
        GSYTextureView gsyTextureView = new GSYTextureView(context);
        gsyTextureView.setIGSYSurfaceListener(gsySurfaceListener);
        gsyTextureView.setVideoParamsListener(videoParamsListener);
        gsyTextureView.setRotation(rotate);
        GSYRenderView.addToParent(textureViewContainer, (View)gsyTextureView);
        return gsyTextureView;
    }
}

