/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.player;

import android.content.Context;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.os.Message;
import android.view.Surface;
import com.shuyu.gsyvideoplayer.cache.ICacheManager;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.IPlayerManager;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import java.util.List;
import tv.danmaku.ijk.media.player.AndroidMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class SystemPlayerManager
implements IPlayerManager {
    private AndroidMediaPlayer mediaPlayer;
    private Surface surface;
    private boolean release;

    public IMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public void initVideoPlayer(Context context, Message msg, List<VideoOptionModel> optionModelList, ICacheManager cacheManager) {
        this.mediaPlayer = new AndroidMediaPlayer();
        this.mediaPlayer.setAudioStreamType(3);
        this.release = false;
        GSYModel gsyModel = (GSYModel)msg.obj;
        try {
            if (gsyModel.isCache() && cacheManager != null) {
                cacheManager.doCacheLogic(context, (IMediaPlayer)this.mediaPlayer, gsyModel.getUrl(), gsyModel.getMapHeadData(), gsyModel.getCachePath());
            } else {
                this.mediaPlayer.setDataSource(context, Uri.parse((String)gsyModel.getUrl()), gsyModel.getMapHeadData());
            }
            this.mediaPlayer.setLooping(gsyModel.isLooping());
            if (gsyModel.getSpeed() != 1.0f && gsyModel.getSpeed() > 0.0f) {
                this.setSpeed(gsyModel.getSpeed());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showDisplay(Message msg) {
        if (msg.obj == null && this.mediaPlayer != null && !this.release) {
            this.mediaPlayer.setSurface(null);
        } else if (msg.obj != null) {
            Surface holder;
            this.surface = holder = (Surface)msg.obj;
            if (this.mediaPlayer != null && holder.isValid() && !this.release) {
                this.mediaPlayer.setSurface(holder);
            }
        }
    }

    public void setSpeed(float speed, boolean soundTouch) {
        this.setSpeed(speed);
    }

    public void setNeedMute(boolean needMute) {
        try {
            if (this.mediaPlayer != null && !this.release) {
                if (needMute) {
                    this.mediaPlayer.setVolume(0.0f, 0.0f);
                } else {
                    this.mediaPlayer.setVolume(1.0f, 1.0f);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void releaseSurface() {
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
    }

    public void release() {
        if (this.mediaPlayer != null) {
            this.release = true;
            this.mediaPlayer.release();
        }
    }

    public int getBufferedPercentage() {
        return -1;
    }

    public long getNetSpeed() {
        if (this.mediaPlayer != null) {
            // empty if block
        }
        return 0L;
    }

    public void setSpeedPlaying(float speed, boolean soundTouch) {
    }

    public void start() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
    }

    public void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    public void pause() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.pause();
        }
    }

    public int getVideoWidth() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoWidth();
        }
        return 0;
    }

    public int getVideoHeight() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoHeight();
        }
        return 0;
    }

    public boolean isPlaying() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.isPlaying();
        }
        return false;
    }

    public void seekTo(long time) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.seekTo(time);
        }
    }

    public long getCurrentPosition() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    public long getDuration() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getDuration();
        }
        return 0L;
    }

    public int getVideoSarNum() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoSarNum();
        }
        return 1;
    }

    public int getVideoSarDen() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoSarDen();
        }
        return 1;
    }

    public boolean isSurfaceSupportLockCanvas() {
        return false;
    }

    private void setSpeed(float speed) {
        if (this.release) {
            return;
        }
        if (this.mediaPlayer != null && this.mediaPlayer.getInternalMediaPlayer() != null && this.mediaPlayer.isPlayable()) {
            try {
                if (Build.VERSION.SDK_INT >= 23) {
                    PlaybackParams playbackParams = new PlaybackParams();
                    playbackParams.setSpeed(speed);
                    this.mediaPlayer.getInternalMediaPlayer().setPlaybackParams(playbackParams);
                } else {
                    Debuger.printfError(" not support setSpeed");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

