/*
 * Decompiled with CFR 0.152.
 */
package com.github.captain_miao.optroundcardview;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import com.github.captain_miao.optroundcardview.RoundRectDrawableWithShadow;

@TargetApi(value=19)
public class OptRoundRectDrawableWithShadow
extends RoundRectDrawableWithShadow {
    public static final int FLAG_LEFT_EDGES = 1;
    public static final int FLAG_TOP_EDGES = 2;
    public static final int FLAG_RIGHT_EDGES = 4;
    public static final int FLAG_BOTTOM_EDGES = 8;
    private boolean leftTopRect = false;
    private boolean rightTopRect = false;
    private boolean leftBottomRect = false;
    private boolean rightBottomRect = false;
    private boolean leftEdgeShadow = true;
    private boolean topEdgeShadow = true;
    private boolean rightEdgeShadow = true;
    private boolean bottomEdgeShadow = true;

    public OptRoundRectDrawableWithShadow(Resources resources, int backgroundColor, float radius, float shadowSize, float maxShadowSize, int cornerFlag, int edgesFlag) {
        super(resources, backgroundColor, radius, shadowSize, maxShadowSize);
        this.leftTopRect = (1 & cornerFlag) == 0;
        this.rightTopRect = (2 & cornerFlag) == 0;
        this.leftBottomRect = (4 & cornerFlag) == 0;
        this.rightBottomRect = (8 & cornerFlag) == 0;
        this.leftEdgeShadow = (1 & edgesFlag) != 0;
        this.topEdgeShadow = (2 & edgesFlag) != 0;
        this.rightEdgeShadow = (4 & edgesFlag) != 0;
        this.bottomEdgeShadow = (8 & edgesFlag) != 0;
        this.init();
    }

    public OptRoundRectDrawableWithShadow(Resources resources, int backgroundColor, float radius, float shadowSize, float maxShadowSize) {
        super(resources, backgroundColor, radius, shadowSize, maxShadowSize);
        this.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT >= 17) {
            this.initJellyBeanMr1();
        } else {
            this.initEclairMr1();
        }
    }

    private void initJellyBeanMr1() {
        sRoundRectHelper = new RoundRectDrawableWithShadow.RoundRectHelper(){

            @Override
            public void drawRoundRect(Canvas canvas, RectF bounds, float radius, Paint paint) {
                canvas.drawRoundRect(bounds, radius, radius, paint);
            }
        };
    }

    private void initEclairMr1() {
        final RectF rectF = new RectF();
        sRoundRectHelper = new RoundRectDrawableWithShadow.RoundRectHelper(){

            @Override
            public void drawRoundRect(Canvas canvas, RectF bounds, float radius, Paint paint) {
                float innerWidth = bounds.width() - radius * 2.0f - 1.0f;
                float innerHeight = bounds.height() - radius * 2.0f - 1.0f;
                if (radius >= 1.0f) {
                    rectF.set(-(radius += 0.5f), -radius, radius, radius);
                    int saved = canvas.save();
                    canvas.translate(bounds.left + radius, bounds.top + radius);
                    canvas.drawArc(rectF, 180.0f, 90.0f, true, paint);
                    canvas.translate(innerWidth, 0.0f);
                    canvas.rotate(90.0f);
                    canvas.drawArc(rectF, 180.0f, 90.0f, true, paint);
                    canvas.translate(innerHeight, 0.0f);
                    canvas.rotate(90.0f);
                    canvas.drawArc(rectF, 180.0f, 90.0f, true, paint);
                    canvas.translate(innerWidth, 0.0f);
                    canvas.rotate(90.0f);
                    canvas.drawArc(rectF, 180.0f, 90.0f, true, paint);
                    canvas.restoreToCount(saved);
                    canvas.drawRect(bounds.left + radius - 1.0f, bounds.top, bounds.right - radius + 1.0f, bounds.top + radius, paint);
                    canvas.drawRect(bounds.left + radius - 1.0f, bounds.bottom - radius + 1.0f, bounds.right - radius + 1.0f, bounds.bottom, paint);
                }
                canvas.drawRect(bounds.left, bounds.top + Math.max(0.0f, radius - 1.0f), bounds.right, bounds.bottom - radius + 1.0f, paint);
            }
        };
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.leftTopRect) {
            canvas.drawRect(this.buildLeftTopRect(), this.mPaint);
        }
        if (this.rightTopRect) {
            canvas.drawRect(this.buildRightTopRect(), this.mPaint);
        }
        if (this.rightBottomRect) {
            canvas.drawRect(this.buildRightBottomRect(), this.mPaint);
        }
        if (this.leftBottomRect) {
            canvas.drawRect(this.buildLeftBottomRect(), this.mPaint);
        }
    }

    @Override
    protected void drawShadow(Canvas canvas) {
        float top = -this.mCornerRadius - this.mShadowSize;
        float inset = this.mCornerRadius + (float)this.mInsetShadow + this.mRawShadowSize / 2.0f;
        boolean suggestHorizontal = this.mCardBounds.width() - inset * 2.0f > 0.0f;
        boolean suggestVertical = this.mCardBounds.height() - inset * 2.0f > 0.0f;
        this.drawLeftTopShadow(canvas, inset);
        this.drawRightTopShadow(canvas, inset);
        this.drawRightBottomShadow(canvas, inset);
        this.drawLeftBottomShadow(canvas, inset);
        this.drawLeftEdgeShadow(canvas, top, inset, suggestVertical);
        this.drawTopEdgeShadow(canvas, top, inset, suggestHorizontal);
        this.drawRightEdgeShadow(canvas, top, inset, suggestVertical);
        this.drawBottomEdgeShadow(canvas, top, inset, suggestHorizontal);
    }

    @Override
    protected void buildComponents(Rect bounds) {
        float vOffset = this.mRawMaxShadowSize * 1.5f;
        float left = this.leftEdgeShadow ? (float)bounds.left + this.mRawMaxShadowSize : (float)bounds.left;
        float top = this.topEdgeShadow ? (float)bounds.top + vOffset : (float)bounds.top;
        float right = this.rightEdgeShadow ? (float)bounds.right - this.mRawMaxShadowSize : (float)bounds.right;
        float bottom = this.bottomEdgeShadow ? (float)bounds.bottom - vOffset : (float)bounds.bottom;
        this.mCardBounds.set(left, top, right, bottom);
        this.buildShadowCorners();
    }

    private RectF buildLeftTopRect() {
        RectF rectF = new RectF();
        rectF.left = this.mCardBounds.left;
        rectF.top = this.mCardBounds.top;
        rectF.right = this.mCardBounds.left + this.mCornerRadius * 2.0f;
        rectF.bottom = this.mCardBounds.top + this.mCornerRadius * 2.0f;
        return rectF;
    }

    private RectF buildRightTopRect() {
        RectF rectF = new RectF();
        rectF.left = this.mCardBounds.right - this.mCornerRadius * 2.0f;
        rectF.top = this.mCardBounds.top;
        rectF.right = this.mCardBounds.right;
        rectF.bottom = this.mCardBounds.top + this.mCornerRadius * 2.0f;
        return rectF;
    }

    private RectF buildRightBottomRect() {
        RectF rectF = new RectF();
        rectF.left = this.mCardBounds.right - this.mCornerRadius * 2.0f;
        rectF.top = this.mCardBounds.bottom - this.mCornerRadius * 2.0f;
        rectF.right = this.mCardBounds.right;
        rectF.bottom = this.mCardBounds.bottom;
        return rectF;
    }

    private RectF buildLeftBottomRect() {
        RectF rectF = new RectF();
        rectF.left = this.mCardBounds.left;
        rectF.top = this.mCardBounds.bottom - this.mCornerRadius * 2.0f;
        rectF.right = this.mCardBounds.left + this.mCornerRadius * 2.0f;
        rectF.bottom = this.mCardBounds.bottom;
        return rectF;
    }

    private void drawLeftTopShadow(Canvas canvas, float inset) {
        if (!this.leftTopRect) {
            int saved = canvas.save();
            canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.top + inset);
            canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
            canvas.restoreToCount(saved);
        }
    }

    private void drawRightTopShadow(Canvas canvas, float inset) {
        if (!this.rightTopRect) {
            int saved = canvas.save();
            canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.top + inset);
            canvas.rotate(90.0f);
            canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
            canvas.restoreToCount(saved);
        }
    }

    private void drawRightBottomShadow(Canvas canvas, float inset) {
        if (!this.rightBottomRect) {
            int saved = canvas.save();
            canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.bottom - inset);
            canvas.rotate(180.0f);
            canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
            canvas.restoreToCount(saved);
        }
    }

    private void drawLeftBottomShadow(Canvas canvas, float inset) {
        if (!this.leftBottomRect) {
            int saved = canvas.save();
            canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.bottom - inset);
            canvas.rotate(270.0f);
            canvas.drawPath(this.mCornerShadowPath, this.mCornerShadowPaint);
            canvas.restoreToCount(saved);
        }
    }

    private void drawLeftEdgeShadow(Canvas canvas, float top, float inset, boolean suggest) {
        if (suggest && this.leftEdgeShadow) {
            int saved = canvas.save();
            canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.bottom - inset);
            canvas.rotate(270.0f);
            canvas.drawRect(0.0f, top, this.mCardBounds.height() - inset * 2.0f, -this.mCornerRadius, this.mEdgeShadowPaint);
            canvas.restoreToCount(saved);
            if (this.leftTopRect) {
                saved = canvas.save();
                canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.top + inset);
                canvas.rotate(270.0f);
                canvas.drawRect(0.0f, top, inset, -this.mCornerRadius, this.mEdgeShadowPaint);
                canvas.restoreToCount(saved);
            }
            if (this.leftBottomRect) {
                saved = canvas.save();
                canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.bottom);
                canvas.rotate(270.0f);
                canvas.drawRect(0.0f, top, inset, -this.mCornerRadius, this.mEdgeShadowPaint);
                canvas.restoreToCount(saved);
            }
        }
    }

    private void drawTopEdgeShadow(Canvas canvas, float top, float inset, boolean suggest) {
        if (suggest && this.topEdgeShadow) {
            int saved = canvas.save();
            canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.top + inset);
            canvas.drawRect(0.0f, top, this.mCardBounds.width() - inset * 2.0f, -this.mCornerRadius, this.mEdgeShadowPaint);
            canvas.restoreToCount(saved);
            if (this.leftTopRect) {
                saved = canvas.save();
                canvas.translate(this.mCardBounds.left, this.mCardBounds.top + inset);
                canvas.drawRect(0.0f, top, inset, -this.mCornerRadius, this.mEdgeShadowPaint);
                canvas.restoreToCount(saved);
            }
            if (this.rightTopRect) {
                saved = canvas.save();
                canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.top + inset);
                canvas.drawRect(0.0f, top, inset, -this.mCornerRadius, this.mEdgeShadowPaint);
                canvas.restoreToCount(saved);
            }
        }
    }

    private void drawRightEdgeShadow(Canvas canvas, float top, float inset, boolean suggest) {
        if (suggest && this.rightEdgeShadow) {
            int saved = canvas.save();
            canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.top + inset);
            canvas.rotate(90.0f);
            canvas.drawRect(0.0f, top, this.mCardBounds.height() - inset * 2.0f, -this.mCornerRadius, this.mEdgeShadowPaint);
            canvas.restoreToCount(saved);
            if (this.rightTopRect) {
                saved = canvas.save();
                canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.top);
                canvas.rotate(90.0f);
                canvas.drawRect(0.0f, top, inset, -this.mCornerRadius, this.mEdgeShadowPaint);
                canvas.restoreToCount(saved);
            }
            if (this.rightBottomRect) {
                saved = canvas.save();
                canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.bottom - inset);
                canvas.rotate(90.0f);
                canvas.drawRect(0.0f, top, inset, -this.mCornerRadius, this.mEdgeShadowPaint);
                canvas.restoreToCount(saved);
            }
        }
    }

    private void drawBottomEdgeShadow(Canvas canvas, float top, float inset, boolean suggest) {
        if (suggest && this.bottomEdgeShadow) {
            int saved = canvas.save();
            canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.bottom - inset);
            canvas.rotate(180.0f);
            canvas.drawRect(0.0f, top, this.mCardBounds.width() - inset * 2.0f, -this.mCornerRadius + this.mShadowSize, this.mEdgeShadowPaint);
            canvas.restoreToCount(saved);
            if (this.leftBottomRect) {
                saved = canvas.save();
                canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.bottom - inset);
                canvas.rotate(180.0f);
                canvas.drawRect(0.0f, top, inset, -this.mCornerRadius + this.mShadowSize, this.mEdgeShadowPaint);
                canvas.restoreToCount(saved);
            }
            if (this.rightBottomRect) {
                saved = canvas.save();
                canvas.translate(this.mCardBounds.right, this.mCardBounds.bottom - inset);
                canvas.rotate(180.0f);
                canvas.drawRect(0.0f, top, inset, -this.mCornerRadius + this.mShadowSize, this.mEdgeShadowPaint);
                canvas.restoreToCount(saved);
            }
        }
    }

    public void setRadius(float radius) {
        super.setCornerRadius(radius);
    }

    @Override
    public void setShadowSize(float size) {
        super.setShadowSize(size, this.mRawMaxShadowSize);
    }

    @Override
    public void setColor(int color2) {
        super.setColor(color2);
    }

    public void showCorner(boolean leftTop, boolean rightTop, boolean leftBottom, boolean rightBottom) {
        this.leftTopRect = !leftTop;
        this.rightTopRect = !rightTop;
        this.leftBottomRect = !leftBottom;
        this.rightBottomRect = !rightBottom;
        this.invalidateSelf();
    }

    public void showLeftTopRect(boolean show) {
        this.leftTopRect = show;
        this.invalidateSelf();
    }

    public void showRightTopRect(boolean show) {
        this.rightTopRect = show;
        this.invalidateSelf();
    }

    public void showRightBottomRect(boolean show) {
        this.rightBottomRect = show;
        this.invalidateSelf();
    }

    public void showLeftBottomRect(boolean show) {
        this.leftBottomRect = show;
        this.invalidateSelf();
    }

    public void showEdgeShadow(boolean left, boolean top, boolean right, boolean bottom) {
        this.leftEdgeShadow = left;
        this.topEdgeShadow = top;
        this.rightEdgeShadow = right;
        this.bottomEdgeShadow = bottom;
        this.invalidateSelf();
    }

    public void showLeftEdgeShadow(boolean show) {
        this.leftEdgeShadow = show;
        this.invalidateSelf();
    }

    public void showTopEdgeShadow(boolean show) {
        this.topEdgeShadow = show;
        this.invalidateSelf();
    }

    public void showRightEdgeShadow(boolean show) {
        this.rightEdgeShadow = show;
        this.invalidateSelf();
    }

    public void showBottomEdgeShadow(boolean show) {
        this.bottomEdgeShadow = show;
        this.invalidateSelf();
    }
}

