/*
 * Decompiled with CFR 0.152.
 */
package com.github.captain_miao.optroundcardview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.github.captain_miao.optroundcardview.CardViewApi21;
import com.github.captain_miao.optroundcardview.CardViewDelegate;
import com.github.captain_miao.optroundcardview.CardViewEclairMr1;
import com.github.captain_miao.optroundcardview.CardViewImpl;
import com.github.captain_miao.optroundcardview.CardViewJellybeanMr1;
import com.github.captain_miao.optroundcardview.OptRoundRectDrawable;
import com.github.captain_miao.optroundcardview.OptRoundRectDrawableWithShadow;
import com.github.captain_miao.optroundcardview.R;

public class OptRoundCardView
extends FrameLayout
implements CardViewDelegate {
    private static final CardViewImpl IMPL = Build.VERSION.SDK_INT >= 21 ? new CardViewApi21() : (Build.VERSION.SDK_INT >= 17 ? new CardViewJellybeanMr1() : new CardViewEclairMr1());
    private boolean mCompatPadding;
    private boolean mPreventCornerOverlap;
    private final Rect mContentPadding = new Rect();
    private final Rect mShadowBounds = new Rect();
    private static final boolean SDK_LOLLIPOP;

    public OptRoundCardView(Context context) {
        super(context);
        this.initialize(context, null, 0);
    }

    public OptRoundCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0);
    }

    public OptRoundCardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    public void setPadding(int left, int top, int right, int bottom) {
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
    }

    @Override
    public boolean getUseCompatPadding() {
        return this.mCompatPadding;
    }

    public void setUseCompatPadding(boolean useCompatPadding) {
        if (this.mCompatPadding == useCompatPadding) {
            return;
        }
        this.mCompatPadding = useCompatPadding;
        IMPL.onCompatPaddingChanged(this);
    }

    public void setContentPadding(int left, int top, int right, int bottom) {
        this.mContentPadding.set(left, top, right, bottom);
        IMPL.updatePadding(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!(IMPL instanceof CardViewApi21)) {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            switch (widthMode) {
                case -2147483648: 
                case 0x40000000: {
                    int minWidth = (int)Math.ceil(IMPL.getMinWidth(this));
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(minWidth, View.MeasureSpec.getSize((int)widthMeasureSpec)), (int)widthMode);
                }
            }
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            switch (heightMode) {
                case -2147483648: 
                case 0x40000000: {
                    int minHeight = (int)Math.ceil(IMPL.getMinHeight(this));
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(minHeight, View.MeasureSpec.getSize((int)heightMeasureSpec)), (int)heightMode);
                }
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OptRoundCardView, defStyleAttr, R.style.OptRoundCardView_Light);
        int backgroundColor = a.getColor(R.styleable.OptRoundCardView_optRoundCardBackgroundColor, 0);
        float radius = a.getDimension(R.styleable.OptRoundCardView_optRoundCardCornerRadius, 0.0f);
        float elevation = a.getDimension(R.styleable.OptRoundCardView_optRoundCardElevation, 0.0f);
        float maxElevation = a.getDimension(R.styleable.OptRoundCardView_optRoundCardMaxElevation, 0.0f);
        this.mCompatPadding = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardUseCompatPadding, false);
        this.mPreventCornerOverlap = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardPreventCornerOverlap, true);
        int defaultPadding = a.getDimensionPixelSize(R.styleable.OptRoundCardView_optRoundContentPadding, 0);
        this.mContentPadding.left = a.getDimensionPixelSize(R.styleable.OptRoundCardView_optRoundContentPaddingLeft, defaultPadding);
        this.mContentPadding.top = a.getDimensionPixelSize(R.styleable.OptRoundCardView_optRoundContentPaddingTop, defaultPadding);
        this.mContentPadding.right = a.getDimensionPixelSize(R.styleable.OptRoundCardView_optRoundContentPaddingRight, defaultPadding);
        this.mContentPadding.bottom = a.getDimensionPixelSize(R.styleable.OptRoundCardView_optRoundContentPaddingBottom, defaultPadding);
        if (elevation > maxElevation) {
            maxElevation = elevation;
        }
        int cornerFlag = 0;
        boolean flag = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardLeftTopCorner, true);
        cornerFlag += flag ? 1 : 0;
        flag = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardRightTopCorner, true);
        cornerFlag += flag ? 2 : 0;
        flag = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardLeftBottomCorner, true);
        cornerFlag += flag ? 4 : 0;
        flag = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardRightBottomCorner, true);
        cornerFlag += flag ? 8 : 0;
        int edgesFlag = 0;
        flag = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardLeftEdges, true);
        edgesFlag += flag ? 1 : 0;
        flag = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardTopEdges, true);
        edgesFlag += flag ? 2 : 0;
        flag = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardRightEdges, true);
        edgesFlag += flag ? 4 : 0;
        flag = a.getBoolean(R.styleable.OptRoundCardView_optRoundCardBottomEdges, true);
        int n = flag ? 8 : 0;
        a.recycle();
        IMPL.initialize(this, context, backgroundColor, radius, elevation, maxElevation, cornerFlag, edgesFlag += n);
    }

    public void setCardBackgroundColor(int color2) {
        IMPL.setBackgroundColor(this, color2);
    }

    public int getContentPaddingLeft() {
        return this.mContentPadding.left;
    }

    public int getContentPaddingRight() {
        return this.mContentPadding.right;
    }

    public int getContentPaddingTop() {
        return this.mContentPadding.top;
    }

    public int getContentPaddingBottom() {
        return this.mContentPadding.bottom;
    }

    public void setRadius(float radius) {
        IMPL.setRadius(this, radius);
    }

    @Override
    public float getRadius() {
        return IMPL.getRadius(this);
    }

    @Override
    public void setShadowPadding(int left, int top, int right, int bottom) {
        this.mShadowBounds.set(left, top, right, bottom);
        super.setPadding(left + this.mContentPadding.left, top + this.mContentPadding.top, right + this.mContentPadding.right, bottom + this.mContentPadding.bottom);
    }

    public void setCardElevation(float elevation) {
        IMPL.setElevation(this, elevation);
    }

    public float getCardElevation() {
        return IMPL.getElevation(this);
    }

    public void setMaxCardElevation(float maxElevation) {
        IMPL.setMaxElevation(this, maxElevation);
    }

    public float getMaxCardElevation() {
        return IMPL.getMaxElevation(this);
    }

    @Override
    public boolean getPreventCornerOverlap() {
        return this.mPreventCornerOverlap;
    }

    public void setPreventCornerOverlap(boolean preventCornerOverlap) {
        if (preventCornerOverlap == this.mPreventCornerOverlap) {
            return;
        }
        this.mPreventCornerOverlap = preventCornerOverlap;
        IMPL.onPreventCornerOverlapChanged(this);
    }

    public void showCorner(boolean leftTop, boolean rightTop, boolean leftBottom, boolean rightBottom) {
        if (SDK_LOLLIPOP) {
            ((OptRoundRectDrawable)this.getBackground()).showCorner(leftTop, rightTop, leftBottom, rightBottom);
        } else {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showCorner(leftTop, rightTop, leftBottom, rightBottom);
        }
    }

    public void showLeftTopCorner(boolean show) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showLeftTopRect(!show);
        }
    }

    public void showRightTopCorner(boolean show) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showRightTopRect(!show);
        }
    }

    public void showLeftBottomCorner(boolean show) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showLeftBottomRect(!show);
        }
    }

    public void showRightBottomCorner(boolean show) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showRightBottomRect(!show);
        }
    }

    public void showEdgeShadow(boolean left, boolean top, boolean right, boolean bottom) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showEdgeShadow(left, top, right, bottom);
        }
    }

    public void showLeftEdgeShadow(boolean show) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showLeftEdgeShadow(show);
        }
    }

    public void showTopEdgeShadow(boolean show) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showTopEdgeShadow(show);
        }
    }

    public void showRightEdgeShadow(boolean show) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showRightEdgeShadow(show);
        }
    }

    public void showBottomEdgeShadow(boolean show) {
        if (!SDK_LOLLIPOP) {
            ((OptRoundRectDrawableWithShadow)this.getBackground()).showBottomEdgeShadow(show);
        }
    }

    static {
        IMPL.initStatic();
        SDK_LOLLIPOP = Build.VERSION.SDK_INT >= 21;
    }
}

