/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import sun.awt.ConstrainableGraphics;

public class WindowClippedGraphics
extends Graphics2D
implements ConstrainableGraphics {
    private Graphics2D wrapped;
    private Shape baseClip;
    private Shape userClip;

    public WindowClippedGraphics(Graphics2D w, Shape c) {
        this.wrapped = w;
        this.baseClip = c;
        this.userClip = null;
        this.wrapped.setClip(this.baseClip);
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        if (this.userClip == null) {
            this.userClip = new Rectangle(x, y, w, h);
        } else if (this.userClip instanceof Rectangle) {
            Rectangle c = (Rectangle)this.userClip;
            Rectangle2D.intersect(c, new Rectangle(x, y, w, h), c);
        } else {
            Area a = this.userClip instanceof Area ? (Area)this.userClip : new Area(this.userClip);
            a.intersect(new Area(new Rectangle(x, y, w, h)));
            this.userClip = a;
        }
        this.wrapped.clipRect(x, y, w, h);
    }

    @Override
    public void clip(Shape s) {
        if (this.userClip == null) {
            this.userClip = s;
        } else if (this.userClip instanceof Rectangle && s instanceof Rectangle) {
            Rectangle c1 = (Rectangle)this.userClip;
            Rectangle c2 = (Rectangle)s;
            Rectangle2D.intersect(c1, c2, c1);
        } else {
            Area a = this.userClip instanceof Area ? (Area)this.userClip : new Area(this.userClip);
            a.intersect(new Area(s));
            this.userClip = a;
        }
        this.wrapped.clip(s);
    }

    @Override
    public Shape getClip() {
        return this.userClip;
    }

    @Override
    public Rectangle getClipBounds() {
        Rectangle clipBounds = this.userClip == null ? null : this.userClip.getBounds();
        return clipBounds;
    }

    @Override
    public Rectangle getClipBounds(Rectangle b) {
        if (b == null) {
            return this.userClip.getBounds();
        }
        b.setBounds(this.userClip.getBounds());
        return b;
    }

    @Override
    public Rectangle getClipRect() {
        return this.userClip.getBounds();
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setClip(Shape clip) {
        Shape realClip;
        this.userClip = clip;
        if (clip == null) {
            realClip = this.baseClip;
        } else {
            Area a = this.baseClip instanceof Area ? (Area)this.baseClip : new Area(this.baseClip);
            Area b = new Area(clip);
            b.intersect(a);
            realClip = b;
        }
        this.wrapped.setClip(realClip);
    }

    private Shape transformShape(Shape s, AffineTransform t) {
        Area r;
        if (s == null) {
            r = null;
        } else {
            Area a = s instanceof Area ? (Area)s : new Area(s);
            r = a.createTransformedArea(t);
        }
        return r;
    }

    @Override
    public void rotate(double theta) {
        block2: {
            AffineTransform t = AffineTransform.getRotateInstance(theta);
            try {
                AffineTransform i = t.createInverse();
                this.baseClip = this.transformShape(this.baseClip, i);
                this.userClip = this.transformShape(this.userClip, i);
            }
            catch (NoninvertibleTransformException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.wrapped.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        block2: {
            AffineTransform t = AffineTransform.getRotateInstance(theta, x, y);
            try {
                AffineTransform i = t.createInverse();
                this.baseClip = this.transformShape(this.baseClip, i);
                this.userClip = this.transformShape(this.userClip, i);
            }
            catch (NoninvertibleTransformException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.wrapped.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        block2: {
            AffineTransform t = AffineTransform.getScaleInstance(sx, sy);
            try {
                AffineTransform i = t.createInverse();
                this.baseClip = this.transformShape(this.baseClip, i);
                this.userClip = this.transformShape(this.userClip, i);
            }
            catch (NoninvertibleTransformException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.wrapped.scale(sx, sy);
    }

    @Override
    public void setTransform(AffineTransform tx) {
        block2: {
            AffineTransform t = this.getTransform();
            this.baseClip = this.transformShape(this.baseClip, t);
            this.userClip = this.transformShape(this.userClip, t);
            try {
                AffineTransform i = tx.createInverse();
                this.baseClip = this.transformShape(this.baseClip, i);
                this.userClip = this.transformShape(this.userClip, i);
            }
            catch (NoninvertibleTransformException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.wrapped.setTransform(tx);
    }

    @Override
    public void shear(double shx, double shy) {
        block2: {
            AffineTransform t = AffineTransform.getShearInstance(shx, shy);
            try {
                AffineTransform i = t.createInverse();
                this.baseClip = this.transformShape(this.baseClip, i);
                this.userClip = this.transformShape(this.userClip, i);
            }
            catch (NoninvertibleTransformException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.wrapped.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform tx) {
        block2: {
            try {
                AffineTransform i = tx.createInverse();
                this.baseClip = this.transformShape(this.baseClip, i);
                this.userClip = this.transformShape(this.userClip, i);
            }
            catch (NoninvertibleTransformException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.wrapped.transform(tx);
    }

    @Override
    public void translate(int x, int y) {
        AffineTransform t = AffineTransform.getTranslateInstance(-x, -y);
        if (this.userClip != null && this.userClip instanceof Rectangle) {
            Rectangle r = (Rectangle)this.userClip;
            r.x -= x;
            r.y -= y;
        } else {
            this.userClip = this.transformShape(this.userClip, t);
        }
        this.baseClip = this.transformShape(this.baseClip, t);
        this.wrapped.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        block2: {
            AffineTransform t = AffineTransform.getTranslateInstance(tx, ty);
            try {
                AffineTransform i = t.createInverse();
                this.baseClip = this.transformShape(this.baseClip, i);
                this.userClip = this.transformShape(this.userClip, i);
            }
            catch (NoninvertibleTransformException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.wrapped.translate(tx, ty);
    }

    @Override
    public Graphics create() {
        Graphics2D wrappedClone = (Graphics2D)this.wrapped.create();
        WindowClippedGraphics g = new WindowClippedGraphics(wrappedClone, this.baseClip);
        g.userClip = this.userClip;
        return g;
    }

    @Override
    public Graphics create(int x, int y, int w, int h) {
        Graphics g = super.create(x, y, w, h);
        if (g instanceof Graphics2D && this.baseClip != null) {
            AffineTransform t = AffineTransform.getTranslateInstance(-x, -y);
            Shape s = this.transformShape(this.baseClip, t);
            return new WindowClippedGraphics((Graphics2D)g, s);
        }
        return g;
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.wrapped.addRenderingHints(hints);
    }

    @Override
    public void draw(Shape s) {
        this.wrapped.draw(s);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.wrapped.drawGlyphVector(g, x, y);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.wrapped.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.wrapped.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.wrapped.drawRenderableImage(img, xform);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.wrapped.drawRenderedImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.wrapped.drawString(str, x, y);
    }

    @Override
    public void drawChars(char[] c, int o, int l, int x, int y) {
        this.wrapped.drawChars(c, o, l, x, y);
    }

    @Override
    public void drawBytes(byte[] b, int o, int l, int x, int y) {
        this.wrapped.drawBytes(b, o, l, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.wrapped.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.wrapped.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.wrapped.drawString(iterator, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.wrapped.fill(s);
    }

    @Override
    public Color getBackground() {
        return this.wrapped.getBackground();
    }

    @Override
    public Composite getComposite() {
        return this.wrapped.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.wrapped.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.wrapped.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.wrapped.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.wrapped.getRenderingHint(hintKey);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.wrapped.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.wrapped.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        return this.wrapped.getTransform();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.wrapped.hit(rect, s, onStroke);
    }

    @Override
    public boolean hitClip(int x, int y, int w, int h) {
        return this.wrapped.hitClip(x, y, w, h);
    }

    @Override
    public void setBackground(Color color) {
        this.wrapped.setBackground(color);
    }

    @Override
    public void setComposite(Composite comp) {
        this.wrapped.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.wrapped.setPaint(paint);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.wrapped.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.wrapped.setRenderingHints(hints);
    }

    @Override
    public void setStroke(Stroke s) {
        this.wrapped.setStroke(s);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.wrapped.clearRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.wrapped.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void dispose() {
        this.wrapped.dispose();
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.wrapped.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.wrapped.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.wrapped.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.wrapped.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.wrapped.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.wrapped.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.wrapped.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.wrapped.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.wrapped.drawOval(x, y, width, height);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.wrapped.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.wrapped.drawPolygon(p);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.wrapped.fillPolygon(p);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.wrapped.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.wrapped.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.wrapped.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.wrapped.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.wrapped.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.wrapped.fillRect(x, y, width, height);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.wrapped.drawRect(x, y, width, height);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean r) {
        this.wrapped.draw3DRect(x, y, width, height, r);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean r) {
        this.wrapped.fill3DRect(x, y, width, height, r);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.wrapped.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public Color getColor() {
        return this.wrapped.getColor();
    }

    @Override
    public Font getFont() {
        return this.wrapped.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.wrapped.getFontMetrics(f);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.wrapped.getFontMetrics();
    }

    @Override
    public void setColor(Color c) {
        this.wrapped.setColor(c);
    }

    @Override
    public void setFont(Font font) {
        this.wrapped.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.wrapped.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.wrapped.setXORMode(c1);
    }

    @Override
    public void constrain(int x, int y, int w, int h) {
        AffineTransform t;
        if (this.wrapped instanceof ConstrainableGraphics) {
            t = AffineTransform.getTranslateInstance(-x, -y);
            if (this.userClip != null && this.userClip instanceof Rectangle) {
                Rectangle r = (Rectangle)this.userClip;
                r.x -= x;
                r.y -= y;
            } else {
                this.userClip = this.transformShape(this.userClip, t);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.baseClip = this.transformShape(this.baseClip, t);
        Area newBase = new Area(this.baseClip);
        newBase.intersect(new Area(new Rectangle(0, 0, w, h)));
        this.baseClip = newBase;
        ConstrainableGraphics cg = (ConstrainableGraphics)((Object)this.wrapped);
        cg.constrain(x, y, w, h);
    }
}

