/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public class ProxyWindow
extends Window {
    private CacioComponentPeer target;
    private static Field dispatcherField;
    private static Method dispatchMethod;

    ProxyWindow(CacioComponentPeer t, JComponent c) {
        super((Frame)null);
        this.target = t;
        this.add(c);
    }

    CacioComponentPeer getTargetPeer() {
        return this.target;
    }

    void handleFocusEvent(FocusEvent e) {
        this.processFocusEvent(e);
    }

    void handleKeyEvent(KeyEvent e) {
        this.processKeyEvent(e);
    }

    void handleMouseEvent(MouseEvent e) {
        MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        this.doLightweightDispatching(e);
    }

    void handleMouseMotionEvent(MouseEvent e) {
        MouseEvent me = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        this.doLightweightDispatching(e);
    }

    private static void initReflection() {
        try {
            dispatcherField = Container.class.getDeclaredField("dispatcher");
            dispatcherField.setAccessible(true);
            Class<?> dispatcherCls = Class.forName("java.awt.LightweightDispatcher");
            dispatchMethod = dispatcherCls.getDeclaredMethod("dispatchEvent", AWTEvent.class);
            dispatchMethod.setAccessible(true);
        }
        catch (Exception ex) {
            InternalError err = new InternalError();
            err.initCause(ex);
            throw err;
        }
    }

    private void doLightweightDispatching(AWTEvent e) {
        if (dispatcherField == null) {
            ProxyWindow.initReflection();
        }
        try {
            Object dispatcher = dispatcherField.get(this);
            if (dispatcher != null) {
                dispatchMethod.invoke(dispatcher, e);
            }
        }
        catch (Exception ex) {
            InternalError err = new InternalError();
            err.initCause(ex);
            throw err;
        }
    }

    @Override
    public boolean isShowing() {
        return ((Component)this.target.getAWTComponent()).isShowing();
    }
}

