/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import java.awt.Dimension;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextFieldPeer;
import javax.swing.JPasswordField;

class CacioTextFieldPeer
extends CacioComponentPeer<TextField, JPasswordField>
implements TextFieldPeer {
    CacioTextFieldPeer(TextField awtC, PlatformWindowFactory pwf) {
        super(awtC, pwf);
    }

    @Override
    JPasswordField initSwingComponent() {
        TextField textField = (TextField)this.getAWTComponent();
        JPasswordField swingComponent = new JPasswordField();
        swingComponent.setText(textField.getText());
        swingComponent.setColumns(textField.getColumns());
        swingComponent.setEchoChar(textField.getEchoChar());
        swingComponent.setEditable(textField.isEditable());
        swingComponent.select(textField.getSelectionStart(), textField.getSelectionEnd());
        swingComponent.addActionListener(new SwingTextFieldListener());
        return swingComponent;
    }

    @Override
    public Dimension getMinimumSize(int columns) {
        return ((JPasswordField)this.getSwingComponent()).getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize(int columns) {
        return ((JPasswordField)this.getSwingComponent()).getPreferredSize();
    }

    @Override
    public void setEchoChar(char echoChar) {
        ((JPasswordField)this.getSwingComponent()).setEchoChar(echoChar);
    }

    @Override
    public int getCaretPosition() {
        return ((JPasswordField)this.getSwingComponent()).getCaretPosition();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return ((JPasswordField)this.getSwingComponent()).getInputMethodRequests();
    }

    @Override
    public int getSelectionEnd() {
        return ((JPasswordField)this.getSwingComponent()).getSelectionEnd();
    }

    @Override
    public int getSelectionStart() {
        return ((JPasswordField)this.getSwingComponent()).getSelectionStart();
    }

    @Override
    public String getText() {
        return ((JPasswordField)this.getSwingComponent()).getText();
    }

    @Override
    public void select(int selStart, int selEnd) {
        ((JPasswordField)this.getSwingComponent()).select(selStart, selEnd);
    }

    @Override
    public void setCaretPosition(int pos) {
        ((JPasswordField)this.getSwingComponent()).setCaretPosition(pos);
    }

    @Override
    public void setEditable(boolean editable) {
        ((JPasswordField)this.getSwingComponent()).setEditable(editable);
    }

    @Override
    public void setText(String l) {
        ((JPasswordField)this.getSwingComponent()).setText(l);
    }

    class SwingTextFieldListener
    implements ActionListener {
        SwingTextFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TextField textField = (TextField)CacioTextFieldPeer.this.getAWTComponent();
            ActionListener[] listeners = textField.getActionListeners();
            if (listeners.length == 0) {
                return;
            }
            ActionEvent ev = new ActionEvent(textField, 1001, event.getActionCommand());
            for (ActionListener listener : listeners) {
                listener.actionPerformed(ev);
            }
        }
    }
}

