/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.CacioMenuComponentPeer;
import com.github.caciocavallosilano.cacio.peer.CacioMenuPeer;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuPeer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

class CacioMenuBarPeer
extends CacioMenuComponentPeer<MenuBar, JMenuBar>
implements MenuBarPeer {
    private Menu helpMenu;

    CacioMenuBarPeer(MenuBar mb) {
        super(mb, new JMenuBar());
    }

    @Override
    void postInitSwingComponent() {
        MenuBar mb = (MenuBar)this.getAWTMenu();
        int menuCount = mb.getMenuCount();
        for (int i = 0; i < menuCount; ++i) {
            Menu m = mb.getMenu(i);
            this.addMenu(mb.getMenu(i));
        }
        Menu helpMenu = mb.getHelpMenu();
        if (helpMenu != null) {
            this.addHelpMenu(helpMenu);
        }
    }

    @Override
    public void addMenu(Menu m) {
        JMenuBar jmb = (JMenuBar)this.getSwingMenu();
        if (this.helpMenu != null) {
            jmb.add((Component)this.getSwingMenu(m), jmb.getComponentCount() - 1);
        } else {
            jmb.add(this.getSwingMenu(m));
        }
        jmb.revalidate();
    }

    @Override
    public void addHelpMenu(Menu m) {
        JMenuBar jmb = (JMenuBar)this.getSwingMenu();
        if (this.helpMenu != null) {
            jmb.remove(this.getSwingMenu(this.helpMenu));
        }
        this.helpMenu = m;
        jmb.add(this.getSwingMenu(m));
        jmb.revalidate();
    }

    private JMenu getSwingMenu(Menu m) {
        MenuPeer mp = (MenuPeer)CacioComponentPeer.getPeer(m);
        if (mp == null) {
            m.addNotify();
            mp = (MenuPeer)CacioComponentPeer.getPeer(m);
        }
        assert (mp instanceof CacioMenuPeer);
        return (JMenu)((CacioMenuPeer)mp).getSwingMenu();
    }

    @Override
    public void delMenu(int index) {
        ((JMenuBar)this.getSwingMenu()).remove(index);
    }
}

