/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.peer.KeyboardFocusManagerPeer;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

class CacioKeyboardFocusManagerPeer
implements KeyboardFocusManagerPeer {
    private static CacioKeyboardFocusManagerPeer instance;
    private Window currentFocusedWindow;
    private Component currentFocusOwner;

    static CacioKeyboardFocusManagerPeer getInstance() {
        if (instance == null) {
            instance = new CacioKeyboardFocusManagerPeer();
        }
        return instance;
    }

    private CacioKeyboardFocusManagerPeer() {
    }

    @Override
    public Window getCurrentFocusedWindow() {
        return this.currentFocusedWindow;
    }

    @Override
    public void setCurrentFocusOwner(Component comp) {
        this.currentFocusOwner = comp;
    }

    @Override
    public Component getCurrentFocusOwner() {
        return this.currentFocusOwner;
    }

    @Override
    public void clearGlobalFocusOwner(Window activeWindow) {
    }

    @Override
    public void setCurrentFocusedWindow(Window win) {
        this.currentFocusedWindow = win;
    }

    boolean requestFocus(Component target, Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, FocusEvent.Cause cause) {
        Component currentOwner;
        if (lightweightChild == null) {
            lightweightChild = target;
        }
        if ((currentOwner = this.getCurrentFocusOwner()) != null && CacioComponentPeer.getPeer(currentOwner) == null) {
            currentOwner = null;
        }
        FocusEvent fg = new FocusEvent(lightweightChild, 1004, false, currentOwner, cause);
        FocusEvent fl = null;
        if (currentOwner != null) {
            fl = new FocusEvent(currentOwner, 1005, false, lightweightChild, cause);
        }
        if (fl != null) {
            this.postEvent(fl);
        }
        this.postEvent(fg);
        return true;
    }

    private void postEvent(AWTEvent ev) {
        SunToolkit.postEvent(AppContext.getAppContext(), ev);
    }
}

