/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary;

import android.util.Log;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.HandlerThreadFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class LogWriter {
    private static final String TAG = "LogWriter";
    private static final Object SAVE_DELETE_LOCK = new Object();
    private static final SimpleDateFormat FILE_NAME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.US);
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    private static final long OBSOLETE_DURATION = 172800000L;

    private LogWriter() {
        throw new InstantiationError("Must not instantiate this class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String save(String str) {
        String path;
        Object object = SAVE_DELETE_LOCK;
        synchronized (object) {
            path = LogWriter.save("looper", str);
        }
        return path;
    }

    public static void cleanObsolete() {
        HandlerThreadFactory.getWriteLogThreadHandler().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long now = System.currentTimeMillis();
                File[] f = BlockCanaryInternals.getLogFiles();
                if (f != null && f.length > 0) {
                    Object object = SAVE_DELETE_LOCK;
                    synchronized (object) {
                        for (File aF : f) {
                            if (now - aF.lastModified() <= 172800000L) continue;
                            aF.delete();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAll() {
        Object object = SAVE_DELETE_LOCK;
        synchronized (object) {
            try {
                File[] files = BlockCanaryInternals.getLogFiles();
                if (files != null && files.length > 0) {
                    for (File file : files) {
                        file.delete();
                    }
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)"deleteAll: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String save(String logFileName, String str) {
        String path = "";
        BufferedWriter writer = null;
        try {
            File file = BlockCanaryInternals.detectedBlockDirectory();
            long time = System.currentTimeMillis();
            path = file.getAbsolutePath() + "/" + logFileName + "-" + FILE_NAME_FORMATTER.format(time) + ".log";
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path, true), "UTF-8");
            writer = new BufferedWriter(out);
            writer.write("\r\n");
            writer.write("**********************");
            writer.write("\r\n");
            writer.write(TIME_FORMATTER.format(time) + "(write log time)");
            writer.write("\r\n");
            writer.write("\r\n");
            writer.write(str);
            writer.write("\r\n");
            writer.flush();
            writer.close();
            writer = null;
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"save: ", (Throwable)t);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"save: ", (Throwable)e);
            }
        }
        return path;
    }

    public static File generateTempZip(String filename) {
        return new File(BlockCanaryInternals.getPath() + "/" + filename + ".zip");
    }
}

