/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.github.moduth.blockcanary.AbstractSampler;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.internal.BlockInfo;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class CpuSampler
extends AbstractSampler {
    private static final String TAG = "CpuSampler";
    private static final int BUFFER_SIZE = 1000;
    private final int BUSY_TIME;
    private static final int MAX_ENTRY_COUNT = BlockCanaryInternals.getContext().reportRecentOneMessage() ? 1 : 10;
    private final LinkedHashMap<Long, String> mCpuInfoEntries = new LinkedHashMap();
    private int mPid = 0;
    private long mUserLast = 0L;
    private long mSystemLast = 0L;
    private long mIdleLast = 0L;
    private long mIoWaitLast = 0L;
    private long mTotalLast = 0L;
    private long mAppCpuTimeLast = 0L;
    private boolean mAboveAndroidO = false;

    public CpuSampler(long sampleInterval) {
        super(sampleInterval);
        this.BUSY_TIME = (int)((float)this.mSampleInterval * 1.2f);
        if (Build.VERSION.SDK_INT >= 26) {
            this.mAboveAndroidO = true;
        }
    }

    @Override
    public void start() {
        super.start();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCpuRateInfo() {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<Long, String> linkedHashMap = this.mCpuInfoEntries;
        synchronized (linkedHashMap) {
            for (Map.Entry<Long, String> entry : this.mCpuInfoEntries.entrySet()) {
                long time = entry.getKey();
                sb.append(BlockInfo.TIME_FORMATTER.format(time)).append(' ').append(entry.getValue()).append("\r\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCpuBusy(long start, long end) {
        if (end - start > this.mSampleInterval) {
            long s = start - this.mSampleInterval;
            long e = start + this.mSampleInterval;
            long last = 0L;
            LinkedHashMap<Long, String> linkedHashMap = this.mCpuInfoEntries;
            synchronized (linkedHashMap) {
                for (Map.Entry<Long, String> entry : this.mCpuInfoEntries.entrySet()) {
                    long time = entry.getKey();
                    if (s >= time || time >= e) continue;
                    if (last != 0L && time - last > (long)this.BUSY_TIME) {
                        return true;
                    }
                    last = time;
                }
            }
        }
        return false;
    }

    @Override
    protected void doSample() {
        if (this.mAboveAndroidO) {
            this.getCPUDataForO();
        } else {
            this.getCPUData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getCPUDataForO() {
        Process process = null;
        try {
            String line;
            process = Runtime.getRuntime().exec("top -n 1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int cpuIndex = -1;
            while ((line = reader.readLine()) != null) {
                String[] param;
                if (TextUtils.isEmpty((CharSequence)(line = line.trim()))) continue;
                int tempIndex = this.getCPUIndex(line);
                if (tempIndex != -1) {
                    cpuIndex = tempIndex;
                    continue;
                }
                if (!line.startsWith(String.valueOf(android.os.Process.myPid())) || cpuIndex == -1 || (param = line.split("\\s+")).length <= cpuIndex) continue;
                String cpu = param[cpuIndex];
                if (cpu.endsWith("%")) {
                    cpu = cpu.substring(0, cpu.lastIndexOf("%"));
                }
                float rate = Float.parseFloat(cpu) / (float)Runtime.getRuntime().availableProcessors();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(cpu).append("% ");
                LinkedHashMap<Long, String> linkedHashMap = this.mCpuInfoEntries;
                synchronized (linkedHashMap) {
                    Iterator<Map.Entry<Long, String>> iterator;
                    this.mCpuInfoEntries.put(System.currentTimeMillis(), stringBuilder.toString());
                    if (this.mCpuInfoEntries.size() > MAX_ENTRY_COUNT && (iterator = this.mCpuInfoEntries.entrySet().iterator()).hasNext()) {
                        Map.Entry<Long, String> entry = iterator.next();
                        Long key = entry.getKey();
                        this.mCpuInfoEntries.remove(key);
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private int getCPUIndex(String line) {
        if (line.contains("CPU")) {
            String[] titles = line.split("\\s+");
            for (int i = 0; i < titles.length; ++i) {
                if (!titles[i].contains("CPU")) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCPUData() {
        BufferedReader cpuReader = null;
        BufferedReader pidReader = null;
        try {
            String pidCpuRate;
            cpuReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            String cpuRate = cpuReader.readLine();
            if (cpuRate == null) {
                cpuRate = "";
            }
            if (this.mPid == 0) {
                this.mPid = android.os.Process.myPid();
            }
            if ((pidCpuRate = (pidReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + this.mPid + "/stat")), 1000)).readLine()) == null) {
                pidCpuRate = "";
            }
            this.parse(cpuRate, pidCpuRate);
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)"doSample: ", (Throwable)throwable);
        }
        finally {
            try {
                if (cpuReader != null) {
                    cpuReader.close();
                }
                if (pidReader != null) {
                    pidReader.close();
                }
            }
            catch (IOException exception) {
                Log.e((String)TAG, (String)"doSample: ", (Throwable)exception);
            }
        }
    }

    private void reset() {
        this.mUserLast = 0L;
        this.mSystemLast = 0L;
        this.mIdleLast = 0L;
        this.mIoWaitLast = 0L;
        this.mTotalLast = 0L;
        this.mAppCpuTimeLast = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String cpuRate, String pidCpuRate) {
        String[] cpuInfoArray = cpuRate.split(" ");
        if (cpuInfoArray.length < 9) {
            return;
        }
        long user = Long.parseLong(cpuInfoArray[2]);
        long nice = Long.parseLong(cpuInfoArray[3]);
        long system = Long.parseLong(cpuInfoArray[4]);
        long idle = Long.parseLong(cpuInfoArray[5]);
        long ioWait = Long.parseLong(cpuInfoArray[6]);
        long total = user + nice + system + idle + ioWait + Long.parseLong(cpuInfoArray[7]) + Long.parseLong(cpuInfoArray[8]);
        String[] pidCpuInfoList = pidCpuRate.split(" ");
        if (pidCpuInfoList.length < 17) {
            return;
        }
        long appCpuTime = Long.parseLong(pidCpuInfoList[13]) + Long.parseLong(pidCpuInfoList[14]) + Long.parseLong(pidCpuInfoList[15]) + Long.parseLong(pidCpuInfoList[16]);
        if (this.mTotalLast != 0L) {
            StringBuilder stringBuilder = new StringBuilder();
            long idleTime = idle - this.mIdleLast;
            long totalTime = total - this.mTotalLast;
            stringBuilder.append((totalTime - idleTime) * 100L / totalTime).append("% ").append((appCpuTime - this.mAppCpuTimeLast) * 100L / totalTime).append("% ").append((user - this.mUserLast) * 100L / totalTime).append("% ").append((system - this.mSystemLast) * 100L / totalTime).append("% ").append((ioWait - this.mIoWaitLast) * 100L / totalTime).append("% ");
            LinkedHashMap<Long, String> linkedHashMap = this.mCpuInfoEntries;
            synchronized (linkedHashMap) {
                Iterator<Map.Entry<Long, String>> iterator;
                this.mCpuInfoEntries.put(System.currentTimeMillis(), stringBuilder.toString());
                if (this.mCpuInfoEntries.size() > MAX_ENTRY_COUNT && (iterator = this.mCpuInfoEntries.entrySet().iterator()).hasNext()) {
                    Map.Entry<Long, String> entry = iterator.next();
                    Long key = entry.getKey();
                    this.mCpuInfoEntries.remove(key);
                }
            }
        }
        this.mUserLast = user;
        this.mSystemLast = system;
        this.mIdleLast = idle;
        this.mIoWaitLast = ioWait;
        this.mTotalLast = total;
        this.mAppCpuTimeLast = appCpuTime;
    }
}

