/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.util;

import android.util.Log;
import com.tiktok.TikTokBusinessSdk;

public class TTLogger {
    public final TikTokBusinessSdk.LogLevel logLevel;
    private final String tag;

    public TTLogger(String tag, TikTokBusinessSdk.LogLevel logLevel) {
        this.tag = tag;
        this.logLevel = logLevel;
    }

    private String resolvedStr(String format, Object ... extra) {
        if (format == null) {
            return "null";
        }
        return extra.length == 0 ? format : String.format(format, extra);
    }

    public void info(String format, Object ... extra) {
        if (this.shouldLog(TikTokBusinessSdk.LogLevel.INFO)) {
            String str = this.resolvedStr(format, extra);
            if (str.length() > 1000) {
                Log.i((String)this.tag, (String)str.substring(0, 1000));
                this.info(str.substring(1000), new Object[0]);
            } else {
                Log.i((String)this.tag, (String)str);
            }
        }
    }

    public void warn(String format, Object ... extra) {
        if (this.shouldLog(TikTokBusinessSdk.LogLevel.WARN)) {
            Log.w((String)this.tag, (String)this.resolvedStr(format, extra));
        }
    }

    public void debug(String format, Object ... extra) {
        if (this.shouldLog(TikTokBusinessSdk.LogLevel.DEBUG)) {
            String str = this.resolvedStr(format, extra);
            if (str.length() > 1000) {
                Log.d((String)this.tag, (String)str.substring(0, 1000));
                this.debug(str.substring(1000), new Object[0]);
            } else {
                Log.d((String)this.tag, (String)str);
            }
        }
    }

    public void error(Throwable error, String format, Object ... extra) {
        if (this.shouldLog(TikTokBusinessSdk.LogLevel.INFO)) {
            Log.e((String)this.tag, (String)this.resolvedStr(format, extra), (Throwable)error);
        }
    }

    private boolean shouldLog(TikTokBusinessSdk.LogLevel level) {
        return this.logLevel.ordinal() >= level.ordinal();
    }
}

