/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTAppEvent;
import com.tiktok.appevents.TTAppEventLogger;
import com.tiktok.appevents.TTAppEventsQueue;
import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.appevents.TTRequestBuilder;
import com.tiktok.util.HttpRequestUtil;
import com.tiktok.util.SystemInfoUtil;
import com.tiktok.util.TTConst;
import com.tiktok.util.TTLogger;
import com.tiktok.util.TTUtil;
import com.tiktok.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TTRequest {
    private static final String TAG = TTRequest.class.getCanonicalName();
    private static final TTLogger logger = new TTLogger(TAG, TikTokBusinessSdk.getLogLevel());
    private static final int MAX_EVENT_SIZE = 50;
    private static int toBeSentRequests = 0;
    private static int failedRequests = 0;
    private static int successfulRequests = 0;
    private static final TreeSet<Long> allRequestIds = new TreeSet();
    private static final List<TTAppEvent> successfullySentRequests = new ArrayList<TTAppEvent>();
    private static final Map<String, String> headParamMap = new HashMap<String, String>();
    private static final Map<String, String> getHeadParamMap = new HashMap<String, String>();

    TTRequest() {
    }

    public static JSONObject getBusinessSDKConfig(Map<String, Object> options) {
        long initTimeMS = System.currentTimeMillis();
        logger.info("Try to fetch global configs", new Object[0]);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("app_id", TikTokBusinessSdk.getAppId());
        paramsMap.put("client", "android");
        paramsMap.put("sdk_version", SystemInfoUtil.getSDKVersion());
        paramsMap.put("app_version", SystemInfoUtil.getAppVersionName());
        paramsMap.put("tiktok_app_id", TikTokBusinessSdk.getTTAppId());
        paramsMap.putAll(options);
        String url = "https://business-api.tiktok.com/open_api/business_sdk_config/get/?" + TTUtil.mapToString(paramsMap, "&");
        logger.debug(url, new Object[0]);
        String result = HttpRequestUtil.doGet(url, getHeadParamMap);
        logger.debug(result, new Object[0]);
        JSONObject config = null;
        if (result != null) {
            try {
                JSONObject resultJson = new JSONObject(result);
                Integer code = (Integer)resultJson.get("code");
                if (code == 0) {
                    config = (JSONObject)resultJson.get("data");
                }
                logger.info("Global config fetched: " + TTUtil.ppStr(config), new Object[0]);
            }
            catch (Exception e) {
                TTCrashHandler.handleCrash(TAG, e);
            }
        }
        try {
            long endTimeMS = System.currentTimeMillis();
            JSONObject meta = TTUtil.getMetaWithTS(initTimeMS).put("latency", endTimeMS - initTimeMS).put("success", config != null).put("log_id", (Object)HttpRequestUtil.getLogIDFromApi(result));
            TikTokBusinessSdk.getAppEventLogger().monitorMetric("config_api", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return config;
    }

    public static synchronized List<TTAppEvent> getSuccessfullySentRequests() {
        return successfullySentRequests;
    }

    public static synchronized List<TTAppEvent> reportAppEvent(JSONObject basePayload, List<TTAppEvent> appEventList) {
        int discardedEventCount;
        TTUtil.checkThread(TAG);
        if (appEventList == null || appEventList.size() == 0) {
            return new ArrayList<TTAppEvent>();
        }
        toBeSentRequests = appEventList.size();
        for (TTAppEvent event : appEventList) {
            allRequestIds.add(event.getUniqueId());
        }
        failedRequests = 0;
        successfulRequests = 0;
        TTRequest.notifyChange();
        String url = "https://" + TikTokBusinessSdk.getApiTrackDomain() + "/open_api/" + TikTokBusinessSdk.getApiAvailableVersion() + "/app/batch/";
        ArrayList<TTAppEvent> failedEventsToBeSaved = new ArrayList<TTAppEvent>();
        ArrayList<TTAppEvent> failedEventsToBeDiscarded = new ArrayList<TTAppEvent>();
        List<List<TTAppEvent>> chunks = TTRequest.averageAssign(appEventList, 50);
        for (List<TTAppEvent> currentBatch : chunks) {
            ArrayList<JSONObject> batch = new ArrayList<JSONObject>();
            for (TTAppEvent event : currentBatch) {
                JSONObject propertiesJson = TTRequest.transferJson(event);
                if (propertiesJson == null) continue;
                batch.add(propertiesJson);
            }
            JSONObject bodyJson = basePayload;
            try {
                bodyJson.put("batch", (Object)new JSONArray(batch));
            }
            catch (Exception e) {
                failedEventsToBeSaved.addAll(currentBatch);
                TTCrashHandler.handleCrash(TAG, e);
                continue;
            }
            try {
                String bodyStr = bodyJson.toString(4);
                logger.debug("To Api:\n" + bodyStr, new Object[0]);
            }
            catch (JSONException bodyStr) {
                // empty catch block
            }
            String result = HttpRequestUtil.doPost(url, headParamMap, bodyJson.toString());
            if (result == null) {
                failedEventsToBeSaved.addAll(currentBatch);
                failedRequests += currentBatch.size();
            } else {
                block24: {
                    try {
                        JSONObject resultJson = new JSONObject(result);
                        int code = resultJson.getInt("code");
                        if (TikTokBusinessSdk.isInSdkDebugMode().booleanValue() || code == TTConst.ApiErrorCodes.API_ERROR.code) {
                            failedEventsToBeDiscarded.addAll(currentBatch);
                            failedRequests += currentBatch.size();
                            break block24;
                        }
                        if (code == TTConst.ApiErrorCodes.PARTIAL_SUCCESS.code) {
                            try {
                                JSONArray partialFailedEvents = resultJson.getJSONObject("data").getJSONArray("failed_events");
                                int length = partialFailedEvents.length();
                                HashSet<Integer> failedIndices = new HashSet<Integer>();
                                for (int i = 0; i < length; ++i) {
                                    JSONObject errorObj = partialFailedEvents.getJSONObject(i);
                                    failedIndices.add(errorObj.getInt("order_in_batch"));
                                }
                                int totalSize = currentBatch.size();
                                for (int i = 0; i < totalSize; ++i) {
                                    TTAppEvent curr = currentBatch.get(i);
                                    if (failedIndices.contains(i)) {
                                        failedEventsToBeDiscarded.add(curr);
                                        ++failedRequests;
                                        continue;
                                    }
                                    successfullySentRequests.add(curr);
                                    ++successfulRequests;
                                }
                                break block24;
                            }
                            catch (Exception e) {
                                TTCrashHandler.handleCrash(TAG, e);
                                failedEventsToBeSaved.addAll(currentBatch);
                                failedRequests += currentBatch.size();
                                break block24;
                            }
                        }
                        if (code != 0) {
                            failedEventsToBeSaved.addAll(currentBatch);
                            failedRequests += currentBatch.size();
                        } else {
                            successfulRequests += currentBatch.size();
                            successfullySentRequests.addAll(currentBatch);
                        }
                    }
                    catch (JSONException e) {
                        failedRequests += currentBatch.size();
                        failedEventsToBeSaved.addAll(currentBatch);
                        TTCrashHandler.handleCrash(TAG, e);
                    }
                }
                logger.debug(TTUtil.ppStr(result), new Object[0]);
            }
            TTRequest.notifyChange();
        }
        logger.debug("Flushed %d events successfully", successfulRequests);
        if (failedEventsToBeSaved.size() != 0) {
            logger.debug("Failed to flush %d events, will save them to disk", failedEventsToBeSaved.size());
        }
        if ((discardedEventCount = failedEventsToBeDiscarded.size()) != 0) {
            logger.debug("Failed to flush " + discardedEventCount + " events, will discard them", new Object[0]);
            TTAppEventLogger.totalDumped += discardedEventCount;
            if (TikTokBusinessSdk.diskListener != null) {
                TikTokBusinessSdk.diskListener.onDumped(TTAppEventLogger.totalDumped);
            }
        }
        logger.debug("Failed to flush %d events in total", failedRequests);
        toBeSentRequests = 0;
        failedRequests = 0;
        successfulRequests = 0;
        TTRequest.notifyChange();
        return failedEventsToBeSaved;
    }

    private static void notifyChange() {
        if (TikTokBusinessSdk.networkListener != null) {
            TikTokBusinessSdk.networkListener.onNetworkChange(toBeSentRequests, successfulRequests, failedRequests, allRequestIds.size() + TTAppEventsQueue.size(), successfullySentRequests.size());
        }
    }

    private static JSONObject transferJson(TTAppEvent event) {
        if (event == null) {
            return null;
        }
        try {
            JSONObject properties;
            JSONObject propertiesJson = new JSONObject();
            propertiesJson.put("type", (Object)event.getType());
            if (event.getEventName() != null) {
                propertiesJson.put("event", (Object)event.getEventName());
            }
            propertiesJson.put("timestamp", (Object)TimeUtil.getISO8601Timestamp(event.getTimeStamp()));
            if (TikTokBusinessSdk.isInSdkLDUMode().booleanValue()) {
                propertiesJson.put("limited_data_use", true);
            }
            if ((properties = new JSONObject(event.getPropertiesJson())).length() != 0) {
                propertiesJson.put("properties", (Object)properties);
            }
            propertiesJson.put("context", (Object)TTRequestBuilder.getContextForApi(event));
            return propertiesJson;
        }
        catch (JSONException e) {
            TTCrashHandler.handleCrash(TAG, e);
            return null;
        }
    }

    public static <T> List<List<T>> averageAssign(List<T> sourceList, int splitNum) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int size = sourceList.size();
        int times = size % splitNum == 0 ? size / splitNum : size / splitNum + 1;
        for (int i = 0; i < times; ++i) {
            int start = i * splitNum;
            int end = i * splitNum + splitNum;
            result.add(new ArrayList<T>(sourceList.subList(start, Math.min(size, end))));
        }
        return result;
    }

    public static String reportMonitorEvent(JSONObject stat) {
        String url = "https://" + TikTokBusinessSdk.getApiTrackDomain() + "/open_api/" + TikTokBusinessSdk.getApiAvailableVersion() + "/app/monitor/";
        return HttpRequestUtil.doPost(url, headParamMap, stat.toString());
    }

    static {
        headParamMap.put("Content-Type", "application/json");
        headParamMap.put("Connection", "Keep-Alive");
        String ua = String.format("tiktok-business-android-sdk/%s/%s", "1.2.10", TikTokBusinessSdk.getApiAvailableVersion());
        headParamMap.put("User-Agent", ua);
        getHeadParamMap.put("Connection", "Keep-Alive");
        getHeadParamMap.put("User-Agent", ua);
    }
}

