/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.util.TTLogger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class TTIdentifierFactory {
    private static final String TAG = TTIdentifierFactory.class.getCanonicalName();
    private static final TTLogger logger = new TTLogger(TAG, TikTokBusinessSdk.getLogLevel());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdIdInfo getGoogleAdIdInfo(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            logger.info("Google play service not installed", new Object[0]);
        }
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        AdIdConnection serviceConnection = new AdIdConnection();
        try {
            if (context.bindService(intent, (ServiceConnection)serviceConnection, 1)) {
                AdIdInterface adIdInterface = new AdIdInterface(serviceConnection.getBinder());
                String adId = adIdInterface.getAdId();
                boolean isAdTrackingEnabled = adIdInterface.isAdIdTrackingEnabled();
                if (TextUtils.isEmpty((CharSequence)adId)) {
                    AdIdInfo adIdInfo = new AdIdInfo("", isAdTrackingEnabled);
                    return adIdInfo;
                }
                AdIdInfo adIdInfo = new AdIdInfo(adId, isAdTrackingEnabled);
                return adIdInfo;
            }
            logger.info("Failed to detect google play identifier service on this phone", new Object[0]);
            AdIdInfo adIdInterface = new AdIdInfo("", true);
            return adIdInterface;
        }
        catch (Exception e) {
            logger.error(e, "remote exception", new Object[0]);
        }
        finally {
            context.unbindService((ServiceConnection)serviceConnection);
        }
        return new AdIdInfo("", true);
    }

    private static class AdIdInterface
    implements IInterface {
        private static final String INTERFACE_TOKEN = "com.google.android.gms.ads.identifier.internal.IAdvertisingIdService";
        private static final int AD_ID_TRANSACTION_CODE = 1;
        private static final int AD_TRACKING_TRANSACTION_CODE = 2;
        private final IBinder mIBinder;

        private AdIdInterface(IBinder binder) {
            this.mIBinder = binder;
        }

        public IBinder asBinder() {
            return this.mIBinder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getAdId() throws RemoteException {
            String adId;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken(INTERFACE_TOKEN);
                this.mIBinder.transact(1, data, reply, 0);
                reply.readException();
                adId = reply.readString();
            }
            finally {
                data.recycle();
                reply.recycle();
            }
            return adId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isAdIdTrackingEnabled() throws RemoteException {
            boolean limitedTrackingEnabled;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken(INTERFACE_TOKEN);
                data.writeInt(1);
                this.mIBinder.transact(2, data, reply, 0);
                reply.readException();
                limitedTrackingEnabled = 0 != reply.readInt();
            }
            finally {
                data.recycle();
                reply.recycle();
            }
            return limitedTrackingEnabled;
        }
    }

    private static class AdIdConnection
    implements ServiceConnection {
        private final BlockingQueue<IBinder> queue = new ArrayBlockingQueue<IBinder>(1);

        private AdIdConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) throws IllegalStateException {
            try {
                this.queue.put(iBinder);
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException("Exception trying to parse GMS connection");
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        public IBinder getBinder() throws IllegalStateException {
            try {
                return this.queue.take();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Exception trying to retrieve GMS connection");
            }
        }
    }

    public static class AdIdInfo {
        private final String adId;
        private final boolean isAdTrackingEnabled;

        private AdIdInfo(String adId, boolean isAdTrackingEnabled) {
            this.adId = adId;
            this.isAdTrackingEnabled = isAdTrackingEnabled;
        }

        public String getAdId() {
            return this.adId;
        }

        public boolean isAdTrackingEnabled() {
            return this.isAdTrackingEnabled;
        }
    }
}

