/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import android.app.Application;
import androidx.annotation.NonNull;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTRequest;
import com.tiktok.appevents.TTRequestBuilder;
import com.tiktok.util.HttpRequestUtil;
import com.tiktok.util.TTLogger;
import com.tiktok.util.TTUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class TTCrashHandler {
    private static final String TAG = TTCrashHandler.class.getCanonicalName();
    private static final TTLogger ttLogger = new TTLogger(TAG, TikTokBusinessSdk.getLogLevel());
    private static final String CRASH_REPORT_FILE = "tt_crash_log";
    private static final int MONITOR_RETRY_LIMIT = 2;
    private static final int MONITOR_BATCH_MAX = 5;
    static TTCrashReport crashReport = new TTCrashReport();

    public static void handleCrash(String originTag, Throwable ex) {
        ttLogger.error(ex, "Error caused by sdk at " + originTag + "\n" + ex.getMessage() + "\n" + TTCrashHandler.getStackTrace(ex), new Object[0]);
        TTCrashHandler.persistException(ex);
    }

    public static void retryLater(JSONObject monitor) {
        crashReport.addReport(monitor.toString(), System.currentTimeMillis(), 0);
        if (TTCrashHandler.crashReport.reports.size() >= 5) {
            TTCrashHandler.initCrashReporter();
        }
    }

    public static void persistToFile() {
        for (TTCrashReport.Monitor m : TTCrashHandler.crashReport.reports) {
            ttLogger.info("persistToFile %s", m.monitor);
        }
        TTCrashHandler.saveToFile(crashReport);
        crashReport = new TTCrashReport();
    }

    public static void initCrashReporter() {
        TTCrashReport fileReport = TTCrashHandler.readFromFile();
        if (fileReport != null) {
            TTCrashHandler.crashReport.reports.addAll(fileReport.reports);
            try {
                Application context = TikTokBusinessSdk.getApplicationContext();
                File f = new File(context.getFilesDir(), CRASH_REPORT_FILE);
                if (f.exists()) {
                    f.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        crashReport = TTCrashHandler.reportMonitor(crashReport);
        TTCrashHandler.saveToFile(crashReport);
        crashReport = new TTCrashReport();
    }

    private static TTCrashReport reportMonitor(@NonNull TTCrashReport cr) {
        if (cr.reports.size() == 0) {
            return cr;
        }
        TTCrashReport ttCrashReport = new TTCrashReport();
        for (int i = 0; i < cr.reports.size(); i += 5) {
            int j = i + 5;
            if (j > cr.reports.size()) {
                j = cr.reports.size();
            }
            List<TTCrashReport.Monitor> batch = cr.reports.subList(i, j);
            ArrayList<JSONObject> batchReq = new ArrayList<JSONObject>();
            for (TTCrashReport.Monitor m : batch) {
                try {
                    batchReq.add(new JSONObject(m.monitor));
                }
                catch (Exception exception) {}
            }
            JSONObject req = TTRequestBuilder.getBasePayload();
            try {
                req.put("batch", (Object)new JSONArray(batchReq));
            }
            catch (Exception m) {
                // empty catch block
            }
            String resp = TTRequest.reportMonitorEvent(req);
            if (HttpRequestUtil.getCodeFromApi(resp) == 0) continue;
            for (TTCrashReport.Monitor o : batch) {
                ttCrashReport.addReport(o.monitor, System.currentTimeMillis(), o.attempt + 1);
            }
        }
        return ttCrashReport;
    }

    private static void persistException(Throwable ex) {
        block4: {
            JSONObject stat = null;
            try {
                stat = TTRequestBuilder.getHealthMonitorBase();
                JSONObject monitor = TTUtil.getMonitorException(ex, null);
                stat.put("monitor", (Object)monitor);
                crashReport.addReport(stat.toString(), System.currentTimeMillis(), 0);
                TTCrashHandler.saveToFile(crashReport);
                crashReport = new TTCrashReport();
            }
            catch (Exception e) {
                if (stat == null) break block4;
                ArrayList<JSONObject> batchReq = new ArrayList<JSONObject>();
                batchReq.add(stat);
                JSONObject req = TTRequestBuilder.getBasePayload();
                try {
                    req.put("batch", (Object)new JSONArray(batchReq));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TTRequest.reportMonitorEvent(req);
            }
        }
    }

    private static void saveToFile(TTCrashReport cr) {
        try {
            Application context = TikTokBusinessSdk.getApplicationContext();
            FileOutputStream fos = context.openFileOutput(CRASH_REPORT_FILE, 0);
            ObjectOutputStream os = new ObjectOutputStream(fos);
            os.writeObject(cr);
            os.close();
            fos.close();
        }
        catch (Exception e) {
            TTCrashHandler.reportMonitor(cr);
        }
    }

    private static TTCrashReport readFromFile() {
        TTCrashReport meta = new TTCrashReport();
        Application context = TikTokBusinessSdk.getApplicationContext();
        try {
            FileInputStream fis = context.openFileInput(CRASH_REPORT_FILE);
            ObjectInputStream is = new ObjectInputStream(fis);
            meta = (TTCrashReport)is.readObject();
            is.close();
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return meta;
    }

    private static String getStackTrace(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        for (StackTraceElement curr : t.getStackTrace()) {
            buffer.append(curr.toString()).append("\n");
        }
        return buffer.toString();
    }

    public static boolean isTTSDKRelatedException(Throwable e) {
        if (e == null) {
            return false;
        }
        Throwable prev = null;
        for (Throwable t = e; t != null && t != prev; t = t.getCause()) {
            if (TTCrashHandler.isTTSDKRelatedException(t.getStackTrace())) {
                return true;
            }
            prev = t;
        }
        return false;
    }

    public static boolean isTTSDKRelatedException(StackTraceElement[] elts) {
        if (elts == null) {
            return false;
        }
        for (StackTraceElement element : elts) {
            if (!element.getClassName().startsWith("com.tiktok")) continue;
            return true;
        }
        return false;
    }

    static class TTCrashReport
    implements Serializable {
        List<Monitor> reports = new ArrayList<Monitor>();

        TTCrashReport() {
        }

        public void addReport(String o, long t, int a) {
            if (a < 2) {
                this.reports.add(new Monitor(o, t, a));
            }
        }

        static class Monitor
        implements Serializable {
            public final String monitor;
            public long ts;
            public int attempt;

            public Monitor(String o, long t, int a) {
                this.monitor = o;
                this.ts = t;
                this.attempt = a;
            }
        }
    }
}

