/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import android.content.Context;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTAppEventLogger;
import com.tiktok.util.TTConst;
import com.tiktok.util.TTKeyValueStore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

class TTAutoEventsManager {
    private static final String TAG = TTAutoEventsManager.class.getCanonicalName();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.getDefault());
    private final TTAppEventLogger appEventLogger;
    private final TTKeyValueStore store;

    public TTAutoEventsManager(TTAppEventLogger appEventLogger) {
        this.appEventLogger = appEventLogger;
        this.store = new TTKeyValueStore((Context)TikTokBusinessSdk.getApplicationContext());
    }

    Boolean shouldTrackAppLifecycleEvents(TTConst.AutoEvents event) {
        return this.appEventLogger.lifecycleTrackEnable && !this.appEventLogger.disabledEvents.contains((Object)event);
    }

    public void trackOnAppOpenEvents() {
        this.trackFirstInstallEvent();
        this.track2DayRetentionEvent();
        this.trackLaunchEvent();
    }

    private void trackFirstInstallEvent() {
        String installTime = this.store.get("com.tiktok.sdk.firstInstall");
        if (installTime != null) {
            return;
        }
        Date now = new Date();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("com.tiktok.sdk.firstInstall", timeFormat.format(now));
        if (this.shouldTrackAppLifecycleEvents(TTConst.AutoEvents.InstallApp).booleanValue()) {
            this.appEventLogger.track(TTConst.AutoEvents.InstallApp.name, null);
        }
        this.store.set(hm);
    }

    void track2DayRetentionEvent() {
        String is2DayLogged = this.store.get("com.tiktok.sdk.2drTime");
        if (is2DayLogged != null) {
            return;
        }
        String firstInstall = this.store.get("com.tiktok.sdk.firstInstall");
        if (firstInstall == null) {
            return;
        }
        try {
            Date firstLaunchTime = timeFormat.parse(firstInstall);
            Date now = new Date();
            if (this.shouldTrackAppLifecycleEvents(TTConst.AutoEvents.SecondDayRetention).booleanValue() && this.isSatisfyRetention(firstLaunchTime, now)) {
                this.appEventLogger.track(TTConst.AutoEvents.SecondDayRetention.name, null);
                this.store.set("com.tiktok.sdk.2drTime", timeFormat.format(now));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void trackLaunchEvent() {
        if (this.shouldTrackAppLifecycleEvents(TTConst.AutoEvents.LaunchAPP).booleanValue()) {
            this.appEventLogger.track(TTConst.AutoEvents.LaunchAPP.name, null);
            this.store.set("com.tiktok.sdk.lastLaunch", timeFormat.format(new Date()));
        }
    }

    private boolean isSatisfyRetention(Date firstLaunch, Date now) {
        Calendar c = Calendar.getInstance();
        c.setTime(firstLaunch);
        c.add(5, 1);
        String nextDayFromFirst = dateFormat.format(c.getTime());
        String todayDate = dateFormat.format(now);
        return nextDayFromFirst.equals(todayDate);
    }
}

