/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTAppEvent;
import com.tiktok.util.TTUtil;
import java.util.ArrayList;
import java.util.List;

class TTAppEventsQueue {
    private static String TAG = TTAppEventsQueue.class.getCanonicalName();
    private static List<TTAppEvent> memory = new ArrayList<TTAppEvent>();

    private TTAppEventsQueue() {
    }

    private static void notifyChange() {
        if (TikTokBusinessSdk.memoryListener != null) {
            TikTokBusinessSdk.memoryListener.onMemoryChange(memory.size());
        }
        if (TikTokBusinessSdk.nextTimeFlushListener != null) {
            int left = 100 - TTAppEventsQueue.size();
            TikTokBusinessSdk.nextTimeFlushListener.thresholdLeft(100, Math.max(left, 0));
        }
    }

    public static synchronized void addEvent(TTAppEvent event) {
        TTUtil.checkThread(TAG);
        memory.add(event);
        TTAppEventsQueue.notifyChange();
    }

    public static synchronized int size() {
        return memory.size();
    }

    public static synchronized void clearAll() {
        TTUtil.checkThread(TAG);
        memory = new ArrayList<TTAppEvent>();
        TTAppEventsQueue.notifyChange();
    }

    public static synchronized List<TTAppEvent> exportAllEvents() {
        List<TTAppEvent> appEvents = memory;
        memory = new ArrayList<TTAppEvent>();
        TTAppEventsQueue.notifyChange();
        return appEvents;
    }
}

