/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import android.app.Application;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTAppEvent;
import com.tiktok.appevents.TTAppEventLogger;
import com.tiktok.appevents.TTAppEventPersist;
import com.tiktok.appevents.TTAppEventsQueue;
import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.util.TTLogger;
import com.tiktok.util.TTUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

class TTAppEventStorage {
    private static final String TAG = TTAppEventStorage.class.getCanonicalName();
    private static final TTLogger logger = new TTLogger(TAG, TikTokBusinessSdk.getLogLevel());
    private static final String EVENT_STORAGE_FILE = "events_cache";
    private static final int MAX_PERSIST_EVENTS_NUM = 500;

    TTAppEventStorage() {
    }

    public static synchronized void persist(List<TTAppEvent> failedEvents) {
        TTUtil.checkThread(TAG);
        logger.debug("Tried to persist to disk", new Object[0]);
        if (!TikTokBusinessSdk.isSystemActivated()) {
            logger.debug("Quit persisting to disk because global switch is turned off", new Object[0]);
            return;
        }
        List<TTAppEvent> eventsFromMemory = TTAppEventsQueue.exportAllEvents();
        TTAppEventPersist eventsFromDisk = TTAppEventStorage.readFromDisk();
        if (eventsFromMemory.isEmpty() && eventsFromDisk.isEmpty() && (failedEvents == null || failedEvents.isEmpty())) {
            return;
        }
        TTAppEventPersist toBeSaved = new TTAppEventPersist();
        if (failedEvents != null) {
            toBeSaved.addEvents(failedEvents);
        }
        toBeSaved.addEvents(eventsFromDisk.getAppEvents());
        toBeSaved.addEvents(eventsFromMemory);
        TTAppEventStorage.discardOldEvents(toBeSaved, 500);
        TTAppEventStorage.saveToDisk(toBeSaved);
    }

    private static void discardOldEvents(TTAppEventPersist ttAppEventPersist, int maxPersistNum) {
        if (ttAppEventPersist == null || ttAppEventPersist.isEmpty()) {
            return;
        }
        List<TTAppEvent> appEvents = ttAppEventPersist.getAppEvents();
        int size = appEvents.size();
        if (size > maxPersistNum) {
            logger.debug("Way too many events(%d), slim it!", size);
            TikTokBusinessSdk.diskListener.onDumped(TTAppEventLogger.totalDumped += size - maxPersistNum);
            ttAppEventPersist.setAppEvents(new ArrayList<TTAppEvent>(appEvents.subList(size - maxPersistNum, size)));
        }
    }

    private static boolean saveToDisk(TTAppEventPersist appEventPersist) {
        if (appEventPersist.isEmpty()) {
            return false;
        }
        long initTimeMS = System.currentTimeMillis();
        Application context = TikTokBusinessSdk.getApplicationContext();
        boolean success = false;
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(context.openFileOutput(EVENT_STORAGE_FILE, 0)));){
            oos.writeObject(appEventPersist);
            logger.debug("Saving %d events to disk", appEventPersist.getAppEvents().size());
            if (TikTokBusinessSdk.diskListener != null) {
                TikTokBusinessSdk.diskListener.onDiskChange(appEventPersist.getAppEvents().size(), false);
            }
            success = true;
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
        }
        try {
            long endTimeMS = System.currentTimeMillis();
            JSONObject meta = TTUtil.getMetaWithTS(initTimeMS).put("latency", endTimeMS - initTimeMS).put("success", success).put("size", appEventPersist.getAppEvents().size());
            TikTokBusinessSdk.getAppEventLogger().monitorMetric("file_w", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    private static void deleteFile(File f) {
        if (f.exists()) {
            f.delete();
        }
    }

    static synchronized TTAppEventPersist readFromDisk() {
        long initTimeMS = System.currentTimeMillis();
        TTUtil.checkThread(TAG);
        Application context = TikTokBusinessSdk.getApplicationContext();
        File f = new File(context.getFilesDir(), EVENT_STORAGE_FILE);
        if (!f.exists()) {
            return new TTAppEventPersist();
        }
        TTAppEventPersist appEventPersist = new TTAppEventPersist();
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(context.openFileInput(EVENT_STORAGE_FILE)));){
            appEventPersist = (TTAppEventPersist)ois.readObject();
            logger.debug("disk read data: %s", appEventPersist);
            TTAppEventStorage.deleteFile(f);
            if (TikTokBusinessSdk.diskListener != null) {
                TikTokBusinessSdk.diskListener.onDiskChange(0, true);
            }
        }
        catch (Exception e) {
            TTAppEventStorage.deleteFile(f);
            TTCrashHandler.handleCrash(TAG, e);
        }
        try {
            long endTimeMS = System.currentTimeMillis();
            JSONObject meta = TTUtil.getMetaWithTS(endTimeMS).put("latency", endTimeMS - initTimeMS).put("size", appEventPersist.getAppEvents().size());
            TikTokBusinessSdk.getAppEventLogger().monitorMetric("file_r", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return appEventPersist;
    }

    public static synchronized void clearAll() {
        TTUtil.checkThread(TAG);
        Application context = TikTokBusinessSdk.getApplicationContext();
        File f = new File(context.getFilesDir(), EVENT_STORAGE_FILE);
        TTAppEventStorage.deleteFile(f);
        if (TikTokBusinessSdk.diskListener != null) {
            TikTokBusinessSdk.diskListener.onDiskChange(0, true);
        }
    }
}

