/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTActivityLifecycleCallbacksListener;
import com.tiktok.appevents.TTAppEvent;
import com.tiktok.appevents.TTAppEventPersist;
import com.tiktok.appevents.TTAppEventStorage;
import com.tiktok.appevents.TTAppEventsQueue;
import com.tiktok.appevents.TTAutoEventsManager;
import com.tiktok.appevents.TTCrashHandler;
import com.tiktok.appevents.TTInAppPurchaseManager;
import com.tiktok.appevents.TTPurchaseInfo;
import com.tiktok.appevents.TTRequest;
import com.tiktok.appevents.TTRequestBuilder;
import com.tiktok.appevents.TTThreadFactory;
import com.tiktok.appevents.TTUserInfo;
import com.tiktok.util.SystemInfoUtil;
import com.tiktok.util.TTConst;
import com.tiktok.util.TTLogger;
import com.tiktok.util.TTUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class TTAppEventLogger {
    static final String SKIP_FLUSHING_BECAUSE_GLOBAL_SWITCH_IS_TURNED_OFF = "Skip flushing because global switch is turned off";
    static final String SKIP_FLUSHING_BECAUSE_GLOBAL_CONFIG_IS_NOT_FETCHED = "Skip flushing because global config is not fetched";
    static final String TAG = TTAppEventLogger.class.getName();
    private static int TIME_BUFFER;
    int counter;
    static final int THRESHOLD = 100;
    public static final String NETWORK_IS_TURNED_OFF = "SDK can't send tracking events to server, it will be cached locally, and will be sent in batches only after startTracking";
    static int totalDumped;
    final boolean lifecycleTrackEnable;
    final List<TTConst.AutoEvents> disabledEvents;
    TTLogger logger;
    Lifecycle lifecycle;
    int flushId = 0;
    static ScheduledExecutorService eventLoop;
    ScheduledFuture<?> future = null;
    static ScheduledExecutorService timerService;
    ScheduledFuture<?> timeFuture = null;
    private final Runnable batchFlush = () -> this.flush(FlushReason.TIMER);
    final TTAutoEventsManager autoEventsManager;
    static boolean metricsEnabled;

    public static List<TTAppEvent> getSuccessfulEvents() {
        return TTRequest.getSuccessfullySentRequests();
    }

    public TTAppEventLogger(boolean lifecycleTrackEnable, List<TTConst.AutoEvents> disabledEvents, int flushTime, boolean monitorDisable, long initTimeMS) {
        this.logger = new TTLogger(TAG, TikTokBusinessSdk.getLogLevel());
        this.lifecycleTrackEnable = lifecycleTrackEnable;
        this.disabledEvents = disabledEvents;
        TIME_BUFFER = flushTime;
        this.counter = flushTime;
        this.lifecycle = ProcessLifecycleOwner.get().getLifecycle();
        if (monitorDisable) {
            metricsEnabled = false;
        }
        TTActivityLifecycleCallbacksListener activityLifecycleCallbacks = new TTActivityLifecycleCallbacksListener(this);
        this.lifecycle.addObserver((LifecycleObserver)activityLifecycleCallbacks);
        this.autoEventsManager = new TTAutoEventsManager(this);
        this.addToQ(SystemInfoUtil::initUserAgent);
        this.addToQ(TTAppEventsQueue::clearAll);
        this.addToQ(TTCrashHandler::initCrashReporter);
        this.fetchGlobalConfig(0);
        this.monitorMetric("init_start", TTUtil.getMetaWithTS(initTimeMS), null);
    }

    void persistEvents() {
        this.addToQ(() -> TTAppEventStorage.persist(null));
    }

    public void trackPurchase(List<TTPurchaseInfo> purchaseInfos) {
        if (!TikTokBusinessSdk.isSystemActivated()) {
            this.logger.info("Global switch is off, ignore track purchase", new Object[0]);
            return;
        }
        this.addToQ(() -> {
            if (purchaseInfos.isEmpty()) {
                return;
            }
            for (TTPurchaseInfo purchaseInfo : purchaseInfos) {
                JSONObject property = TTInAppPurchaseManager.getPurchaseProps(purchaseInfo);
                if (property == null) continue;
                this.track("Purchase", property);
            }
        });
    }

    void startScheduler() {
        if (TIME_BUFFER != 0) {
            this.doStartScheduler(TIME_BUFFER, false);
        }
    }

    void restartScheduler() {
        if (TIME_BUFFER != 0) {
            this.doStartScheduler(TIME_BUFFER, true);
        }
    }

    private void doStartScheduler(int interval, boolean immediate) {
        if (this.future == null) {
            this.future = eventLoop.scheduleAtFixedRate(this.batchFlush, immediate ? 0L : (long)interval, interval, TimeUnit.SECONDS);
        }
        if (this.timeFuture == null && TikTokBusinessSdk.nextTimeFlushListener != null) {
            this.counter = interval;
            this.timeFuture = timerService.scheduleAtFixedRate(() -> {
                TikTokBusinessSdk.nextTimeFlushListener.timeLeft(this.counter);
                if (this.counter == 0) {
                    this.counter = interval;
                }
                --this.counter;
            }, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    void stopScheduler() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        if (this.timeFuture != null) {
            this.timeFuture.cancel(false);
            this.timeFuture = null;
        }
    }

    public void identify(String externalId, @Nullable String externalUserName, @Nullable String phoneNumber, @Nullable String email) {
        TTUserInfo sharedInstance = TTUserInfo.sharedInstance;
        if (sharedInstance.isIdentified()) {
            this.logger.warn("SDK is already identified, if you want to switch to anotheruser account, plz call TiktokBusinessSDK.logout() first and then identify", new Object[0]);
            return;
        }
        sharedInstance.setIdentified();
        sharedInstance.setExternalId(externalId);
        sharedInstance.setExternalUserName(externalUserName);
        sharedInstance.setPhoneNumber(phoneNumber);
        sharedInstance.setEmail(email);
        this.trackEvent(TTAppEvent.TTAppEventType.identify, null, null);
        this.flushWithReason(FlushReason.IDENTIFY);
    }

    public void logout() {
        TTUserInfo.reset((Context)TikTokBusinessSdk.getApplicationContext(), true);
        this.flushWithReason(FlushReason.LOGOUT);
    }

    public void track(String event, @Nullable JSONObject props) {
        this.trackEvent(TTAppEvent.TTAppEventType.track, event, props);
    }

    private void trackEvent(TTAppEvent.TTAppEventType type, String event, @Nullable JSONObject props) {
        if (!TikTokBusinessSdk.isSystemActivated()) {
            return;
        }
        JSONObject finalProps = props != null ? props : new JSONObject();
        Runnable task = () -> {
            try {
                this.logger.debug("track " + event + " : " + finalProps.toString(4), new Object[0]);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            TTAppEventsQueue.addEvent(new TTAppEvent(type, event, finalProps.toString()));
            if (TTAppEventsQueue.size() > 100) {
                this.flush(FlushReason.THRESHOLD);
            }
        };
        this.addToQ(task);
    }

    public void forceFlush() {
        this.flushWithReason(FlushReason.FORCE_FLUSH);
    }

    public void flushWithReason(FlushReason reason) {
        this.logger.debug(reason.name() + " triggered flush", new Object[0]);
        this.addToQ(() -> this.flush(reason));
    }

    private void activateSdk() {
        this.autoEventsManager.trackOnAppOpenEvents();
        this.startScheduler();
        this.flush(FlushReason.START_UP);
    }

    void flush(FlushReason reason) {
        long initTimeMS = System.currentTimeMillis();
        TTUtil.checkThread(TAG);
        if (!TikTokBusinessSdk.isGlobalConfigFetched().booleanValue()) {
            this.logger.info(SKIP_FLUSHING_BECAUSE_GLOBAL_CONFIG_IS_NOT_FETCHED, new Object[0]);
            return;
        }
        if (!TikTokBusinessSdk.isSystemActivated()) {
            this.logger.info(SKIP_FLUSHING_BECAUSE_GLOBAL_SWITCH_IS_TURNED_OFF, new Object[0]);
            return;
        }
        int flushSize = 0;
        try {
            if (TikTokBusinessSdk.getNetworkSwitch()) {
                this.logger.debug("Start flush, version %d reason is %s", this.flushId, reason.name());
                TTAppEventPersist appEventPersist = TTAppEventStorage.readFromDisk();
                appEventPersist.addEvents(TTAppEventsQueue.exportAllEvents());
                flushSize = appEventPersist.getAppEvents().size();
                List<TTAppEvent> failedEvents = TTRequest.reportAppEvent(TTRequestBuilder.getBasePayload(), appEventPersist.getAppEvents());
                if (!failedEvents.isEmpty()) {
                    this.logger.debug("Failed to send %d events, will save to disk", failedEvents.size());
                    TTAppEventStorage.persist(failedEvents);
                }
                this.logger.debug("END flush, version %d reason is %s", this.flushId, reason.name());
                ++this.flushId;
            } else {
                this.logger.info(NETWORK_IS_TURNED_OFF, new Object[0]);
                TTAppEventStorage.persist(null);
            }
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
        }
        if (flushSize != 0) {
            try {
                long endTimeMS = System.currentTimeMillis();
                JSONObject meta = TTUtil.getMetaWithTS(initTimeMS).put("latency", endTimeMS - initTimeMS).put("type", (Object)reason.name()).put("interval", TIME_BUFFER).put("size", flushSize);
                this.monitorMetric("flush", meta, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addToQ(TTCrashHandler::initCrashReporter);
    }

    public void destroy() {
        TTAppEventsQueue.clearAll();
        this.stopScheduler();
    }

    private void addToQ(Runnable task) {
        try {
            eventLoop.execute(task);
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
        }
    }

    private void addToLater(Runnable task, int seconds) {
        try {
            eventLoop.schedule(task, (long)seconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            TTCrashHandler.handleCrash(TAG, e);
        }
    }

    public void clearAll() {
        this.addToQ(this::clearAllImmediately);
    }

    private void clearAllImmediately() {
        TTAppEventsQueue.clearAll();
        TTAppEventStorage.clearAll();
    }

    public void fetchGlobalConfig(int delaySeconds) {
        this.addToLater(() -> {
            try {
                this.logger.info("Fetching global config....", new Object[0]);
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("disable" + TTConst.AutoEvents.InstallApp.name, this.autoEventsManager.shouldTrackAppLifecycleEvents(TTConst.AutoEvents.InstallApp) == false);
                options.put("disable" + TTConst.AutoEvents.LaunchAPP.name, this.autoEventsManager.shouldTrackAppLifecycleEvents(TTConst.AutoEvents.LaunchAPP) == false);
                options.put("disable" + TTConst.AutoEvents.SecondDayRetention.name, this.autoEventsManager.shouldTrackAppLifecycleEvents(TTConst.AutoEvents.SecondDayRetention) == false);
                JSONObject requestResult = TTRequest.getBusinessSDKConfig(options);
                if (requestResult == null) {
                    this.logger.info("Opt out of initGlobalConfig because global config is null, api returns error", new Object[0]);
                    return;
                }
                JSONObject businessSdkConfig = (JSONObject)requestResult.get("business_sdk_config");
                Boolean enableSDK = businessSdkConfig.getBoolean("enable_sdk");
                String availableVersion = businessSdkConfig.getString("available_version");
                String trackEventDomain = businessSdkConfig.getString("domain");
                TikTokBusinessSdk.setSdkGlobalSwitch(enableSDK);
                this.logger.debug("enable_sdk=" + enableSDK, new Object[0]);
                if (!enableSDK.booleanValue()) {
                    this.logger.info("Clear all events and stop timers because global switch is not turned on", new Object[0]);
                    this.clearAllImmediately();
                }
                TikTokBusinessSdk.setApiAvailableVersion(availableVersion);
                TikTokBusinessSdk.setApiTrackDomain(trackEventDomain);
                this.logger.debug("available_version=" + availableVersion, new Object[0]);
                TikTokBusinessSdk.setGlobalConfigFetched();
            }
            catch (JSONException e) {
                e.printStackTrace();
                this.logger.warn("Errors happened during initGlobalConfig because the structure of api result is not correct", new Object[0]);
            }
            catch (Exception e) {
                this.logger.warn("Errors occurred during initGlobalConfig because of " + e.getMessage(), new Object[0]);
                e.printStackTrace();
            }
            finally {
                if (TikTokBusinessSdk.isSystemActivated() && !TikTokBusinessSdk.isActivatedLogicRun) {
                    TikTokBusinessSdk.isActivatedLogicRun = true;
                    this.activateSdk();
                }
            }
        }, delaySeconds);
    }

    public void monitorMetric(@NonNull String name, @Nullable JSONObject meta, @Nullable JSONObject extra) {
        if (!metricsEnabled) {
            return;
        }
        this.addToQ(() -> {
            JSONObject stat = new JSONObject();
            try {
                stat = TTRequestBuilder.getHealthMonitorBase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JSONObject monitor = new JSONObject();
            try {
                monitor.put("type", (Object)"metric");
                monitor.put("name", (Object)name);
                if (meta != null) {
                    monitor.put("meta", (Object)meta);
                }
                if (extra != null) {
                    monitor.put("extra", (Object)extra);
                }
                stat.put("monitor", (Object)monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TTCrashHandler.retryLater(stat);
        });
    }

    void persistMonitor() {
        this.addToQ(TTCrashHandler::persistToFile);
    }

    static {
        totalDumped = 0;
        eventLoop = Executors.newSingleThreadScheduledExecutor(new TTThreadFactory());
        timerService = Executors.newSingleThreadScheduledExecutor(new TTThreadFactory());
        metricsEnabled = true;
    }

    public static enum FlushReason {
        THRESHOLD,
        TIMER,
        START_UP,
        FORCE_FLUSH,
        IDENTIFY,
        LOGOUT;

    }
}

