/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTAppEventsQueue;
import com.tiktok.appevents.TTUserInfo;
import com.tiktok.util.TTLogger;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class TTAppEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TTAppEventType type;
    private String eventName;
    private Date timeStamp;
    private String propertiesJson;
    private static AtomicLong counter = new AtomicLong(new Date().getTime() + 0L);
    private Long uniqueId;
    private TTUserInfo userInfo;
    private static String TAG = TTAppEventsQueue.class.getCanonicalName();
    private static TTLogger logger = new TTLogger(TAG, TikTokBusinessSdk.getLogLevel());

    TTAppEvent(TTAppEventType type, String eventName, String propertiesJson) {
        this(type, eventName, new Date(), propertiesJson);
    }

    TTAppEvent(TTAppEventType type, String eventName, Date timeStamp, String propertiesJson) {
        this.type = type;
        this.eventName = eventName;
        this.timeStamp = timeStamp;
        this.propertiesJson = propertiesJson;
        this.uniqueId = counter.getAndIncrement();
        this.userInfo = TTUserInfo.sharedInstance.clone();
    }

    public TTUserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getType() {
        return this.type.name();
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getPropertiesJson() {
        return this.propertiesJson;
    }

    public void setPropertiesJson(String propertiesJson) {
        this.propertiesJson = propertiesJson;
    }

    public Long getUniqueId() {
        return this.uniqueId;
    }

    public String toString() {
        return "TTAppEvent{eventName='" + this.eventName + '\'' + ", timeStamp=" + this.timeStamp + ", propertiesJson='" + this.propertiesJson + '\'' + ", uniqueId=" + this.uniqueId + '}';
    }

    public static enum TTAppEventType {
        track,
        identify;

    }
}

