/*
 * Decompiled with CFR 0.152.
 */
package com.tiktok.appevents;

import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleOwner;
import com.tiktok.TikTokBusinessSdk;
import com.tiktok.appevents.TTAppEventLogger;
import com.tiktok.appevents.TTLifeCycleCallbacksAdapter;
import com.tiktok.util.TTLogger;
import com.tiktok.util.TTUtil;
import org.json.JSONObject;

class TTActivityLifecycleCallbacksListener
extends TTLifeCycleCallbacksAdapter {
    private static final String TAG = TTActivityLifecycleCallbacksListener.class.getCanonicalName();
    private static final TTLogger logger = new TTLogger(TAG, TikTokBusinessSdk.getLogLevel());
    private final TTAppEventLogger appEventLogger;
    private boolean isPaused = false;
    private long fgStart;
    private long bgStart = 0L;

    public TTActivityLifecycleCallbacksListener(TTAppEventLogger appEventLogger) {
        this.appEventLogger = appEventLogger;
        this.fgStart = System.currentTimeMillis();
    }

    @Override
    public void onResume(@NonNull LifecycleOwner owner) {
        if (this.isPaused) {
            this.reportBackground(this.bgStart);
            this.fgStart = System.currentTimeMillis();
            this.appEventLogger.fetchGlobalConfig(0);
            this.appEventLogger.restartScheduler();
            this.appEventLogger.autoEventsManager.track2DayRetentionEvent();
        }
    }

    @Override
    public void onPause(@NonNull LifecycleOwner owner) {
        this.reportForeground(this.fgStart);
        this.bgStart = System.currentTimeMillis();
        this.appEventLogger.stopScheduler();
        this.isPaused = true;
    }

    @Override
    public void onStop(@NonNull LifecycleOwner owner) {
        this.appEventLogger.persistEvents();
        this.appEventLogger.persistMonitor();
    }

    @Override
    public void onDestroy(@NonNull LifecycleOwner owner) {
        this.appEventLogger.stopScheduler();
    }

    private void reportForeground(@NonNull long ts) {
        try {
            long latency = System.currentTimeMillis() - ts;
            JSONObject meta = TTUtil.getMetaWithTS(ts).put("latency", latency);
            this.appEventLogger.monitorMetric("foreground", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reportBackground(@NonNull long ts) {
        try {
            long latency = System.currentTimeMillis() - ts;
            JSONObject meta = TTUtil.getMetaWithTS(ts).put("latency", latency);
            this.appEventLogger.monitorMetric("background", meta, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

