/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.raphael;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.bytedance.raphael.Raphael;
import java.io.File;

public class RaphaelReceiver
extends BroadcastReceiver {
    public void onReceive(Context ctx, Intent intent) {
        String action = intent.getAction();
        if ("com.bytedance.raphael.ACTION_START".equals(action)) {
            Raphael.start(this.getConfigs(intent.getStringExtra("configs")), this.getSpace(ctx), intent.getStringExtra("regex"));
        } else if ("com.bytedance.raphael.ACTION_STOP".equals(action)) {
            Raphael.stop();
        } else if ("com.bytedance.raphael.ACTION_PRINT".equals(action)) {
            Raphael.print();
        }
    }

    int getConfigs(String params) {
        if (TextUtils.isEmpty((CharSequence)params)) {
            return Raphael.MAP64_MODE | Raphael.ALLOC_MODE | Raphael.DIFF_CACHE | 0xF0000 | 0x1000;
        }
        try {
            return Integer.decode(params);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return Raphael.MAP64_MODE | Raphael.ALLOC_MODE | Raphael.DIFF_CACHE | 0xF0000 | 0x1000;
        }
    }

    String getSpace(Context ctx) {
        File space = ctx.getExternalFilesDir("raphael");
        if (!space.exists()) {
            space.mkdir();
        }
        return space.getAbsolutePath();
    }
}

