/*
 * Decompiled with CFR 0.152.
 */
package com.github.burrunan.s3cache.internal;

import com.github.burrunan.s3cache.internal.AwsS3BuildCacheServiceKt;
import com.github.burrunan.s3cache.internal.BuildCacheEntryWriterExtensionsKt;
import com.github.burrunan.s3cache.internal.CacheEntryMetadata;
import com.github.burrunan.s3cache.internal.CurrentTaskKt;
import com.github.burrunan.s3cache.internal.MetadataReaderKt;
import com.github.burrunan.s3cache.internal.Stopwatch;
import com.github.burrunan.s3cache.internal.TaskPerformanceInfo;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.LogLevel;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.StorageClass;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0001,Bi\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0016J\f\u0010)\u001a\u00020\u0006*\u00020#H\u0002J\u001c\u0010*\u001a\u00020\n*\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u001c\u0010+\u001a\u00020 *\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/github/burrunan/s3cache/internal/AwsS3BuildCacheService;", "Lorg/gradle/caching/BuildCacheService;", "s3Factory", "Lkotlin/Function0;", "Lsoftware/amazon/awssdk/services/s3/S3Client;", "bucketName", "", "prefix", "kmsKeyId", "reducedRedundancy", "", "maximumCachedObjectLength", "", "showStatistics", "showStatisticsWhenImpactExceeds", "showStatisticsWhenSavingsExceeds", "showStatisticsWhenWasteExceeds", "showStatisticsWhenTransferExceeds", "(Lkotlin/jvm/functions/Function0;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZJZJJJJ)V", "buildId", "cacheHits", "Lcom/github/burrunan/s3cache/internal/Stopwatch;", "cacheLoadSavings", "cacheLoadWaste", "cacheLoads", "cacheStores", "s3", "getS3", "()Lsoftware/amazon/awssdk/services/s3/S3Client;", "s3$delegate", "Lkotlin/Lazy;", "close", "", "load", "key", "Lorg/gradle/caching/BuildCacheKey;", "reader", "Lorg/gradle/caching/BuildCacheEntryReader;", "store", "writer", "Lorg/gradle/caching/BuildCacheEntryWriter;", "getBucketPath", "loadInternal", "storeInternal", "Companion", "s3-build-cache"})
@SourceDebugExtension(value={"SMAP\nAwsS3BuildCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsS3BuildCacheService.kt\ncom/github/burrunan/s3cache/internal/AwsS3BuildCacheService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
public final class AwsS3BuildCacheService
implements BuildCacheService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bucketName;
    @Nullable
    private final String prefix;
    @Nullable
    private final String kmsKeyId;
    private final boolean reducedRedundancy;
    private final long maximumCachedObjectLength;
    private final boolean showStatistics;
    private final long showStatisticsWhenImpactExceeds;
    private final long showStatisticsWhenSavingsExceeds;
    private final long showStatisticsWhenWasteExceeds;
    private final long showStatisticsWhenTransferExceeds;
    @NotNull
    private final Lazy s3$delegate;
    @NotNull
    private final String buildId;
    @NotNull
    private final Stopwatch cacheLoads;
    @NotNull
    private final Stopwatch cacheLoadSavings;
    @NotNull
    private final Stopwatch cacheLoadWaste;
    @NotNull
    private final Stopwatch cacheHits;
    @NotNull
    private final Stopwatch cacheStores;
    @NotNull
    private static final String BUILD_CACHE_CONTENT_TYPE = "application/vnd.gradle.build-cache-artifact";

    public AwsS3BuildCacheService(@NotNull Function0<? extends S3Client> s3Factory, @NotNull String bucketName, @Nullable String prefix, @Nullable String kmsKeyId, boolean reducedRedundancy, long maximumCachedObjectLength, boolean showStatistics, long showStatisticsWhenImpactExceeds, long showStatisticsWhenSavingsExceeds, long showStatisticsWhenWasteExceeds, long showStatisticsWhenTransferExceeds) {
        Intrinsics.checkNotNullParameter(s3Factory, (String)"s3Factory");
        Intrinsics.checkNotNullParameter((Object)bucketName, (String)"bucketName");
        this.bucketName = bucketName;
        this.prefix = prefix;
        this.kmsKeyId = kmsKeyId;
        this.reducedRedundancy = reducedRedundancy;
        this.maximumCachedObjectLength = maximumCachedObjectLength;
        this.showStatistics = showStatistics;
        this.showStatisticsWhenImpactExceeds = showStatisticsWhenImpactExceeds;
        this.showStatisticsWhenSavingsExceeds = showStatisticsWhenSavingsExceeds;
        this.showStatisticsWhenWasteExceeds = showStatisticsWhenWasteExceeds;
        this.showStatisticsWhenTransferExceeds = showStatisticsWhenTransferExceeds;
        this.s3$delegate = LazyKt.lazy(s3Factory);
        String string = "%x";
        Object[] objectArray = new Object[]{new Random().nextLong()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        this.buildId = string2;
        this.cacheLoads = new Stopwatch();
        this.cacheLoadSavings = new Stopwatch();
        this.cacheLoadWaste = new Stopwatch();
        this.cacheHits = new Stopwatch();
        this.cacheStores = new Stopwatch();
    }

    private final S3Client getS3() {
        Lazy lazy = this.s3$delegate;
        return (S3Client)lazy.getValue();
    }

    public void close() {
        this.getS3().close();
        if (!this.showStatistics) {
            return;
        }
        if (this.cacheLoads.getStarts() != 0) {
            long impact = this.cacheLoadSavings.getElapsed() - this.cacheLoadWaste.getElapsed();
            String summary = this.cacheLoadSavings.getElapsed() == 0L && this.cacheLoadWaste.getElapsed() == 0L ? "no impact" : (this.cacheLoadWaste.getElapsed() == 0L ? AwsS3BuildCacheService.close$savedWasted$default(this.cacheLoadSavings.getElapsed(), null, 1, null) + " on hits" : (this.cacheLoadSavings.getElapsed() == 0L ? AwsS3BuildCacheService.close$savedWasted$default(-this.cacheLoadWaste.getElapsed(), null, 1, null) + " on misses" : AwsS3BuildCacheService.close$savedWasted$default(impact, null, 1, null) + " (" + AwsS3BuildCacheService.close$savedWasted$default(this.cacheLoadSavings.getElapsed(), null, 1, null) + " on hits, " + AwsS3BuildCacheService.close$savedWasted$default(-this.cacheLoadWaste.getElapsed(), null, 1, null) + " on misses)"));
            AwsS3BuildCacheServiceKt.access$getLogger$p().log(Math.abs(impact) > this.showStatisticsWhenImpactExceeds || Math.abs(this.cacheLoadSavings.getElapsed()) > this.showStatisticsWhenSavingsExceeds || Math.abs(this.cacheLoadWaste.getElapsed()) > this.showStatisticsWhenWasteExceeds || this.cacheLoads.getBytes() > this.showStatisticsWhenTransferExceeds ? LogLevel.LIFECYCLE : LogLevel.INFO, "S3 cache " + summary + (this.cacheLoads.getStarts() != this.cacheHits.getStarts() ? ", reads: " + this.cacheLoads.getStarts() : "") + (this.cacheHits.getStarts() != 0 ? ", hits: " + this.cacheHits.getStarts() : "") + (this.cacheLoads.getElapsed() != 0L ? ", elapsed: " + AwsS3BuildCacheService.close$timeUnits(this.cacheLoads.getElapsed()) : "") + (this.cacheLoads.getBytes() != 0L ? ", received: " + AwsS3BuildCacheService.close$byteUnits(this.cacheLoads.getBytes()) : ""));
        }
        if (this.cacheStores.getStarts() != 0) {
            AwsS3BuildCacheServiceKt.access$getLogger$p().lifecycle("S3 cache writes: " + this.cacheStores.getStarts() + ", elapsed: " + AwsS3BuildCacheService.close$timeUnits(this.cacheStores.getElapsed()) + ", sent to cache: " + AwsS3BuildCacheService.close$byteUnits(this.cacheStores.getBytes()));
        }
    }

    private final String getBucketPath(BuildCacheKey $this$getBucketPath) {
        CharSequence charSequence = this.prefix;
        String string = charSequence == null || charSequence.length() == 0 ? $this$getBucketPath.getHashCode() : this.prefix + $this$getBucketPath.getHashCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (prefix.isNullOrEmpty\u2026 \"$prefix$hashCode\"\n    }");
        return string;
    }

    public boolean load(@NotNull BuildCacheKey key, @NotNull BuildCacheEntryReader reader) {
        Object object;
        block0: {
            TaskPerformanceInfo taskPerformanceInfo;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            long loadStarted = this.cacheLoads.getElapsed();
            object = Stopwatch.invoke$default(this.cacheLoads, 0L, (Function1)new Function1<Stopwatch, Boolean>(this, key, reader){
                final /* synthetic */ AwsS3BuildCacheService this$0;
                final /* synthetic */ BuildCacheKey $key;
                final /* synthetic */ BuildCacheEntryReader $reader;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    this.$reader = $reader;
                    super(1);
                }

                public final Boolean invoke(Stopwatch $this$invoke) {
                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                    return AwsS3BuildCacheService.access$loadInternal(this.this$0, $this$invoke, this.$key, this.$reader);
                }
            }, 1, null);
            boolean $this$load_u24lambda_u241 = (Boolean)object;
            boolean bl = false;
            TaskPerformanceInfo taskPerformanceInfo2 = taskPerformanceInfo = CurrentTaskKt.getCURRENT_TASK().get();
            if (taskPerformanceInfo2 == null) break block0;
            Intrinsics.checkNotNullExpressionValue((Object)taskPerformanceInfo2, (String)"get()");
            TaskPerformanceInfo it = taskPerformanceInfo;
            boolean bl2 = false;
            it.setCacheLoadDuration(this.cacheLoads.getElapsed() - loadStarted);
            it.setCacheLoadSavingsStopwatch(this.cacheLoadSavings);
            it.setCacheLoadWasteStopwatch(this.cacheLoadWaste);
        }
        return (Boolean)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean loadInternal(Stopwatch $this$loadInternal, BuildCacheKey key, BuildCacheEntryReader reader) {
        String bucketPath = this.getBucketPath(key);
        AwsS3BuildCacheServiceKt.access$getLogger$p().info("Loading cache entry '{}' from S3 bucket", (Object)bucketPath);
        try {
            Closeable closeable = (Closeable)this.getS3().getObject(new Consumer(this, bucketPath){
                final /* synthetic */ AwsS3BuildCacheService this$0;
                final /* synthetic */ String $bucketPath;
                {
                    this.this$0 = $receiver;
                    this.$bucketPath = $bucketPath;
                }

                public final void accept(GetObjectRequest.Builder it) {
                    it.bucket(AwsS3BuildCacheService.access$getBucketName$p(this.this$0));
                    it.key(this.$bucketPath);
                }
            });
            Throwable throwable = null;
            try {
                TaskPerformanceInfo taskPerformanceInfo;
                ResponseInputStream s3Object = (ResponseInputStream)closeable;
                boolean bl = false;
                Long contentLength = ((GetObjectResponse)s3Object.response()).contentLength();
                Intrinsics.checkNotNullExpressionValue((Object)contentLength, (String)"contentLength");
                if (contentLength > this.maximumCachedObjectLength) {
                    Object[] objectArray = new Object[]{key, bucketPath, contentLength, this.maximumCachedObjectLength};
                    AwsS3BuildCacheServiceKt.access$getLogger$p().info("Cache item '{}' '{}' in S3 bucket size is {}, and it exceeds maximumCachedObjectLength {}. Will skip the retrieval", objectArray);
                    s3Object.abort();
                    boolean bl2 = false;
                    return bl2;
                }
                TaskPerformanceInfo taskPerformanceInfo2 = taskPerformanceInfo = CurrentTaskKt.getCURRENT_TASK().get();
                if (taskPerformanceInfo2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)taskPerformanceInfo2, (String)"get()");
                    TaskPerformanceInfo it = taskPerformanceInfo;
                    boolean bl3 = false;
                    Map map = ((GetObjectResponse)s3Object.response()).metadata();
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"s3Object.response().metadata()");
                    it.setMetadata(MetadataReaderKt.CacheEntryMetadata(map));
                }
                $this$loadInternal.bytesProcessed(contentLength);
                Stopwatch.invoke$default(this.cacheHits, 0L, (Function1)new Function1<Stopwatch, Unit>(reader, (ResponseInputStream<GetObjectResponse>)s3Object){
                    final /* synthetic */ BuildCacheEntryReader $reader;
                    final /* synthetic */ ResponseInputStream<GetObjectResponse> $s3Object;
                    {
                        this.$reader = $reader;
                        this.$s3Object = $s3Object;
                        super(1);
                    }

                    public final void invoke(Stopwatch $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        this.$reader.readFrom((InputStream)this.$s3Object);
                    }
                }, 1, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return true;
        }
        catch (NoSuchBucketException e) {
            throw new BuildCacheException("Bucket '" + this.bucketName + "' not found", (Throwable)e);
        }
        catch (NoSuchKeyException e) {
            Object[] objectArray = new Object[]{key, bucketPath, this.bucketName};
            AwsS3BuildCacheServiceKt.access$getLogger$p().info("Did not find cache item '{}' '{}' in S3 bucket '{}'", objectArray);
        }
        catch (SdkServiceException e) {
            if (e.statusCode() == 403) {
                AwsS3BuildCacheServiceKt.access$getLogger$p().info("Got 403 (Forbidden) when fetching cache item '{}' '{}' in S3 bucket", (Object)key, (Object)bucketPath);
            }
            Object[] objectArray = new Object[]{key, bucketPath, e};
            AwsS3BuildCacheServiceKt.access$getLogger$p().info("Unexpected error when fetching cache item '{}' '{}' in S3 bucket", objectArray);
        }
        return false;
    }

    public void store(@NotNull BuildCacheKey key, @NotNull BuildCacheEntryWriter writer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Stopwatch.invoke$default(this.cacheStores, 0L, (Function1)new Function1<Stopwatch, Unit>(this, key, writer){
            final /* synthetic */ AwsS3BuildCacheService this$0;
            final /* synthetic */ BuildCacheKey $key;
            final /* synthetic */ BuildCacheEntryWriter $writer;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$writer = $writer;
                super(1);
            }

            public final void invoke(Stopwatch $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                AwsS3BuildCacheService.access$storeInternal(this.this$0, $this$invoke, this.$key, this.$writer);
            }
        }, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void storeInternal(Stopwatch $this$storeInternal, BuildCacheKey key, BuildCacheEntryWriter writer) {
        CacheEntryMetadata metadata;
        String bucketPath = this.getBucketPath(key);
        long itemSize = writer.getSize();
        if (itemSize > this.maximumCachedObjectLength) {
            Object[] objectArray = new Object[]{key, bucketPath, itemSize, this.maximumCachedObjectLength};
            AwsS3BuildCacheServiceKt.access$getLogger$p().info("Cache item '{}' '{}' in S3 bucket size is {}, and it exceeds maximumCachedObjectLength {}. Will skip caching it.", objectArray);
            return;
        }
        $this$storeInternal.bytesProcessed(itemSize);
        AwsS3BuildCacheServiceKt.access$getLogger$p().info("Storing cache entry '{}' to S3 bucket", (Object)bucketPath);
        CacheEntryMetadata cacheEntryMetadata = MetadataReaderKt.readBuildMetadata(writer);
        if (cacheEntryMetadata == null) {
            TaskPerformanceInfo taskPerformanceInfo = CurrentTaskKt.getCURRENT_TASK().get();
            if (taskPerformanceInfo != null) {
                TaskPerformanceInfo it = taskPerformanceInfo;
                boolean bl = false;
                cacheEntryMetadata = new CacheEntryMetadata(this.buildId, it.getPath(), System.currentTimeMillis() - it.getExecutionStarted(), System.getProperty("os.name"), GradleVersion.current().toString());
            } else {
                cacheEntryMetadata = null;
            }
        }
        CacheEntryMetadata cacheEntryMetadata2 = metadata = cacheEntryMetadata;
        Map<String, String> userMetadata = cacheEntryMetadata2 != null ? cacheEntryMetadata2.toMap() : null;
        try {
            File file;
            Consumer consumer;
            S3Client s3Client;
            block10: {
                void os;
                ByteArrayOutputStream byteArrayOutputStream;
                RequestBody requestBody;
                S3Client s3Client2;
                Consumer consumer2;
                block9: {
                    void it;
                    s3Client = this.getS3();
                    consumer = new Consumer(this, bucketPath, writer, userMetadata){
                        final /* synthetic */ AwsS3BuildCacheService this$0;
                        final /* synthetic */ String $bucketPath;
                        final /* synthetic */ BuildCacheEntryWriter $writer;
                        final /* synthetic */ Map<String, String> $userMetadata;
                        {
                            this.this$0 = $receiver;
                            this.$bucketPath = $bucketPath;
                            this.$writer = $writer;
                            this.$userMetadata = $userMetadata;
                        }

                        public final void accept(PutObjectRequest.Builder it) {
                            it.bucket(AwsS3BuildCacheService.access$getBucketName$p(this.this$0));
                            it.key(this.$bucketPath);
                            if (AwsS3BuildCacheService.access$getKmsKeyId$p(this.this$0) != null) {
                                it.serverSideEncryption("aws:kms");
                                it.ssekmsKeyId(AwsS3BuildCacheService.access$getKmsKeyId$p(this.this$0));
                            }
                            it.contentLength(Long.valueOf(this.$writer.getSize()));
                            it.contentType("application/vnd.gradle.build-cache-artifact");
                            if (this.$userMetadata != null) {
                                it.metadata(this.$userMetadata);
                            }
                            if (AwsS3BuildCacheService.access$getReducedRedundancy$p(this.this$0)) {
                                it.storageClass(StorageClass.REDUCED_REDUNDANCY);
                            }
                        }
                    };
                    file = BuildCacheEntryWriterExtensionsKt.file(writer);
                    if (file == null) break block9;
                    File bl = file;
                    consumer2 = consumer;
                    s3Client2 = s3Client;
                    boolean bl2 = false;
                    requestBody = RequestBody.fromFile((File)it);
                    s3Client = s3Client2;
                    consumer = consumer2;
                    RequestBody requestBody2 = requestBody;
                    file = requestBody2;
                    if (requestBody2 != null) break block10;
                }
                ByteArrayOutputStream it = byteArrayOutputStream = new ByteArrayOutputStream();
                consumer2 = consumer;
                s3Client2 = s3Client;
                boolean bl = false;
                writer.writeTo((OutputStream)os);
                requestBody = Unit.INSTANCE;
                s3Client = s3Client2;
                consumer = consumer2;
                file = RequestBody.fromBytes((byte[])byteArrayOutputStream.toByteArray());
            }
            s3Client.putObject(consumer, (RequestBody)file);
        }
        catch (SdkException e) {
            throw new BuildCacheException("Error while storing cache object in S3 bucket " + e.getMessage(), (Throwable)e);
        }
    }

    private static final String close$byteUnits(long $this$close_u24byteUnits) {
        return $this$close_u24byteUnits < 5120L ? $this$close_u24byteUnits + " B" : ($this$close_u24byteUnits < 6164480L ? ($this$close_u24byteUnits + 512L) / 1024L + " KiB" : ($this$close_u24byteUnits < 6312427520L ? ($this$close_u24byteUnits + 524288L) / 0x100000L + " MiB" : ($this$close_u24byteUnits + 0x20000000L) / 0x40000000L + " GiB"));
    }

    private static final String close$timeUnits(long $this$close_u24timeUnits) {
        String string;
        if ($this$close_u24timeUnits == 0L) {
            string = "0s";
        } else if ($this$close_u24timeUnits < 2000L) {
            string = $this$close_u24timeUnits + "ms";
        } else if ($this$close_u24timeUnits < 120000L) {
            string = "" + ($this$close_u24timeUnits + (long)500) / (long)1000 + 's';
        } else {
            long seconds = ($this$close_u24timeUnits + (long)500) / (long)1000;
            long minutes = seconds / (long)60;
            long hours = minutes / (long)60;
            if (hours > 0L) {
                String string2 = "%02d:%02d:%02d";
                Object[] objectArray = new Object[]{hours % (long)60, minutes % (long)60, seconds % (long)60};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                String string4 = "%02d:%02d";
                Object[] objectArray = new Object[]{minutes % (long)60, seconds % (long)60};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            }
        }
        return string;
    }

    private static final String close$savedWasted(long $this$close_u24savedWasted, String noImpact) {
        return $this$close_u24savedWasted > 0L ? AwsS3BuildCacheService.close$timeUnits($this$close_u24savedWasted) + " saved" : ($this$close_u24savedWasted < 0L ? AwsS3BuildCacheService.close$timeUnits(-$this$close_u24savedWasted) + " wasted" : noImpact);
    }

    static /* synthetic */ String close$savedWasted$default(long l, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "no impact";
        }
        return AwsS3BuildCacheService.close$savedWasted(l, string);
    }

    public static final /* synthetic */ boolean access$loadInternal(AwsS3BuildCacheService $this, Stopwatch $receiver, BuildCacheKey key, BuildCacheEntryReader reader) {
        return $this.loadInternal($receiver, key, reader);
    }

    public static final /* synthetic */ String access$getBucketName$p(AwsS3BuildCacheService $this) {
        return $this.bucketName;
    }

    public static final /* synthetic */ void access$storeInternal(AwsS3BuildCacheService $this, Stopwatch $receiver, BuildCacheKey key, BuildCacheEntryWriter writer) {
        $this.storeInternal($receiver, key, writer);
    }

    public static final /* synthetic */ String access$getKmsKeyId$p(AwsS3BuildCacheService $this) {
        return $this.kmsKeyId;
    }

    public static final /* synthetic */ boolean access$getReducedRedundancy$p(AwsS3BuildCacheService $this) {
        return $this.reducedRedundancy;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/burrunan/s3cache/internal/AwsS3BuildCacheService$Companion;", "", "()V", "BUILD_CACHE_CONTENT_TYPE", "", "s3-build-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

