/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.volley;

import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.toolbox.HttpHeaderParser;
import com.bumptech.glide.Priority;
import com.bumptech.glide.integration.volley.VolleyRequestFactory;
import com.bumptech.glide.integration.volley.VolleyRequestFuture;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

public class VolleyStreamFetcher
implements DataFetcher<InputStream> {
    public static final VolleyRequestFactory DEFAULT_REQUEST_FACTORY = new VolleyRequestFactory(){

        @Override
        public Request<byte[]> create(String url, VolleyRequestFuture<InputStream> future, Request.Priority priority, Map<String, String> headers) {
            return new GlideRequest(url, future, priority, headers);
        }
    };
    private final RequestQueue requestQueue;
    private final VolleyRequestFactory requestFactory;
    private final GlideUrl url;
    private VolleyRequestFuture<InputStream> requestFuture;

    public VolleyStreamFetcher(RequestQueue requestQueue, GlideUrl url) {
        this(requestQueue, url, null);
    }

    public VolleyStreamFetcher(RequestQueue requestQueue, GlideUrl url, VolleyRequestFuture<InputStream> requestFuture) {
        this(requestQueue, url, requestFuture, DEFAULT_REQUEST_FACTORY);
    }

    public VolleyStreamFetcher(RequestQueue requestQueue, GlideUrl url, VolleyRequestFuture<InputStream> requestFuture, VolleyRequestFactory requestFactory) {
        this.requestQueue = requestQueue;
        this.url = url;
        this.requestFactory = requestFactory;
        this.requestFuture = requestFuture;
        if (requestFuture == null) {
            this.requestFuture = VolleyRequestFuture.newFuture();
        }
    }

    public InputStream loadData(Priority priority) throws Exception {
        String stringUrl = this.url.toStringUrl();
        Request<byte[]> request = this.requestFactory.create(stringUrl, this.requestFuture, VolleyStreamFetcher.glideToVolleyPriority(priority), this.url.getHeaders());
        this.requestFuture.setRequest(this.requestQueue.add(request));
        return this.requestFuture.get();
    }

    public void cleanup() {
    }

    public String getId() {
        return this.url.getCacheKey();
    }

    public void cancel() {
        VolleyRequestFuture<InputStream> localFuture = this.requestFuture;
        if (localFuture != null) {
            localFuture.cancel(true);
        }
    }

    private static Request.Priority glideToVolleyPriority(Priority priority) {
        switch (priority) {
            case LOW: {
                return Request.Priority.LOW;
            }
            case HIGH: {
                return Request.Priority.HIGH;
            }
            case IMMEDIATE: {
                return Request.Priority.IMMEDIATE;
            }
        }
        return Request.Priority.NORMAL;
    }

    private static class GlideRequest
    extends Request<byte[]> {
        private final VolleyRequestFuture<InputStream> future;
        private final Request.Priority priority;
        private final Map<String, String> headers;

        public GlideRequest(String url, VolleyRequestFuture<InputStream> future, Request.Priority priority) {
            this(url, future, priority, Collections.emptyMap());
        }

        public GlideRequest(String url, VolleyRequestFuture<InputStream> future, Request.Priority priority, Map<String, String> headers) {
            super(0, url, future);
            this.future = future;
            this.priority = priority;
            this.headers = headers;
        }

        public Map<String, String> getHeaders() throws AuthFailureError {
            return this.headers;
        }

        public Request.Priority getPriority() {
            return this.priority;
        }

        protected Response<byte[]> parseNetworkResponse(NetworkResponse response) {
            return Response.success((Object)response.data, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }

        protected void deliverResponse(byte[] response) {
            this.future.onResponse(new ByteArrayInputStream(response));
        }
    }
}

