/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.volley;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class VolleyRequestFuture<T>
implements Future<T>,
Response.Listener<T>,
Response.ErrorListener {
    private Request<?> mRequest;
    private boolean mResultReceived = false;
    private T mResult;
    private VolleyError mException;
    private boolean mIsCancelled = false;

    public static <E> VolleyRequestFuture<E> newFuture() {
        return new VolleyRequestFuture();
    }

    public synchronized void setRequest(Request<?> request) {
        this.mRequest = request;
        if (this.mIsCancelled && this.mRequest != null) {
            this.mRequest.cancel();
        }
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.mIsCancelled = true;
        if (this.mRequest != null) {
            this.mRequest.cancel();
        }
        this.notifyAll();
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.doGet(null);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doGet(TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    private synchronized T doGet(Long timeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.mException != null) {
            throw new ExecutionException((Throwable)this.mException);
        }
        if (this.mResultReceived) {
            return this.mResult;
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (timeoutMs == null) {
            this.wait(0L);
        } else if (timeoutMs > 0L) {
            this.wait(timeoutMs);
        }
        if (this.mException != null) {
            throw new ExecutionException((Throwable)this.mException);
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (!this.mResultReceived) {
            throw new TimeoutException();
        }
        return this.mResult;
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.mResultReceived || this.mException != null || this.isCancelled();
    }

    public synchronized void onResponse(T response) {
        this.mResultReceived = true;
        this.mResult = response;
        this.notifyAll();
    }

    public synchronized void onErrorResponse(VolleyError error) {
        this.mException = error;
        this.notifyAll();
    }
}

