/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.volley;

import android.content.Context;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.bumptech.glide.integration.volley.VolleyRequestFuture;
import com.bumptech.glide.integration.volley.VolleyStreamFetcher;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GenericLoaderFactory;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import java.io.InputStream;

public class VolleyUrlLoader
implements ModelLoader<GlideUrl, InputStream> {
    private final RequestQueue requestQueue;

    public VolleyUrlLoader(RequestQueue requestQueue) {
        this.requestQueue = requestQueue;
    }

    public DataFetcher<InputStream> getResourceFetcher(GlideUrl url, int width, int height) {
        return new VolleyStreamFetcher(this.requestQueue, url, new VolleyRequestFuture<InputStream>());
    }

    public static class Factory
    implements ModelLoaderFactory<GlideUrl, InputStream> {
        private static RequestQueue internalQueue;
        private RequestQueue requestQueue;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static RequestQueue getInternalQueue(Context context) {
            if (internalQueue != null) return internalQueue;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (internalQueue != null) return internalQueue;
                internalQueue = Volley.newRequestQueue((Context)context);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return internalQueue;
            }
        }

        public Factory(Context context) {
            this(Factory.getInternalQueue(context));
        }

        public Factory(RequestQueue requestQueue) {
            this.requestQueue = requestQueue;
        }

        public ModelLoader<GlideUrl, InputStream> build(Context context, GenericLoaderFactory factories) {
            return new VolleyUrlLoader(this.requestQueue);
        }

        public void teardown() {
        }
    }
}

