/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.volley;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.toolbox.HttpHeaderParser;
import com.bumptech.glide.Priority;
import com.bumptech.glide.integration.volley.VolleyRequestFuture;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class VolleyStreamFetcher
implements DataFetcher<InputStream> {
    private final RequestQueue requestQueue;
    private final GlideUrl url;
    private VolleyRequestFuture<InputStream> requestFuture;

    public VolleyStreamFetcher(RequestQueue requestQueue, GlideUrl url) {
        this(requestQueue, url, null);
    }

    public VolleyStreamFetcher(RequestQueue requestQueue, GlideUrl url, VolleyRequestFuture<InputStream> requestFuture) {
        this.requestQueue = requestQueue;
        this.url = url;
        this.requestFuture = requestFuture;
        if (requestFuture == null) {
            this.requestFuture = VolleyRequestFuture.newFuture();
        }
    }

    public InputStream loadData(Priority priority) throws Exception {
        String stringUrl = this.url.toURL().toString();
        GlideRequest request = new GlideRequest(stringUrl, this.requestFuture, VolleyStreamFetcher.glideToVolleyPriority(priority));
        this.requestFuture.setRequest(this.requestQueue.add((Request)request));
        return this.requestFuture.get();
    }

    public void cleanup() {
    }

    public String getId() {
        return this.url.toString();
    }

    public void cancel() {
        VolleyRequestFuture<InputStream> localFuture = this.requestFuture;
        if (localFuture != null) {
            localFuture.cancel(true);
        }
    }

    private static Request.Priority glideToVolleyPriority(Priority priority) {
        switch (priority) {
            case LOW: {
                return Request.Priority.LOW;
            }
            case HIGH: {
                return Request.Priority.HIGH;
            }
            case IMMEDIATE: {
                return Request.Priority.IMMEDIATE;
            }
        }
        return Request.Priority.NORMAL;
    }

    private static class GlideRequest
    extends Request<byte[]> {
        private final VolleyRequestFuture<InputStream> future;
        private Request.Priority priority;

        public GlideRequest(String url, VolleyRequestFuture<InputStream> future, Request.Priority priority) {
            super(0, url, future);
            this.future = future;
            this.priority = priority;
        }

        public Request.Priority getPriority() {
            return this.priority;
        }

        protected Response<byte[]> parseNetworkResponse(NetworkResponse response) {
            return Response.success((Object)response.data, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }

        protected void deliverResponse(byte[] response) {
            this.future.onResponse(new ByteArrayInputStream(response));
        }
    }
}

