/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.okhttp;

import com.bumptech.glide.Priority;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.util.ContentLengthInputStream;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class OkHttpStreamFetcher
implements DataFetcher<InputStream> {
    private final OkHttpClient client;
    private final GlideUrl url;
    private InputStream stream;
    private ResponseBody responseBody;

    public OkHttpStreamFetcher(OkHttpClient client, GlideUrl url) {
        this.client = client;
        this.url = url;
    }

    public InputStream loadData(Priority priority) throws Exception {
        Request.Builder requestBuilder = new Request.Builder().url(this.url.toStringUrl());
        for (Map.Entry headerEntry : this.url.getHeaders().entrySet()) {
            String key = (String)headerEntry.getKey();
            requestBuilder.addHeader(key, (String)headerEntry.getValue());
        }
        Request request = requestBuilder.build();
        Response response = this.client.newCall(request).execute();
        this.responseBody = response.body();
        if (!response.isSuccessful()) {
            throw new IOException("Request failed with code: " + response.code());
        }
        long contentLength = this.responseBody.contentLength();
        this.stream = ContentLengthInputStream.obtain((InputStream)this.responseBody.byteStream(), (long)contentLength);
        return this.stream;
    }

    public void cleanup() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.responseBody != null) {
            try {
                this.responseBody.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getId() {
        return this.url.getCacheKey();
    }

    public void cancel() {
    }
}

