/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.gifdecoder;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bumptech.glide.gifdecoder.GifHeader;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public interface GifDecoder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    public static final int STATUS_PARTIAL_DECODE = 3;
    public static final int TOTAL_ITERATION_COUNT_FOREVER = 0;

    public int getWidth();

    public int getHeight();

    @NonNull
    public ByteBuffer getData();

    public int getStatus();

    public void advance();

    public int getDelay(int var1);

    public int getNextDelay();

    public int getFrameCount();

    public int getCurrentFrameIndex();

    public void resetFrameIndex();

    @Deprecated
    public int getLoopCount();

    public int getNetscapeLoopCount();

    public int getTotalIterationCount();

    public int getByteSize();

    @Nullable
    public Bitmap getNextFrame();

    public int read(@Nullable InputStream var1, int var2);

    public void clear();

    public void setData(@NonNull GifHeader var1, @NonNull byte[] var2);

    public void setData(@NonNull GifHeader var1, @NonNull ByteBuffer var2);

    public void setData(@NonNull GifHeader var1, @NonNull ByteBuffer var2, int var3);

    public int read(@Nullable byte[] var1);

    public void setDefaultBitmapConfig(@NonNull Bitmap.Config var1);

    public static interface BitmapProvider {
        @NonNull
        public Bitmap obtain(int var1, int var2, @NonNull Bitmap.Config var3);

        public void release(@NonNull Bitmap var1);

        @NonNull
        public byte[] obtainByteArray(int var1);

        public void release(@NonNull byte[] var1);

        @NonNull
        public int[] obtainIntArray(int var1);

        public void release(@NonNull int[] var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GifDecodeStatus {
    }
}

