/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.Excludes;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class AppModuleGenerator {
    static final String GENERATED_ROOT_MODULE_PACKAGE_NAME = "com.bumptech.glide";
    private static final String GLIDE_LOG_TAG = "Glide";
    private static final String GENERATED_APP_MODULE_IMPL_SIMPLE_NAME = "GeneratedAppGlideModuleImpl";
    private static final String GENERATED_ROOT_MODULE_SIMPLE_NAME = "GeneratedAppGlideModule";
    private final ProcessingEnvironment processingEnv;
    private final ProcessorUtil processorUtil;

    AppModuleGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processingEnv = processingEnv;
        this.processorUtil = processorUtil;
    }

    TypeSpec generate(TypeElement appGlideModule, Set<String> libraryGlideModuleClassNames) {
        ClassName appGlideModuleClassName = ClassName.get((TypeElement)appGlideModule);
        List<String> excludedGlideModuleClassNames = this.getExcludedGlideModuleClassNames(appGlideModule);
        ArrayList<String> orderedLibraryGlideModuleClassNames = new ArrayList<String>(libraryGlideModuleClassNames);
        Collections.sort(orderedLibraryGlideModuleClassNames);
        MethodSpec constructor = this.generateConstructor(appGlideModuleClassName, orderedLibraryGlideModuleClassNames, excludedGlideModuleClassNames);
        MethodSpec registerComponents = this.generateRegisterComponents(orderedLibraryGlideModuleClassNames, excludedGlideModuleClassNames);
        MethodSpec getExcludedModuleClasses = this.generateGetExcludedModuleClasses(excludedGlideModuleClassNames);
        MethodSpec applyOptions = MethodSpec.methodBuilder((String)"applyOptions").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), (String)"context", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)GENERATED_ROOT_MODULE_PACKAGE_NAME, (String)"GlideBuilder", (String[])new String[0]), (String)"builder", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addStatement("appGlideModule.applyOptions(context, builder)", new Object[]{appGlideModule}).build();
        MethodSpec isManifestParsingEnabled = MethodSpec.methodBuilder((String)"isManifestParsingEnabled").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Boolean.TYPE).addStatement("return appGlideModule.isManifestParsingEnabled()", new Object[]{appGlideModule}).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)GENERATED_APP_MODULE_IMPL_SIMPLE_NAME).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"deprecation"}).build()).superclass((TypeName)ClassName.get((String)GENERATED_ROOT_MODULE_PACKAGE_NAME, (String)GENERATED_ROOT_MODULE_SIMPLE_NAME, (String[])new String[0])).addField((TypeName)appGlideModuleClassName, "appGlideModule", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(constructor).addMethod(applyOptions).addMethod(registerComponents).addMethod(isManifestParsingEnabled).addMethod(getExcludedModuleClasses);
        ClassName generatedRequestManagerFactoryClassName = ClassName.get((String)GENERATED_ROOT_MODULE_PACKAGE_NAME, (String)"GeneratedRequestManagerFactory", (String[])new String[0]);
        builder.addMethod(MethodSpec.methodBuilder((String)"getRequestManagerFactory").addAnnotation(Override.class).addAnnotation(this.processorUtil.nonNull()).returns((TypeName)generatedRequestManagerFactoryClassName).addStatement("return new $T()", new Object[]{generatedRequestManagerFactoryClassName}).build());
        return builder.build();
    }

    private MethodSpec generateGetExcludedModuleClasses(Collection<String> excludedClassNames) {
        WildcardTypeName wildCardOfObject = WildcardTypeName.subtypeOf(Object.class);
        ParameterizedTypeName classOfWildcardOfObjet = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{wildCardOfObject});
        ParameterizedTypeName setOfClassOfWildcardOfObject = ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{classOfWildcardOfObjet});
        ParameterizedTypeName hashSetOfClassOfWildcardOfObject = ParameterizedTypeName.get((ClassName)ClassName.get(HashSet.class), (TypeName[])new TypeName[]{classOfWildcardOfObjet});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getExcludedModuleClasses").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addAnnotation(this.processorUtil.nonNull()).returns((TypeName)setOfClassOfWildcardOfObject);
        if (excludedClassNames.isEmpty()) {
            builder.addStatement("return $T.emptySet()", new Object[]{Collections.class});
        } else {
            builder.addStatement("$T excludedClasses = new $T()", new Object[]{setOfClassOfWildcardOfObject, hashSetOfClassOfWildcardOfObject});
            for (String excludedClassName : excludedClassNames) {
                builder.addStatement("excludedClasses.add($L.class)", new Object[]{excludedClassName});
            }
            builder.addStatement("return excludedClasses", new Object[0]);
        }
        return builder.build();
    }

    private MethodSpec generateRegisterComponents(Collection<String> libraryGlideModuleClassNames, Collection<String> excludedGlideModuleClassNames) {
        MethodSpec.Builder registerComponents = MethodSpec.methodBuilder((String)"registerComponents").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), (String)"context", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)GENERATED_ROOT_MODULE_PACKAGE_NAME, (String)GLIDE_LOG_TAG, (String[])new String[0]), (String)"glide", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build()).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)GENERATED_ROOT_MODULE_PACKAGE_NAME, (String)"Registry", (String[])new String[0]), (String)"registry", (Modifier[])new Modifier[0]).addAnnotation(this.processorUtil.nonNull()).build());
        for (String glideModule : libraryGlideModuleClassNames) {
            if (excludedGlideModuleClassNames.contains(glideModule)) continue;
            ClassName moduleClassName = ClassName.bestGuess((String)glideModule);
            registerComponents.addStatement("new $T().registerComponents(context, glide, registry)", new Object[]{moduleClassName});
        }
        registerComponents.addStatement("appGlideModule.registerComponents(context, glide, registry)", new Object[0]);
        return registerComponents.build();
    }

    private boolean doesAppGlideModuleConstructorAcceptContext(ClassName appGlideModule) {
        TypeElement appGlideModuleType = this.processingEnv.getElementUtils().getTypeElement(appGlideModule.reflectionName());
        for (Element element : appGlideModuleType.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ExecutableElement constructor = (ExecutableElement)element;
            List<? extends VariableElement> parameters = constructor.getParameters();
            if (parameters.isEmpty()) {
                return false;
            }
            if (parameters.size() > 1) {
                throw new IllegalStateException("Constructor for " + String.valueOf(appGlideModule) + " accepts too many parameters, it should accept no parameters, or a single Context");
            }
            VariableElement parameter = parameters.get(0);
            TypeMirror parameterType = parameter.asType();
            TypeMirror contextType = this.processingEnv.getElementUtils().getTypeElement("android.content.Context").asType();
            if (!this.processingEnv.getTypeUtils().isSameType(parameterType, contextType)) {
                throw new IllegalStateException("Unrecognized type: " + String.valueOf(parameterType));
            }
            return true;
        }
        return false;
    }

    private MethodSpec generateConstructor(ClassName appGlideModule, Collection<String> libraryGlideModuleClassNames, Collection<String> excludedGlideModuleClassNames) {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), (String)"context", (Modifier[])new Modifier[0]).build());
        if (this.doesAppGlideModuleConstructorAcceptContext(appGlideModule)) {
            constructorBuilder.addStatement("appGlideModule = new $T(context)", new Object[]{appGlideModule});
        } else {
            constructorBuilder.addStatement("appGlideModule = new $T()", new Object[]{appGlideModule});
        }
        ClassName androidLogName = ClassName.get((String)"android.util", (String)"Log", (String[])new String[0]);
        constructorBuilder.beginControlFlow("if ($T.isLoggable($S, $T.DEBUG))", new Object[]{androidLogName, GLIDE_LOG_TAG, androidLogName});
        constructorBuilder.addStatement("$T.d($S, $S)", new Object[]{androidLogName, GLIDE_LOG_TAG, "Discovered AppGlideModule from annotation: " + String.valueOf(appGlideModule)});
        for (String glideModule : libraryGlideModuleClassNames) {
            if (excludedGlideModuleClassNames.contains(glideModule)) {
                constructorBuilder.addStatement("$T.d($S, $S)", new Object[]{androidLogName, GLIDE_LOG_TAG, "AppGlideModule excludes LibraryGlideModule from annotation: " + glideModule});
                continue;
            }
            constructorBuilder.addStatement("$T.d($S, $S)", new Object[]{androidLogName, GLIDE_LOG_TAG, "Discovered LibraryGlideModule from annotation: " + glideModule});
        }
        constructorBuilder.endControlFlow();
        return constructorBuilder.build();
    }

    private List<String> getExcludedGlideModuleClassNames(TypeElement appGlideModule) {
        ImmutableSet<String> names = this.processorUtil.findClassValuesFromAnnotationOnClassAsNames(appGlideModule, Excludes.class);
        ArrayList<String> result = new ArrayList<String>((Collection<String>)names);
        Collections.sort(result);
        return result;
    }
}

