/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.annotation.compiler.AppModuleGenerator;
import com.bumptech.glide.annotation.compiler.GlideAnnotationProcessor;
import com.bumptech.glide.annotation.compiler.GlideGenerator;
import com.bumptech.glide.annotation.compiler.Index;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.annotation.compiler.RequestBuilderGenerator;
import com.bumptech.glide.annotation.compiler.RequestManagerFactoryGenerator;
import com.bumptech.glide.annotation.compiler.RequestManagerGenerator;
import com.bumptech.glide.annotation.compiler.RequestOptionsGenerator;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

final class AppModuleProcessor {
    private static final String COMPILER_PACKAGE_NAME = GlideAnnotationProcessor.class.getPackage().getName();
    private final ProcessingEnvironment processingEnv;
    private final ProcessorUtil processorUtil;
    private final List<TypeElement> appGlideModules = new ArrayList<TypeElement>();
    private final RequestOptionsGenerator requestOptionsGenerator;
    private final RequestManagerGenerator requestManagerGenerator;
    private final AppModuleGenerator appModuleGenerator;
    private final RequestBuilderGenerator requestBuilderGenerator;
    private final RequestManagerFactoryGenerator requestManagerFactoryGenerator;
    private final GlideGenerator glideGenerator;

    AppModuleProcessor(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processingEnv = processingEnv;
        this.processorUtil = processorUtil;
        this.appModuleGenerator = new AppModuleGenerator(processorUtil);
        this.requestOptionsGenerator = new RequestOptionsGenerator(processingEnv, processorUtil);
        this.requestManagerGenerator = new RequestManagerGenerator(processingEnv, processorUtil);
        this.requestManagerFactoryGenerator = new RequestManagerFactoryGenerator(processingEnv);
        this.glideGenerator = new GlideGenerator(processingEnv, processorUtil);
        this.requestBuilderGenerator = new RequestBuilderGenerator(processingEnv, processorUtil);
    }

    void processModules(Set<? extends TypeElement> set, RoundEnvironment env) {
        for (TypeElement element : this.processorUtil.getElementsFor(GlideModule.class, env)) {
            if (!this.processorUtil.isAppGlideModule(element)) continue;
            this.appGlideModules.add(element);
        }
        this.processorUtil.debugLog("got app modules: " + this.appGlideModules);
        if (this.appGlideModules.size() > 1) {
            throw new IllegalStateException("You cannot have more than one AppGlideModule, found: " + this.appGlideModules);
        }
    }

    boolean maybeWriteAppModule() {
        if (this.appGlideModules.isEmpty()) {
            return false;
        }
        TypeElement appModule = this.appGlideModules.get(0);
        this.processorUtil.debugLog("Processing app module: " + appModule);
        PackageElement glideGenPackage = this.processingEnv.getElementUtils().getPackageElement(COMPILER_PACKAGE_NAME);
        FoundIndexedClassNames indexedClassNames = this.getIndexedClassNames(glideGenPackage);
        String generatedCodePackageName = appModule.getEnclosingElement().toString();
        TypeSpec generatedRequestOptions = this.requestOptionsGenerator.generate(generatedCodePackageName, indexedClassNames.extensions);
        this.writeRequestOptions(generatedCodePackageName, generatedRequestOptions);
        TypeSpec generatedRequestBuilder = this.requestBuilderGenerator.generate(generatedCodePackageName, indexedClassNames.extensions, generatedRequestOptions);
        this.writeRequestBuilder(generatedCodePackageName, generatedRequestBuilder);
        TypeSpec requestManager = this.requestManagerGenerator.generate(generatedCodePackageName, generatedRequestOptions, generatedRequestBuilder, indexedClassNames.extensions);
        this.writeRequestManager(generatedCodePackageName, requestManager);
        TypeSpec requestManagerFactory = this.requestManagerFactoryGenerator.generate(generatedCodePackageName, requestManager);
        this.writeRequestManagerFactory(requestManagerFactory);
        TypeSpec glide = this.glideGenerator.generate(generatedCodePackageName, this.getGlideName(appModule), requestManager);
        this.writeGlide(generatedCodePackageName, glide);
        TypeSpec generatedAppGlideModule = this.appModuleGenerator.generate(appModule, indexedClassNames.glideModules);
        this.writeAppModule(generatedAppGlideModule);
        this.processorUtil.infoLog("Wrote GeneratedAppGlideModule with: " + indexedClassNames.glideModules);
        return true;
    }

    private String getGlideName(TypeElement appModule) {
        return appModule.getAnnotation(GlideModule.class).glideName();
    }

    private FoundIndexedClassNames getIndexedClassNames(PackageElement glideGenPackage) {
        HashSet glideModules = new HashSet();
        HashSet extensions = new HashSet();
        List<? extends Element> glideGeneratedElements = glideGenPackage.getEnclosedElements();
        for (Element element : glideGeneratedElements) {
            Index annotation = element.getAnnotation(Index.class);
            if (annotation == null) continue;
            Collections.addAll(glideModules, annotation.modules());
            Collections.addAll(extensions, annotation.extensions());
        }
        this.processorUtil.debugLog("Found GlideModules: " + glideModules);
        return new FoundIndexedClassNames(glideModules, extensions);
    }

    private void writeGlide(String packageName, TypeSpec glide) {
        this.processorUtil.writeClass(packageName, glide);
    }

    private void writeRequestManager(String packageName, TypeSpec requestManager) {
        this.processorUtil.writeClass(packageName, requestManager);
    }

    private void writeRequestManagerFactory(TypeSpec requestManagerFactory) {
        this.processorUtil.writeClass("com.bumptech.glide", requestManagerFactory);
    }

    private void writeAppModule(TypeSpec appModule) {
        this.processorUtil.writeClass("com.bumptech.glide", appModule);
    }

    private void writeRequestOptions(String packageName, TypeSpec requestOptions) {
        this.processorUtil.writeClass(packageName, requestOptions);
    }

    private void writeRequestBuilder(String packageName, TypeSpec requestBuilder) {
        this.processorUtil.writeClass(packageName, requestBuilder);
    }

    private static final class FoundIndexedClassNames {
        private final Set<String> glideModules;
        private final Set<String> extensions;

        private FoundIndexedClassNames(Set<String> glideModules, Set<String> extensions) {
            this.glideModules = glideModules;
            this.extensions = extensions;
        }
    }
}

