/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideType;
import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.bumptech.glide.repackaged.com.google.common.base.Function;
import com.bumptech.glide.repackaged.com.google.common.base.Predicate;
import com.bumptech.glide.repackaged.com.google.common.base.Predicates;
import com.bumptech.glide.repackaged.com.google.common.collect.FluentIterable;
import com.bumptech.glide.repackaged.com.google.common.collect.Lists;
import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.MethodSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.ParameterizedTypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeVariableName;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class RequestManagerGenerator {
    private static final ClassName CHECK_RESULT_CLASS_NAME = ClassName.get("android.support.annotation", "CheckResult", new String[0]);
    private static final ClassName CONTEXT_CLASS_NAME = ClassName.get("android.content", "Context", new String[0]);
    private ProcessingEnvironment processingEnv;
    private final ProcessorUtil processorUtil;
    private final ClassName requestManagerClassName;
    private final TypeElement lifecycleType;
    private final TypeElement requestManagerTreeNodeType;
    private final TypeElement glideType;
    private final TypeElement requestManagerType;
    private final TypeElement requestBuilderType;
    private ClassName generatedRequestBuilderClassName;

    RequestManagerGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processingEnv = processingEnv;
        this.processorUtil = processorUtil;
        Elements elementUtils = processingEnv.getElementUtils();
        this.requestManagerType = elementUtils.getTypeElement("com.bumptech.glide.RequestManager");
        this.requestManagerClassName = ClassName.get(this.requestManagerType);
        this.lifecycleType = elementUtils.getTypeElement("com.bumptech.glide.manager.Lifecycle");
        this.requestManagerTreeNodeType = elementUtils.getTypeElement("com.bumptech.glide.manager.RequestManagerTreeNode");
        this.requestBuilderType = elementUtils.getTypeElement("com.bumptech.glide.RequestBuilder");
        this.glideType = elementUtils.getTypeElement("com.bumptech.glide.Glide");
    }

    TypeSpec generate(String generatedCodePackageName, TypeSpec requestOptions, TypeSpec requestBuilder, Set<String> glideExtensions) {
        this.generatedRequestBuilderClassName = ClassName.get(generatedCodePackageName, requestBuilder.name, new String[0]);
        return TypeSpec.classBuilder("GlideRequests").superclass(this.requestManagerClassName).addJavadoc("Includes all additions from methods in {@link $T}s\nannotated with {@link $T}\n\n<p>Generated code, do not modify\n", GlideExtension.class, GlideType.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "deprecation").build()).addModifiers(Modifier.PUBLIC).addMethod(this.generateAsMethod(generatedCodePackageName, requestBuilder)).addMethod(this.generateCallSuperConstructor()).addMethods(this.generateExtensionRequestManagerMethods(glideExtensions)).addMethods(this.generateRequestManagerRequestManagerMethodOverrides(generatedCodePackageName)).addMethods(this.generateRequestManagerRequestBuilderMethodOverrides()).addMethods(FluentIterable.from(Collections.singletonList(this.generateOverrideSetRequestOptions(generatedCodePackageName, requestOptions))).filter(Predicates.notNull())).build();
    }

    private MethodSpec generateCallSuperConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterSpec.builder(ClassName.get(this.glideType), "glide", new Modifier[0]).addAnnotation(ProcessorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(ClassName.get(this.lifecycleType), "lifecycle", new Modifier[0]).addAnnotation(ProcessorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(ClassName.get(this.requestManagerTreeNodeType), "treeNode", new Modifier[0]).addAnnotation(ProcessorUtil.nonNull()).build()).addParameter(ParameterSpec.builder(CONTEXT_CLASS_NAME, "context", new Modifier[0]).addAnnotation(ProcessorUtil.nonNull()).build()).addStatement("super(glide, lifecycle, treeNode, context)", new Object[0]).build();
    }

    private MethodSpec generateAsMethod(String generatedCodePackageName, TypeSpec requestBuilder) {
        TypeVariableName resourceType = TypeVariableName.get("ResourceType");
        ParameterizedTypeName classOfResouceType = ParameterizedTypeName.get(ClassName.get(Class.class), resourceType);
        ClassName generatedRequestBuilderClassName = ClassName.get(generatedCodePackageName, requestBuilder.name, new String[0]);
        ParameterizedTypeName requestBuilderOfResourceType = ParameterizedTypeName.get(generatedRequestBuilderClassName, resourceType);
        return MethodSpec.methodBuilder("as").addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(CHECK_RESULT_CLASS_NAME).build()).addAnnotation(ProcessorUtil.nonNull()).addTypeVariable(TypeVariableName.get("ResourceType")).returns(requestBuilderOfResourceType).addParameter(classOfResouceType.annotated(AnnotationSpec.builder(ProcessorUtil.nonNull()).build()), "resourceClass", new Modifier[0]).addStatement("return new $T<>(glide, this, resourceClass, context)", this.generatedRequestBuilderClassName).build();
    }

    private List<MethodSpec> generateRequestManagerRequestManagerMethodOverrides(final String generatedPackageName) {
        return FluentIterable.from(this.processorUtil.findInstanceMethodsReturning(this.requestManagerType, this.requestManagerType)).transform(new Function<ExecutableElement, MethodSpec>(){

            @Override
            public MethodSpec apply(ExecutableElement input) {
                return RequestManagerGenerator.this.generateRequestManagerRequestManagerMethodOverride(generatedPackageName, input);
            }
        }).toList();
    }

    private MethodSpec generateRequestManagerRequestManagerMethodOverride(String generatedPackageName, ExecutableElement method) {
        ClassName generatedRequestManagerName = ClassName.get(generatedPackageName, "GlideRequests", new String[0]);
        MethodSpec.Builder returns = ProcessorUtil.overriding(method).addAnnotation(ProcessorUtil.nonNull()).returns(generatedRequestManagerName);
        return returns.addCode(ProcessorUtil.generateCastingSuperCall(generatedRequestManagerName, returns.build())).build();
    }

    private List<MethodSpec> generateRequestManagerRequestBuilderMethodOverrides() {
        TypeMirror rawRequestBuilder = this.processingEnv.getTypeUtils().erasure(this.requestBuilderType.asType());
        return FluentIterable.from(this.processorUtil.findInstanceMethodsReturning(this.requestManagerType, rawRequestBuilder)).filter(new Predicate<ExecutableElement>(){

            @Override
            public boolean apply(ExecutableElement input) {
                return !input.getSimpleName().toString().equals("as");
            }
        }).transform(new Function<ExecutableElement, MethodSpec>(){

            @Override
            public MethodSpec apply(ExecutableElement input) {
                return RequestManagerGenerator.this.generateRequestManagerRequestBuilderMethodOverride(input);
            }
        }).toList();
    }

    private MethodSpec generateRequestManagerRequestBuilderMethodOverride(ExecutableElement methodToOverride) {
        TypeMirror typeArgument = ((DeclaredType)methodToOverride.getReturnType()).getTypeArguments().get(0);
        ParameterizedTypeName generatedRequestBuilderOfType = ParameterizedTypeName.get(this.generatedRequestBuilderClassName, ClassName.get(typeArgument));
        MethodSpec.Builder builder = ProcessorUtil.overriding(methodToOverride).returns(generatedRequestBuilderOfType);
        builder.addCode(ProcessorUtil.generateCastingSuperCall(generatedRequestBuilderOfType, builder.build()));
        for (AnnotationMirror annotationMirror : methodToOverride.getAnnotationMirrors()) {
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
        return builder.build();
    }

    private List<MethodSpec> generateExtensionRequestManagerMethods(Set<String> glideExtensions) {
        List<ExecutableElement> requestManagerExtensionMethods = this.processorUtil.findAnnotatedElementsInClasses(glideExtensions, GlideType.class);
        return Lists.transform(requestManagerExtensionMethods, new Function<ExecutableElement, MethodSpec>(){

            @Override
            public MethodSpec apply(ExecutableElement input) {
                return RequestManagerGenerator.this.generateAdditionalRequestManagerMethod(input);
            }
        });
    }

    private MethodSpec generateAdditionalRequestManagerMethod(ExecutableElement extensionMethod) {
        if (extensionMethod.getReturnType().getKind() == TypeKind.VOID) {
            return this.generateAdditionalRequestManagerMethodLegacy(extensionMethod);
        }
        return this.generateAdditionalRequestManagerMethodNew(extensionMethod);
    }

    private MethodSpec generateAdditionalRequestManagerMethodLegacy(ExecutableElement extensionMethod) {
        String returnType = this.processorUtil.findClassValuesFromAnnotationOnClassAsNames(extensionMethod, GlideType.class).iterator().next();
        ClassName returnTypeClassName = ClassName.bestGuess(returnType);
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get(this.generatedRequestBuilderClassName, returnTypeClassName);
        return MethodSpec.methodBuilder(extensionMethod.getSimpleName().toString()).addModifiers(Modifier.PUBLIC).returns(parameterizedTypeName).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(extensionMethod)).addAnnotation(ProcessorUtil.nonNull()).addAnnotation(AnnotationSpec.builder(CHECK_RESULT_CLASS_NAME).build()).addStatement("$T requestBuilder = this.as($T.class)", parameterizedTypeName, returnTypeClassName).addStatement("$T.$N(requestBuilder)", extensionMethod.getEnclosingElement(), extensionMethod.getSimpleName()).addStatement("return requestBuilder", new Object[0]).build();
    }

    private MethodSpec generateAdditionalRequestManagerMethodNew(ExecutableElement extensionMethod) {
        String returnType = this.processorUtil.findClassValuesFromAnnotationOnClassAsNames(extensionMethod, GlideType.class).iterator().next();
        ClassName returnTypeClassName = ClassName.bestGuess(returnType);
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get(this.generatedRequestBuilderClassName, returnTypeClassName);
        return MethodSpec.methodBuilder(extensionMethod.getSimpleName().toString()).addModifiers(Modifier.PUBLIC).returns(parameterizedTypeName).addJavadoc(this.processorUtil.generateSeeMethodJavadoc(extensionMethod)).addAnnotation(ProcessorUtil.nonNull()).addAnnotation(AnnotationSpec.builder(CHECK_RESULT_CLASS_NAME).build()).addStatement("return ($T) $T.$N(this.as($T.class))", parameterizedTypeName, extensionMethod.getEnclosingElement(), extensionMethod.getSimpleName(), returnTypeClassName).build();
    }

    private MethodSpec generateOverrideSetRequestOptions(String generatedCodePackageName, TypeSpec generatedRequestOptions) {
        if (generatedRequestOptions == null) {
            return null;
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement requestOptionsType = elementUtils.getTypeElement("com.bumptech.glide.request.RequestOptions");
        String generatedRequestOptionsQualifiedName = generatedCodePackageName + "." + generatedRequestOptions.name;
        String methodName = "setRequestOptions";
        String parameterName = "toSet";
        return MethodSpec.methodBuilder(methodName).addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).addParameter(ParameterSpec.builder(ClassName.get(requestOptionsType), parameterName, new Modifier[0]).addAnnotation(ProcessorUtil.nonNull()).build()).beginControlFlow("if ($N instanceof $L)", parameterName, generatedRequestOptionsQualifiedName).addStatement("super.$N($N)", methodName, parameterName).nextControlFlow("else", new Object[0]).addStatement("super.setRequestOptions(new $L().apply($N))", generatedRequestOptionsQualifiedName, parameterName).endControlFlow().build();
    }
}

