/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.repackaged.com.google.common.collect;

import com.bumptech.glide.repackaged.com.google.common.collect.Hashing;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableMap;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableMapEntry;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableMapEntrySet;
import com.bumptech.glide.repackaged.com.google.common.collect.ImmutableSet;
import java.util.Map;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map.Entry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;

    static void checkNoConflictInKeyBucket(Object key, Map.Entry<?, ?> entry, ImmutableMapEntry<?, ?> keyBucketHead) {
        while (keyBucketHead != null) {
            RegularImmutableMap.checkNoConflict(!key.equals(keyBucketHead.getKey()), "key", entry, keyBucketHead);
            keyBucketHead = keyBucketHead.getNextInKeyBucket();
        }
    }

    @Override
    public V get(Object key) {
        return RegularImmutableMap.get(key, this.table, this.mask);
    }

    static <V> V get(Object key, ImmutableMapEntry<?, V>[] keyTable, int mask) {
        if (key == null) {
            return null;
        }
        int index = Hashing.smear(key.hashCode()) & mask;
        for (ImmutableMapEntry<?, V> entry = keyTable[index]; entry != null; entry = entry.getNextInKeyBucket()) {
            Object candidateKey = entry.getKey();
            if (!key.equals(candidateKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }
}

