/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.avif;

import android.graphics.Bitmap;
import android.util.Log;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.util.Preconditions;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.aomedia.avif.android.AvifDecoder;

public final class AvifByteBufferBitmapDecoder
implements ResourceDecoder<ByteBuffer, Bitmap> {
    private static final String TAG = "AvifBitmapDecoder";
    private final BitmapPool bitmapPool;

    public AvifByteBufferBitmapDecoder(BitmapPool bitmapPool) {
        this.bitmapPool = (BitmapPool)Preconditions.checkNotNull((Object)bitmapPool);
    }

    private ByteBuffer maybeCopyBuffer(ByteBuffer source) {
        if (source.isDirect()) {
            return source;
        }
        ByteBuffer sourceCopy = ByteBuffer.allocateDirect(source.remaining());
        sourceCopy.put(source);
        sourceCopy.flip();
        return sourceCopy;
    }

    @Nullable
    public Resource<Bitmap> decode(ByteBuffer source, int width, int height, Options options) {
        ByteBuffer sourceCopy = this.maybeCopyBuffer(source);
        AvifDecoder.Info info = new AvifDecoder.Info();
        if (!AvifDecoder.getInfo((ByteBuffer)sourceCopy, (int)sourceCopy.remaining(), (AvifDecoder.Info)info)) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"Requested to decode byte buffer which cannot be handled by AvifDecoder");
            }
            return null;
        }
        Bitmap bitmap = this.bitmapPool.get(info.width, info.height, info.depth == 8 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGBA_F16);
        if (!AvifDecoder.decode((ByteBuffer)sourceCopy, (int)sourceCopy.remaining(), (Bitmap)bitmap)) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"Failed to decode ByteBuffer as Avif.");
            }
            this.bitmapPool.put(bitmap);
            return null;
        }
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.bitmapPool);
    }

    public boolean handles(ByteBuffer source, Options options) {
        return AvifDecoder.isAvifImage((ByteBuffer)this.maybeCopyBuffer(source));
    }
}

