/*
 * Decompiled with CFR 0.152.
 */
package com.github.buchandersenn.android_permission_manager;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v13.app.FragmentCompat;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;

public class PermissionUtil {
    static boolean checkPermissions(Context context, @NonNull String[] permissions) {
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    static boolean shouldShowPermissionRationale(Activity activity, @NonNull String[] permissions) {
        for (String permission : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) continue;
            return true;
        }
        return false;
    }

    static boolean shouldShowPermissionRationale(Fragment fragment, @NonNull String[] permissions) {
        for (String permission : permissions) {
            if (!FragmentCompat.shouldShowRequestPermissionRationale((Fragment)fragment, (String)permission)) continue;
            return true;
        }
        return false;
    }

    static boolean verifyPermissionResults(@NonNull int[] grantResults) {
        if (grantResults.length < 1) {
            return false;
        }
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }
}

