/*
 * Decompiled with CFR 0.152.
 */
package com.github.brunodles.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WebClient {
    public static final int LOG_NONE = 0;
    public static final int LOG_URL = 1;
    public static final int LOG_BODY = 2;
    public static final String crlf = "\r\n";
    public static final String twoHyphens = "--";
    public static final String boundary = "*****";
    public static final int BUFFER_SIZE = 1024;
    public static final String CONTENT_TYPE = "Content-Type";
    private final String USER_AGENT = "Mozilla/5.0";
    private String method = "GET";
    private String out;
    private Map<String, String> urlParams = new HashMap<String, String>();
    private Map<String, String> postParams = new HashMap<String, String>();
    private Map<String, File> fileParams = new HashMap<String, File>();
    private Map<String, String> requestProperties = new HashMap<String, String>();
    private int timout;
    private final String urlStr;
    private int logLevel = 0;

    public WebClient(String urlStr) {
        this.urlStr = urlStr;
    }

    public WebClient setTimeout(Integer timeout) {
        this.timout = timeout;
        return this;
    }

    public WebClient setOut(String out) {
        this.out = out;
        return this;
    }

    public WebClient setContentType(String type) {
        return this.addRequestProperty(CONTENT_TYPE, type);
    }

    public WebClient setContentTypeJson() {
        return this.setContentType("application/json");
    }

    public WebClient setContentTypeMultipartFormData() {
        return this.setContentType("multipart/form-data;boundary=*****");
    }

    public WebClient addRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
        return this;
    }

    public WebClient addUrlParameter(String key, String value) {
        this.urlParams.put(key, value);
        return this;
    }

    public WebClient addPostParameter(String key, String value) {
        this.postParams.put(key, value);
        return this;
    }

    public WebClient addFileParameter(String key, File file) {
        this.fileParams.put(key, file);
        return this;
    }

    public WebClient setLogLevel(int logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public Response doGet() throws IOException {
        return this.doMethod("GET");
    }

    public Response doPost() throws IOException {
        return this.doMethod("POST");
    }

    public Response doPut() throws IOException {
        return this.doMethod("PUT");
    }

    public Response doMethod(String methodName) throws IOException {
        this.method = methodName;
        return this.execute();
    }

    private Response execute() throws IOException {
        String urlParams = this.buildParams(this.urlParams);
        String requestUrl = this.urlStr + "?" + urlParams;
        if (this.logLevel == 1) {
            System.out.println("requestUrl " + requestUrl);
        }
        URL url = new URL(requestUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", "Mozilla/5.0");
        con.setConnectTimeout(this.timout);
        con.setRequestMethod(this.method);
        this.buildProperties(con);
        if (this.isMultiPart()) {
            this.writeMultiPartOut(con, this.postParams, this.fileParams);
        } else if (this.out != null) {
            this.writeOut(con, this.out);
        } else if (!this.postParams.isEmpty()) {
            this.writeOut(con, this.buildParams(this.postParams));
        }
        int responseCode = con.getResponseCode();
        String response = this.readResponse(con);
        return new Response(responseCode, response);
    }

    private boolean isMultiPart() {
        if (!this.requestProperties.containsKey(CONTENT_TYPE)) {
            return false;
        }
        return this.requestProperties.get(CONTENT_TYPE).contains("multipart");
    }

    private String buildParams(Map<String, String> map) throws UnsupportedEncodingException {
        StringBuilder paramsStr = new StringBuilder();
        boolean first = true;
        Set<Map.Entry<String, String>> params = map.entrySet();
        for (Map.Entry<String, String> entry : params) {
            if (first) {
                first = false;
            } else {
                paramsStr.append("&");
            }
            paramsStr.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return paramsStr.toString();
    }

    private void buildProperties(HttpURLConnection con) {
        for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
            con.addRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    private void writeMultiPartOut(HttpURLConnection con, Map<String, String> params, Map<String, File> fileParams) throws IOException {
        con.setDoOutput(true);
        OutputStream os = con.getOutputStream();
        DataOutputStream wr = new DataOutputStream(os);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            wr.writeBytes("--*****\r\n");
            wr.writeBytes("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + crlf);
            wr.writeBytes("Content-Type: text/plain\r\n");
            wr.writeBytes(crlf);
            wr.writeBytes(entry.getValue());
            wr.writeBytes(crlf);
        }
        for (Map.Entry<String, Object> entry : fileParams.entrySet()) {
            File file = (File)entry.getValue();
            wr.writeBytes("--*****\r\n");
            wr.writeBytes("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + file.getName() + "\"" + crlf);
            wr.writeBytes("Content-Type: text/plain\r\n");
            wr.writeBytes("Content-Transfer-Encoding: binary\r\n");
            wr.writeBytes(crlf);
            FileInputStream fileInputStream = new FileInputStream(file);
            int bytesAvailable = fileInputStream.available();
            int bufferSize = Math.min(bytesAvailable, 1024);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                wr.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, 1024);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            wr.writeBytes(crlf);
        }
        wr.writeBytes("--*****--");
        wr.flush();
        wr.close();
    }

    private void writeOut(HttpURLConnection con, String out) throws IOException {
        if (this.logLevel == 2) {
            System.out.println("body " + out);
        }
        con.setDoOutput(true);
        OutputStream os = con.getOutputStream();
        WebClient.writeOutputStream(os, out);
    }

    public static void writeOutputStream(OutputStream os, String out1) throws IOException {
        DataOutputStream wr = new DataOutputStream(os);
        wr.writeBytes(out1);
        wr.flush();
        wr.close();
    }

    private String readResponse(HttpURLConnection con) throws IOException {
        InputStream is = con.getInputStream();
        return WebClient.readInputStream(is);
    }

    public static String readInputStream(InputStream is) throws IOException {
        StringBuilder builder = new StringBuilder();
        byte[] buffer = new byte[1024];
        int size = 0;
        while ((size = is.read(buffer)) > 0) {
            builder.append(new String(buffer, 0, size));
        }
        is.close();
        return builder.toString();
    }

    public static class Response {
        public Integer code;
        public String response;

        private Response(Integer code, String response) {
            this.code = code;
            this.response = response;
        }

        public String toString() {
            return "Response{code=" + this.code + ", response=" + this.response + '}';
        }
    }
}

