/*
 * Decompiled with CFR 0.152.
 */
package com.github.brunodles.simplepreferences.lib.parsers;

import android.content.SharedPreferences;
import com.github.brunodles.simplepreferences.lib.Parser;
import com.github.brunodles.simplepreferences.lib.ParserHelper;
import com.github.brunodles.simplepreferences.lib.Property;
import java.lang.reflect.Field;

public class IntegerParser
implements Parser {
    @Override
    public boolean canResolve(Class<?> fieldType) {
        return fieldType.isAssignableFrom(Integer.class) || fieldType.isAssignableFrom(Integer.TYPE);
    }

    @Override
    public void save(SharedPreferences.Editor editor, Field field, Object object, Property annotation) throws IllegalAccessException {
        editor.putInt(ParserHelper.resolveKey(field), ParserHelper.getValue(field, object, 0).intValue());
    }

    @Override
    public void load(SharedPreferences preferences, Field field, Object object, Property annotation) throws IllegalAccessException {
        Integer defaultValue = ParserHelper.getValue(field, object, 0);
        Integer value = preferences.getInt(ParserHelper.resolveKey(field), defaultValue.intValue());
        field.set(object, value);
    }
}

