/*
 * Decompiled with CFR 0.152.
 */
package com.wafflecopter.multicontactpicker.RxContacts;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import android.support.annotation.NonNull;
import android.util.LongSparseArray;
import com.wafflecopter.multicontactpicker.LimitColumn;
import com.wafflecopter.multicontactpicker.RxContacts.ColumnMapper;
import com.wafflecopter.multicontactpicker.RxContacts.Contact;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;

public class RxContacts {
    private static final String DISPLAY_NAME = Build.VERSION.SDK_INT >= 11 ? "display_name" : "display_name";
    private static final Uri PHONE_CONTENT_URI = ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
    private static final Uri EMAIL_CONTENT_URI = ContactsContract.CommonDataKinds.Email.CONTENT_URI;
    private static final String[] PROJECTION = new String[]{"_id", "in_visible_group", DISPLAY_NAME, "starred", "photo_uri", "photo_thumb_uri", "has_phone_number"};
    private static final String[] EMAIL_PROJECTION = new String[]{"contact_id", "data1"};
    private static final String[] NUMBER_PROJECTION = new String[]{"contact_id", "data1", "data2", "data3"};
    private ContentResolver mResolver;
    private Context mContext;

    public static Observable<Contact> fetch(final @NonNull LimitColumn columnLimitChoice, final @NonNull Context context) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Contact>(){

            public void subscribe(@NonNull ObservableEmitter<Contact> e) throws Exception {
                new RxContacts(context).fetch(columnLimitChoice, e);
            }
        });
    }

    private RxContacts(@NonNull Context context) {
        this.mContext = context;
        this.mResolver = context.getContentResolver();
    }

    private void fetch(LimitColumn columnLimitChoice, ObservableEmitter emitter) {
        LongSparseArray contacts = new LongSparseArray();
        Cursor cursor = this.createCursor(this.getFilter(columnLimitChoice));
        cursor.moveToFirst();
        int idColumnIndex = cursor.getColumnIndex("_id");
        int inVisibleGroupColumnIndex = cursor.getColumnIndex("in_visible_group");
        int displayNamePrimaryColumnIndex = cursor.getColumnIndex(DISPLAY_NAME);
        int starredColumnIndex = cursor.getColumnIndex("starred");
        int photoColumnIndex = cursor.getColumnIndex("photo_uri");
        int thumbnailColumnIndex = cursor.getColumnIndex("photo_thumb_uri");
        int hasPhoneNumberColumnIndex = cursor.getColumnIndex("has_phone_number");
        while (!cursor.isAfterLast()) {
            long id2 = cursor.getLong(idColumnIndex);
            Contact contact = (Contact)contacts.get(id2, null);
            if (contact == null) {
                contact = new Contact(id2);
            }
            ColumnMapper.mapInVisibleGroup(cursor, contact, inVisibleGroupColumnIndex);
            ColumnMapper.mapDisplayName(cursor, contact, displayNamePrimaryColumnIndex);
            ColumnMapper.mapStarred(cursor, contact, starredColumnIndex);
            ColumnMapper.mapPhoto(cursor, contact, photoColumnIndex);
            ColumnMapper.mapThumbnail(cursor, contact, thumbnailColumnIndex);
            switch (columnLimitChoice) {
                case EMAIL: {
                    this.getEmail(id2, contact);
                    break;
                }
                case PHONE: {
                    this.getPhoneNumber(id2, cursor, contact, hasPhoneNumberColumnIndex);
                    break;
                }
                case NONE: {
                    this.getEmail(id2, contact);
                    this.getPhoneNumber(id2, cursor, contact, hasPhoneNumberColumnIndex);
                }
            }
            if (columnLimitChoice == LimitColumn.EMAIL) {
                if (contact.getEmails().size() > 0) {
                    contacts.put(id2, (Object)contact);
                    emitter.onNext((Object)contact);
                }
            } else {
                contacts.put(id2, (Object)contact);
                emitter.onNext((Object)contact);
            }
            cursor.moveToNext();
        }
        cursor.close();
        emitter.onComplete();
    }

    private void getEmail(long id2, Contact contact) {
        Cursor emailCursor = this.mResolver.query(EMAIL_CONTENT_URI, EMAIL_PROJECTION, "contact_id = ?", new String[]{String.valueOf(id2)}, null);
        if (emailCursor != null) {
            int emailDataColumnIndex = emailCursor.getColumnIndex("data1");
            if (emailCursor.moveToFirst()) {
                ColumnMapper.mapEmail(emailCursor, contact, emailDataColumnIndex);
            }
            emailCursor.close();
        }
    }

    private void getPhoneNumber(long id2, Cursor cursor, Contact contact, int hasPhoneNumberColumnIndex) {
        Cursor phoneCursor;
        int hasPhoneNumber = Integer.parseInt(cursor.getString(hasPhoneNumberColumnIndex));
        if (hasPhoneNumber > 0 && (phoneCursor = this.mResolver.query(PHONE_CONTENT_URI, NUMBER_PROJECTION, "contact_id = ?", new String[]{String.valueOf(id2)}, null)) != null) {
            phoneCursor.moveToFirst();
            int phoneNumberColumnIndex = phoneCursor.getColumnIndex("data1");
            int phoneNumberTypeIndex = phoneCursor.getColumnIndex("data2");
            int labelColIndex = phoneCursor.getColumnIndex("data3");
            while (!phoneCursor.isAfterLast()) {
                ColumnMapper.mapPhoneNumber(this.mContext, phoneCursor, contact, phoneNumberColumnIndex, phoneNumberTypeIndex, labelColIndex);
                phoneCursor.moveToNext();
            }
            phoneCursor.close();
        }
    }

    private String getFilter(LimitColumn limitColumn) {
        switch (limitColumn) {
            case PHONE: {
                return "has_phone_number > 0";
            }
        }
        return null;
    }

    private Cursor createCursor(String filter) {
        return this.mResolver.query(ContactsContract.Contacts.CONTENT_URI, PROJECTION, filter, null, "_id");
    }
}

